/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.processor.binding.RestBindingProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.IntrospectionSupport;

@XmlRootElement(name="restBinding")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestBindingDefinition
extends NoOutputDefinition<RestBindingDefinition> {
    @XmlAttribute
    private String consumes;
    @XmlAttribute
    private String produces;
    @XmlAttribute
    private RestBindingMode bindingMode;
    @XmlAttribute
    private String type;
    @XmlAttribute
    private String outType;

    public String toString() {
        return "RestBinding";
    }

    @Override
    public String getShortName() {
        return "restBinding";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        CamelContext context = routeContext.getCamelContext();
        String mode = context.getRestConfiguration().getBindingMode().name();
        if (this.bindingMode != null) {
            mode = this.bindingMode.name();
        }
        if (mode == null || "off".equals(mode)) {
            return new RestBindingProcessor(null, null, null, null, this.consumes, this.produces, mode);
        }
        String name = context.getRestConfiguration().getJsonDataFormat();
        if (name == null) {
            name = "json-jackson";
        }
        DataFormat json = context.resolveDataFormat(name);
        DataFormat outJson = context.resolveDataFormat(name);
        if (mode.contains("json") && json == null) {
            throw new IllegalArgumentException("JSon DataFormat " + name + " not found.");
        }
        if (json != null) {
            Class<?> clazz = null;
            if (this.type != null) {
                String typeName = this.type.endsWith("[]") ? this.type.substring(0, this.type.length() - 2) : this.type;
                clazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (clazz != null) {
                IntrospectionSupport.setProperty(context.getTypeConverter(), json, "unmarshalType", clazz);
                IntrospectionSupport.setProperty(context.getTypeConverter(), json, "useList", (Object)this.type.endsWith("[]"));
            }
            this.setAdditionalConfiguration(context, json);
            context.addService(json);
            Class<?> outClazz = null;
            if (this.outType != null) {
                String typeName = this.outType.endsWith("[]") ? this.outType.substring(0, this.outType.length() - 2) : this.outType;
                outClazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (outClazz != null) {
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJson, "unmarshalType", outClazz);
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJson, "useList", (Object)this.outType.endsWith("[]"));
            }
            this.setAdditionalConfiguration(context, outJson);
            context.addService(outJson);
        }
        if ((name = context.getRestConfiguration().getXmlDataFormat()) == null) {
            name = "jaxb";
        }
        DataFormat jaxb = context.resolveDataFormat(name);
        DataFormat outJaxb = context.resolveDataFormat(name);
        if (mode.contains("xml") && jaxb == null) {
            throw new IllegalArgumentException("XML DataFormat " + name + " not found.");
        }
        if (jaxb != null) {
            JAXBContext jc;
            Class<?> clazz = null;
            if (this.type != null) {
                String typeName = this.type.endsWith("[]") ? this.type.substring(0, this.type.length() - 2) : this.type;
                clazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (clazz != null) {
                JAXBContext jc2 = JAXBContext.newInstance((Class[])new Class[]{clazz});
                IntrospectionSupport.setProperty(context.getTypeConverter(), jaxb, "context", jc2);
            }
            if (context.getRestConfiguration().getDataFormatProperties() != null) {
                IntrospectionSupport.setProperties(context.getTypeConverter(), jaxb, context.getRestConfiguration().getDataFormatProperties());
            }
            this.setAdditionalConfiguration(context, jaxb);
            context.addService(jaxb);
            Class<?> outClazz = null;
            if (this.outType != null) {
                String typeName = this.outType.endsWith("[]") ? this.outType.substring(0, this.outType.length() - 2) : this.outType;
                outClazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (outClazz != null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{outClazz});
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJaxb, "context", jc);
            } else if (clazz != null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJaxb, "context", jc);
            }
            this.setAdditionalConfiguration(context, outJaxb);
            context.addService(outJaxb);
        }
        return new RestBindingProcessor(json, jaxb, outJson, outJaxb, this.consumes, this.produces, mode);
    }

    private void setAdditionalConfiguration(CamelContext context, DataFormat dataFormat) throws Exception {
        if (context.getRestConfiguration().getDataFormatProperties() != null && !context.getRestConfiguration().getDataFormatProperties().isEmpty()) {
            HashMap<String, Object> copy = new HashMap<String, Object>();
            copy.putAll(context.getRestConfiguration().getDataFormatProperties());
            IntrospectionSupport.setProperties(context.getTypeConverter(), dataFormat, copy);
        }
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public RestBindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(RestBindingMode bindingMode) {
        this.bindingMode = bindingMode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOutType() {
        return this.outType;
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }
}

