/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.SegmentMemory;

public class SegmentPropagator {
    public static void propagate(SegmentMemory sourceSegment, LeftTupleSets leftTuples, InternalWorkingMemory wm) {
        if (leftTuples.isEmpty()) {
            return;
        }
        LeftTupleSource source = (LeftTupleSource)sourceSegment.getTipNode();
        if (sourceSegment.isEmpty()) {
            SegmentUtilities.createChildSegments(wm, sourceSegment, source.getSinkPropagator());
        }
        SegmentPropagator.processPeers(sourceSegment, leftTuples);
    }

    private static void processPeers(SegmentMemory sourceSegment, LeftTupleSets leftTuples) {
        LeftTuple peer;
        SegmentMemory smem;
        LeftTuple leftTuple;
        SegmentMemory firstSmem = (SegmentMemory)sourceSegment.getFirst();
        SegmentPropagator.processPeerDeletes(leftTuples, leftTuples.getDeleteFirst(), firstSmem);
        SegmentPropagator.processPeerDeletes(leftTuples, leftTuples.getNormalizedDeleteFirst(), firstSmem);
        for (leftTuple = leftTuples.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            smem = firstSmem.getNext();
            if (smem == null) continue;
            for (peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                if (peer.getStagedType() == 0) {
                    peer.setPropagationContext(leftTuple.getPropagationContext());
                    smem.getStagedLeftTuples().addUpdate(peer);
                }
                smem = smem.getNext();
            }
        }
        for (leftTuple = leftTuples.getInsertFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            smem = firstSmem.getNext();
            if (smem == null) continue;
            peer = leftTuple;
            while (smem != null) {
                if (peer.getPeer() != null) {
                    peer = peer.getPeer();
                    peer.setPropagationContext(leftTuple.getPropagationContext());
                    PhreakJoinNode.updateChildLeftTuple(peer, smem.getStagedLeftTuples(), smem.getStagedLeftTuples());
                } else {
                    peer = ((LeftTupleSink)smem.getRootNode()).createPeer(peer);
                    smem.getStagedLeftTuples().addInsert(peer);
                }
                smem = smem.getNext();
            }
        }
        firstSmem.getStagedLeftTuples().addAll(leftTuples);
        leftTuples.resetAll();
    }

    private static void processPeerDeletes(LeftTupleSets leftTuples, LeftTuple leftTuple, SegmentMemory firstSmem) {
        while (leftTuple != null) {
            SegmentMemory smem = firstSmem.getNext();
            if (smem != null) {
                for (LeftTuple peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                    peer.setPropagationContext(leftTuple.getPropagationContext());
                    LeftTupleSets stagedLeftTuples = smem.getStagedLeftTuples();
                    stagedLeftTuples.addDelete(peer);
                    smem = smem.getNext();
                }
            }
            leftTuple = leftTuple.getStagedNext();
        }
    }
}

