/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.jaxb;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.kie.api.command.Command;
import org.kie.api.task.model.User;
import org.kie.remote.client.jaxb.ConversionUtil;
import org.kie.remote.client.jaxb.JaxbWrapper;
import org.kie.remote.jaxb.gen.Comment;
import org.kie.services.client.serialization.jaxb.impl.AbstractJaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbPaginatedList;

@XmlRootElement(name="task-comment-list-response")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class JaxbTaskCommentListResponse
extends AbstractJaxbCommandResponse<List<org.kie.api.task.model.Comment>>
implements JaxbPaginatedList<Comment> {
    @XmlElements(value={@XmlElement(name="task-comment", type=Comment.class)})
    @JsonTypeInfo(defaultImpl=Comment.class, use=JsonTypeInfo.Id.CLASS)
    private List<Comment> commentList;
    @XmlElement(name="page-number")
    @XmlSchemaType(name="int")
    private Integer pageNumber;
    @XmlElement(name="page-size")
    @XmlSchemaType(name="int")
    private Integer pageSize;

    public JaxbTaskCommentListResponse() {
        this.commentList = new ArrayList<Comment>();
    }

    public JaxbTaskCommentListResponse(List<Comment> commentList) {
        this.commentList = commentList;
    }

    public JaxbTaskCommentListResponse(List<Comment> commentList, int i, Command<?> cmd) {
        super(Integer.valueOf(i), cmd);
        this.commentList = commentList;
    }

    public List<org.kie.api.task.model.Comment> getResult() {
        ArrayList<org.kie.api.task.model.Comment> result = new ArrayList<org.kie.api.task.model.Comment>(this.commentList.size());
        for (Comment genComment : this.commentList) {
            result.add(new JaxbWrapper.JaxbCommentWrapper(genComment));
        }
        return result;
    }

    public void setResult(List<org.kie.api.task.model.Comment> result) {
        ArrayList<Comment> newCommentList = null;
        if (result != null) {
            newCommentList = new ArrayList<Comment>(result.size());
            for (org.kie.api.task.model.Comment kieComment : result) {
                Comment genComment = new Comment();
                genComment.setAddedAt(ConversionUtil.convertDateToXmlGregorianCalendar(kieComment.getAddedAt()));
                User addedByUser = kieComment.getAddedBy();
                if (addedByUser != null) {
                    genComment.setAddedBy(addedByUser.getId());
                }
                genComment.setId(genComment.getId());
                genComment.setText(genComment.getText());
                newCommentList.add(genComment);
            }
        }
        this.commentList = newCommentList;
    }

    public void addContents(List<Comment> contentList) {
        this.commentList = contentList;
    }

    @JsonTypeInfo(defaultImpl=Comment.class, use=JsonTypeInfo.Id.CLASS)
    public List<Comment> getList() {
        return this.commentList;
    }

    @JsonTypeInfo(defaultImpl=Comment.class, use=JsonTypeInfo.Id.CLASS)
    public void setList(List<Comment> result) {
        this.commentList = result;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer page) {
        this.pageNumber = page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}

