/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api.command;

import java.util.Collection;
import java.util.Map;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.rule.Agenda;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.ViewChangedEventListener;
import org.kie.api.time.SessionClock;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.remote.client.api.exception.MissingRequiredInfoException;
import org.kie.remote.client.jaxb.ConversionUtil;
import org.kie.remote.jaxb.gen.AbortProcessInstanceCommand;
import org.kie.remote.jaxb.gen.AbortWorkItemCommand;
import org.kie.remote.jaxb.gen.CompleteWorkItemCommand;
import org.kie.remote.jaxb.gen.FireAllRulesCommand;
import org.kie.remote.jaxb.gen.GetFactCountCommand;
import org.kie.remote.jaxb.gen.GetGlobalCommand;
import org.kie.remote.jaxb.gen.GetProcessInstanceByCorrelationKeyCommand;
import org.kie.remote.jaxb.gen.GetProcessInstanceCommand;
import org.kie.remote.jaxb.gen.GetProcessInstancesCommand;
import org.kie.remote.jaxb.gen.JaxbStringObjectPairArray;
import org.kie.remote.jaxb.gen.SetGlobalCommand;
import org.kie.remote.jaxb.gen.SignalEventCommand;
import org.kie.remote.jaxb.gen.StartCorrelatedProcessCommand;
import org.kie.remote.jaxb.gen.StartProcessCommand;
import org.kie.services.client.api.command.AbstractRemoteCommandObject;
import org.kie.services.client.api.command.RemoteConfiguration;

public class KieSessionClientCommandObject
extends AbstractRemoteCommandObject
implements KieSession,
CorrelationAwareProcessRuntime {
    private WorkItemManager workItemManager;

    public KieSessionClientCommandObject(RemoteConfiguration config) {
        super(config);
        if (config.isJms() && config.getKsessionQueue() == null) {
            throw new MissingRequiredInfoException("A KieSession queue is necessary in order to create a Remote JMS Client KieSession instance.");
        }
    }

    public int fireAllRules() {
        return (Integer)this.executeCommand(new FireAllRulesCommand());
    }

    public int fireAllRules(int max) {
        FireAllRulesCommand cmd = new FireAllRulesCommand();
        cmd.setMax(max);
        return (Integer)this.executeCommand(new FireAllRulesCommand());
    }

    public int fireAllRules(AgendaFilter agendaFilter) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Integer.class);
    }

    public int fireAllRules(AgendaFilter agendaFilter, int max) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Integer.class);
    }

    public void fireUntilHalt() {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public void fireUntilHalt(AgendaFilter agendaFilter) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public void submit(KieSession.AtomicAction arg0) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public <T> T execute(Command<T> command) {
        return this.executeCommand(command);
    }

    public <T extends SessionClock> T getSessionClock() {
        return (T)((SessionClock)KieSessionClientCommandObject.unsupported(KieSession.class, Object.class));
    }

    public void setGlobal(String identifier, Object value) {
        SetGlobalCommand cmd = new SetGlobalCommand();
        cmd.setIdentifier(identifier);
        cmd.setObject(value);
        this.executeCommand(cmd);
    }

    public Object getGlobal(String identifier) {
        GetGlobalCommand cmd = new GetGlobalCommand();
        cmd.setIdentifier(identifier);
        return this.executeCommand(cmd);
    }

    public Globals getGlobals() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Globals.class);
    }

    public Calendars getCalendars() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Calendars.class);
    }

    public Environment getEnvironment() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Environment.class);
    }

    public KieBase getKieBase() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, KieBase.class);
    }

    public void registerChannel(String name, Channel channel) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public void unregisterChannel(String name) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public Map<String, Channel> getChannels() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Map.class);
    }

    public KieSessionConfiguration getSessionConfiguration() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, KieSessionConfiguration.class);
    }

    public void halt() {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public Agenda getAgenda() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Agenda.class);
    }

    public EntryPoint getEntryPoint(String name) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, EntryPoint.class);
    }

    public Collection<? extends EntryPoint> getEntryPoints() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Collection.class);
    }

    public QueryResults getQueryResults(String query, Object ... arguments) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, QueryResults.class);
    }

    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, LiveQuery.class);
    }

    public String getEntryPointId() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, String.class);
    }

    public FactHandle insert(Object object) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, FactHandle.class);
    }

    public void retract(FactHandle handle) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public void delete(FactHandle handle) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public void delete(FactHandle arg0, FactHandle.State arg1) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public void update(FactHandle handle, Object object) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public void update(FactHandle handle, Object object, String ... modifiedProperties) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public FactHandle getFactHandle(Object object) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, FactHandle.class);
    }

    public Object getObject(FactHandle factHandle) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Object.class);
    }

    public Collection<? extends Object> getObjects() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Collection.class);
    }

    public Collection<? extends Object> getObjects(ObjectFilter filter) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Collection.class);
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Collection.class);
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Collection.class);
    }

    public long getFactCount() {
        return (Long)this.executeCommand(new GetFactCountCommand());
    }

    public ProcessInstance startProcess(String processId) {
        StartProcessCommand cmd = new StartProcessCommand();
        cmd.setProcessId(processId);
        return (ProcessInstance)this.executeCommand(cmd);
    }

    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        StartProcessCommand cmd = new StartProcessCommand();
        cmd.setProcessId(processId);
        JaxbStringObjectPairArray arrayMap = ConversionUtil.convertMapToJaxbStringObjectPairArray(parameters);
        cmd.setParameter(arrayMap);
        return (ProcessInstance)this.executeCommand(cmd);
    }

    public ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        StartCorrelatedProcessCommand cmd = new StartCorrelatedProcessCommand();
        cmd.setProcessId(processId);
        JaxbStringObjectPairArray arrayMap = ConversionUtil.convertMapToJaxbStringObjectPairArray(parameters);
        cmd.setParameter(arrayMap);
        String strCorrKey = this.convertCorrelationKeyToString(correlationKey);
        cmd.setCorrelationKey(strCorrKey);
        return (ProcessInstance)this.executeCommand(cmd);
    }

    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, ProcessInstance.class);
    }

    public ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return KieSessionClientCommandObject.unsupported(CorrelationAwareProcessRuntime.class, ProcessInstance.class);
    }

    public ProcessInstance startProcessInstance(long processInstanceId) {
        return KieSessionClientCommandObject.unsupported(KieSession.class, ProcessInstance.class);
    }

    public void signalEvent(String type, Object event) {
        SignalEventCommand cmd = new SignalEventCommand();
        cmd.setEvent(event);
        cmd.setEventType(type);
        cmd.setProcessInstanceId(-1L);
        this.executeCommand(cmd);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        SignalEventCommand cmd = new SignalEventCommand();
        cmd.setEvent(event);
        cmd.setEventType(type);
        cmd.setProcessInstanceId(processInstanceId);
        this.executeCommand(cmd);
    }

    public Collection<ProcessInstance> getProcessInstances() {
        return (Collection)this.executeCommand(new GetProcessInstancesCommand());
    }

    public ProcessInstance getProcessInstance(long processInstanceId) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand();
        cmd.setProcessInstanceId(processInstanceId);
        cmd.setReadOnly(true);
        return (ProcessInstance)this.executeCommand(cmd);
    }

    public ProcessInstance getProcessInstance(long processInstanceId, boolean readonly) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand();
        cmd.setProcessInstanceId(processInstanceId);
        cmd.setReadOnly(readonly);
        return (ProcessInstance)this.executeCommand(cmd);
    }

    public ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        GetProcessInstanceByCorrelationKeyCommand cmd = new GetProcessInstanceByCorrelationKeyCommand();
        String strCorrKey = this.convertCorrelationKeyToString(correlationKey);
        cmd.setCorrelationKey(strCorrKey);
        return (ProcessInstance)this.executeCommand(cmd);
    }

    public void abortProcessInstance(long processInstanceId) {
        AbortProcessInstanceCommand cmd = new AbortProcessInstanceCommand();
        cmd.setProcessInstanceId(processInstanceId);
        this.executeCommand(cmd);
    }

    public WorkItemManager getWorkItemManager() {
        if (this.workItemManager == null) {
            this.workItemManager = new WorkItemManager(){

                public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
                    AbstractRemoteCommandObject.unsupported(WorkItemManager.class, Void.class);
                }

                public void completeWorkItem(long id, Map<String, Object> results) {
                    CompleteWorkItemCommand cmd = new CompleteWorkItemCommand();
                    cmd.setId(id);
                    JaxbStringObjectPairArray arrayMap = ConversionUtil.convertMapToJaxbStringObjectPairArray(results);
                    cmd.setResult(arrayMap);
                    KieSessionClientCommandObject.this.executeCommand(cmd);
                }

                public void abortWorkItem(long id) {
                    AbortWorkItemCommand cmd = new AbortWorkItemCommand();
                    cmd.setId(id);
                    KieSessionClientCommandObject.this.executeCommand(cmd);
                }
            };
        }
        return this.workItemManager;
    }

    public KieRuntimeLogger getLogger() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, KieRuntimeLogger.class);
    }

    public void addEventListener(RuleRuntimeEventListener listener) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public void removeEventListener(RuleRuntimeEventListener listener) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Collection.class);
    }

    public void addEventListener(AgendaEventListener listener) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public void removeEventListener(AgendaEventListener listener) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Collection.class);
    }

    public void addEventListener(ProcessEventListener listener) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public void removeEventListener(ProcessEventListener listener) {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Collection.class);
    }

    public int getId() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Integer.class);
    }

    public long getIdentifier() {
        return KieSessionClientCommandObject.unsupported(KieSession.class, Long.class);
    }

    public void dispose() {
        throw new UnsupportedOperationException("Dispose does not need to be called on the Remote Client  " + KieSession.class.getSimpleName() + " implementation.");
    }

    public void destroy() {
        KieSessionClientCommandObject.unsupported(KieSession.class, Void.class);
    }
}

