/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.appending;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.appending.AppendingTermsReader;
import org.apache.lucene.codecs.appending.AppendingTermsWriter;
import org.apache.lucene.codecs.lucene40.Lucene40PostingsReader;
import org.apache.lucene.codecs.lucene40.Lucene40PostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

final class AppendingPostingsFormat
extends PostingsFormat {
    public static String CODEC_NAME = "Appending";

    public AppendingPostingsFormat() {
        super(CODEC_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        Lucene40PostingsWriter docsWriter = new Lucene40PostingsWriter(state);
        boolean success = false;
        try {
            AppendingTermsWriter ret = new AppendingTermsWriter(state, (PostingsWriterBase)docsWriter, 25, 48);
            success = true;
            AppendingTermsWriter appendingTermsWriter = ret;
            return appendingTermsWriter;
        }
        finally {
            if (!success) {
                docsWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        Lucene40PostingsReader postings = new Lucene40PostingsReader(state.dir, state.fieldInfos, state.segmentInfo, state.context, state.segmentSuffix);
        boolean success = false;
        try {
            AppendingTermsReader ret = new AppendingTermsReader(state.dir, state.fieldInfos, state.segmentInfo, (PostingsReaderBase)postings, state.context, state.segmentSuffix, state.termsIndexDivisor);
            success = true;
            AppendingTermsReader appendingTermsReader = ret;
            return appendingTermsReader;
        }
        finally {
            if (!success) {
                postings.close();
            }
        }
    }
}

