/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.jbpm.query.jpa.data.QueryCriteria;
import org.jbpm.query.jpa.data.QueryWhere;
import org.jbpm.query.jpa.impl.QueryCriteriaUtil;
import org.jbpm.query.jpa.service.QueryModificationService;
import org.jbpm.services.task.audit.impl.model.TaskVariableImpl;
import org.jbpm.services.task.audit.impl.model.TaskVariableImpl_;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.TaskImpl_;
import org.kie.internal.query.QueryParameterIdentifiers;

public class TaskAuditQueryModificationService
implements QueryModificationService {
    private static Set<String> listIds = new HashSet<String>(3);

    public boolean accepts(String listId) {
        return listIds.contains(listId);
    }

    public void optimizeCriteria(QueryWhere queryWhere) {
        this.optimizeCriteria(queryWhere.getCriteria());
    }

    public void optimizeCriteria(List<QueryCriteria> criteriaList) {
        Set optimizedCriteria = Collections.newSetFromMap(new IdentityHashMap(1));
        boolean endOfListNotYetReached = true;
        block0: while (endOfListNotYetReached) {
            Set taskVarCriteria = Collections.newSetFromMap(new IdentityHashMap(2));
            boolean endOfListReached = true;
            for (QueryCriteria criteria : criteriaList) {
                if (!criteria.isFirst() && criteria.isUnion()) {
                    if (taskVarCriteria.size() > 1) {
                        endOfListReached = false;
                        break;
                    }
                    taskVarCriteria.clear();
                }
                if (criteria.isGroupCriteria()) {
                    if (!optimizedCriteria.add(criteria)) continue;
                    this.optimizeCriteria(criteria.getCriteria());
                    continue;
                }
                String listId = criteria.getListId();
                if (!listId.equals(QueryParameterIdentifiers.TASK_VARIABLE_NAME_ID_LIST) && !listId.equals(QueryParameterIdentifiers.TASK_VARIABLE_VALUE_ID_LIST)) continue;
                taskVarCriteria.add(criteria);
            }
            if (endOfListReached) {
                endOfListNotYetReached = false;
            }
            if (taskVarCriteria.size() <= 1) continue;
            Iterator<QueryCriteria> criteriaIter = criteriaList.iterator();
            QueryCriteria combinedTaskVarCriteria = null;
            while (criteriaIter.hasNext()) {
                QueryCriteria criteria = criteriaIter.next();
                if (taskVarCriteria.contains(criteria)) {
                    if (combinedTaskVarCriteria == null) {
                        combinedTaskVarCriteria = criteria;
                        criteria = new QueryCriteria(criteria);
                        combinedTaskVarCriteria.setListId(QueryParameterIdentifiers.TASK_VARIABLE_COMBINED_ID);
                        combinedTaskVarCriteria.setType(QueryWhere.QueryCriteriaType.NORMAL);
                        combinedTaskVarCriteria.getValues().clear();
                        combinedTaskVarCriteria.getDateValues().clear();
                        combinedTaskVarCriteria.addCriteria(criteria);
                    } else {
                        combinedTaskVarCriteria.addCriteria(criteria);
                        criteriaIter.remove();
                    }
                }
                if (combinedTaskVarCriteria == null || !criteria.isUnion()) continue;
                continue block0;
            }
        }
    }

    public <R> Predicate createPredicate(QueryCriteria criteria, CriteriaQuery<R> query, CriteriaBuilder builder) {
        Root taskRoot = QueryCriteriaUtil.getRoot(query, TaskImpl.class);
        Subquery subQuery = query.subquery(Long.class);
        Root taskVarRoot = subQuery.from(TaskVariableImpl.class);
        subQuery.select((Expression)taskVarRoot.get(TaskVariableImpl_.taskId));
        Predicate taskVariablePredicate = null;
        String listId = criteria.getListId();
        if (QueryParameterIdentifiers.TASK_VARIABLE_COMBINED_ID.equals(listId)) {
            List taskVarSubCriteriaList = criteria.getCriteria();
            int size = taskVarSubCriteriaList.size();
            Predicate[] taskVarSubPredicates = new Predicate[size];
            for (int i = 0; i < size; ++i) {
                taskVarSubPredicates[i] = TaskAuditQueryModificationService.createSingleTaskVariableCriteriaPredicate(builder, (Root<TaskVariableImpl>)taskVarRoot, (QueryCriteria)taskVarSubCriteriaList.get(i));
            }
            taskVariablePredicate = builder.and(taskVarSubPredicates);
        } else {
            taskVariablePredicate = TaskAuditQueryModificationService.createSingleTaskVariableCriteriaPredicate(builder, (Root<TaskVariableImpl>)taskVarRoot, criteria);
        }
        subQuery.where((Expression)taskVariablePredicate);
        return taskRoot.get(TaskImpl_.id).in(new Expression[]{subQuery});
    }

    private static Predicate createSingleTaskVariableCriteriaPredicate(CriteriaBuilder builder, Root<TaskVariableImpl> taskVarRoot, QueryCriteria criteria) {
        String listId = criteria.getListId();
        Path entityField = null;
        if (QueryParameterIdentifiers.TASK_VARIABLE_NAME_ID_LIST.equals(listId)) {
            entityField = taskVarRoot.get(TaskVariableImpl_.name);
        } else if (QueryParameterIdentifiers.TASK_VARIABLE_VALUE_ID_LIST.equals(listId)) {
            entityField = taskVarRoot.get(TaskVariableImpl_.value);
        }
        return QueryCriteriaUtil.basicCreatePredicateFromSingleCriteria((CriteriaBuilder)builder, (Expression)entityField, (QueryCriteria)criteria);
    }

    static {
        listIds.add(QueryParameterIdentifiers.TASK_VARIABLE_NAME_ID_LIST);
        listIds.add(QueryParameterIdentifiers.TASK_VARIABLE_VALUE_ID_LIST);
        listIds.add(QueryParameterIdentifiers.TASK_VARIABLE_COMBINED_ID);
    }
}

