/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider;

import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.StaticDataSetProvider;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetGenerator;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.DataSetDefRegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanDataSetProvider
implements DataSetProvider,
DataSetDefRegistryListener {
    protected Logger log = LoggerFactory.getLogger(BeanDataSetProvider.class);
    protected StaticDataSetProvider staticDataSetProvider;
    protected DataSetDefRegistry dataSetDefRegistry;

    public BeanDataSetProvider() {
    }

    public BeanDataSetProvider(StaticDataSetProvider staticDataSetProvider, DataSetDefRegistry dataSetDefRegistry) {
        this.staticDataSetProvider = staticDataSetProvider;
        this.dataSetDefRegistry = dataSetDefRegistry;
        this.dataSetDefRegistry.addListener((DataSetDefRegistryListener)this);
    }

    public DataSetProviderType getType() {
        return DataSetProviderType.BEAN;
    }

    public StaticDataSetProvider getStaticDataSetProvider() {
        return this.staticDataSetProvider;
    }

    public DataSetMetadata getDataSetMetadata(DataSetDef def) throws Exception {
        DataSet dataSet = this.lookupDataSet(def, null);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getMetadata();
    }

    public DataSetGenerator lookupGenerator(DataSetDef def) {
        BeanDataSetDef beanDef = (BeanDataSetDef)def;
        String beanName = beanDef.getGeneratorClass();
        try {
            return (DataSetGenerator)Class.forName(beanName).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Data set generator can not be instantiated: " + beanName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        DataSet dataSet = this.staticDataSetProvider.lookupDataSet(def.getUUID(), null);
        if (lookup != null && lookup.testMode() || dataSet == null) {
            BeanDataSetDef beanDef = (BeanDataSetDef)def;
            DataSetGenerator dataSetGenerator = this.lookupGenerator(def);
            dataSet = dataSetGenerator.buildDataSet(beanDef.getParamaterMap());
            dataSet.setUUID(def.getUUID());
            dataSet.setDefinition(def);
            if (!def.isAllColumnsEnabled()) {
                for (DataColumn column : dataSet.getColumns()) {
                    if (def.getColumnById(column.getId()) != null) continue;
                    dataSet.removeColumn(column.getId());
                }
            }
            this.staticDataSetProvider.registerDataSet(dataSet);
        }
        try {
            dataSet = this.staticDataSetProvider.lookupDataSet(def, lookup);
        }
        finally {
            if (lookup != null && lookup.testMode()) {
                this.staticDataSetProvider.removeDataSet(def.getUUID());
            }
        }
        return dataSet;
    }

    public boolean isDataSetOutdated(DataSetDef def) {
        return false;
    }

    public void onDataSetDefStale(DataSetDef def) {
        if (DataSetProviderType.BEAN.equals((Object)def.getProvider())) {
            this.staticDataSetProvider.removeDataSet(def.getUUID());
        }
    }

    public void onDataSetDefModified(DataSetDef olDef, DataSetDef newDef) {
        if (DataSetProviderType.BEAN.equals((Object)olDef.getProvider())) {
            this.staticDataSetProvider.removeDataSet(olDef.getUUID());
        }
    }

    public void onDataSetDefRemoved(DataSetDef oldDef) {
        if (DataSetProviderType.BEAN.equals((Object)oldDef.getProvider())) {
            this.staticDataSetProvider.removeDataSet(oldDef.getUUID());
        }
    }

    public void onDataSetDefRegistered(DataSetDef newDef) {
    }
}

