/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.DoubleBarrelLRUCache;

public class BlockTermsReader
extends FieldsProducer {
    private final IndexInput in;
    private final PostingsReaderBase postingsReader;
    private final TreeMap<String, FieldReader> fields = new TreeMap();
    private final DoubleBarrelLRUCache<FieldAndTerm, BlockTermState> termsCache;
    private TermsIndexReaderBase indexReader;
    protected long dirOffset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockTermsReader(TermsIndexReaderBase indexReader, Directory dir, FieldInfos fieldInfos, SegmentInfo info, PostingsReaderBase postingsReader, IOContext context, int termsCacheSize, String segmentSuffix) throws IOException {
        this.postingsReader = postingsReader;
        this.termsCache = new DoubleBarrelLRUCache(termsCacheSize);
        this.in = dir.openInput(IndexFileNames.segmentFileName((String)info.name, (String)segmentSuffix, (String)"tib"), context);
        boolean success = false;
        try {
            this.readHeader(this.in);
            postingsReader.init(this.in);
            this.seekDir(this.in, this.dirOffset);
            int numFields = this.in.readVInt();
            if (numFields < 0) {
                throw new CorruptIndexException("invalid number of fields: " + numFields + " (resource=" + this.in + ")");
            }
            for (int i = 0; i < numFields; ++i) {
                int field = this.in.readVInt();
                long numTerms = this.in.readVLong();
                assert (numTerms >= 0L);
                long termsStartPointer = this.in.readVLong();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                long sumTotalTermFreq = fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY ? -1L : this.in.readVLong();
                long sumDocFreq = this.in.readVLong();
                int docCount = this.in.readVInt();
                if (docCount < 0 || docCount > info.getDocCount()) {
                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + info.getDocCount() + " (resource=" + this.in + ")");
                }
                if (sumDocFreq < (long)docCount) {
                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount + " (resource=" + this.in + ")");
                }
                if (sumTotalTermFreq != -1L && sumTotalTermFreq < sumDocFreq) {
                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq + " (resource=" + this.in + ")");
                }
                FieldReader previous = this.fields.put(fieldInfo.name, new FieldReader(fieldInfo, numTerms, termsStartPointer, sumTotalTermFreq, sumDocFreq, docCount));
                if (previous == null) continue;
                throw new CorruptIndexException("duplicate fields: " + fieldInfo.name + " (resource=" + this.in + ")");
            }
            success = true;
        }
        finally {
            if (!success) {
                this.in.close();
            }
        }
        this.indexReader = indexReader;
    }

    protected void readHeader(IndexInput input) throws IOException {
        CodecUtil.checkHeader((DataInput)input, (String)"BLOCK_TERMS_DICT", (int)0, (int)0);
        this.dirOffset = input.readLong();
    }

    protected void seekDir(IndexInput input, long dirOffset) throws IOException {
        input.seek(dirOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            try {
                if (this.indexReader != null) {
                    this.indexReader.close();
                }
            }
            finally {
                this.indexReader = null;
                if (this.in != null) {
                    this.in.close();
                }
            }
        }
        finally {
            if (this.postingsReader != null) {
                this.postingsReader.close();
            }
        }
    }

    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    public Terms terms(String field) throws IOException {
        assert (field != null);
        return this.fields.get(field);
    }

    public int size() {
        return this.fields.size();
    }

    private class FieldReader
    extends Terms {
        final long numTerms;
        final FieldInfo fieldInfo;
        final long termsStartPointer;
        final long sumTotalTermFreq;
        final long sumDocFreq;
        final int docCount;

        FieldReader(FieldInfo fieldInfo, long numTerms, long termsStartPointer, long sumTotalTermFreq, long sumDocFreq, int docCount) {
            assert (numTerms > 0L);
            this.fieldInfo = fieldInfo;
            this.numTerms = numTerms;
            this.termsStartPointer = termsStartPointer;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            return new SegmentTermsEnum();
        }

        public boolean hasOffsets() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        public boolean hasPositions() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        public boolean hasPayloads() {
            return this.fieldInfo.hasPayloads();
        }

        public long size() {
            return this.numTerms;
        }

        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }

        public long getSumDocFreq() throws IOException {
            return this.sumDocFreq;
        }

        public int getDocCount() throws IOException {
            return this.docCount;
        }

        private final class SegmentTermsEnum
        extends TermsEnum {
            private final IndexInput in;
            private final BlockTermState state;
            private final boolean doOrd;
            private final FieldAndTerm fieldTerm = new FieldAndTerm();
            private final TermsIndexReaderBase.FieldIndexEnum indexEnum;
            private final BytesRef term = new BytesRef();
            private boolean indexIsCurrent;
            private boolean didIndexNext;
            private BytesRef nextIndexTerm;
            private boolean seekPending;
            private int blocksSinceSeek;
            private byte[] termSuffixes;
            private ByteArrayDataInput termSuffixesReader = new ByteArrayDataInput();
            private int termBlockPrefix;
            private int blockTermCount;
            private byte[] docFreqBytes;
            private final ByteArrayDataInput freqReader = new ByteArrayDataInput();
            private int metaDataUpto;

            public SegmentTermsEnum() throws IOException {
                this.in = BlockTermsReader.this.in.clone();
                this.in.seek(FieldReader.this.termsStartPointer);
                this.indexEnum = BlockTermsReader.this.indexReader.getFieldEnum(FieldReader.this.fieldInfo);
                this.doOrd = BlockTermsReader.this.indexReader.supportsOrd();
                this.fieldTerm.field = FieldReader.this.fieldInfo.name;
                this.state = BlockTermsReader.this.postingsReader.newTermState();
                this.state.totalTermFreq = -1L;
                this.state.ord = -1L;
                this.termSuffixes = new byte[128];
                this.docFreqBytes = new byte[64];
            }

            public Comparator<BytesRef> getComparator() {
                return BytesRef.getUTF8SortedAsUnicodeComparator();
            }

            public TermsEnum.SeekStatus seekCeil(BytesRef target, boolean useCache) throws IOException {
                if (this.indexEnum == null) {
                    throw new IllegalStateException("terms index was not loaded");
                }
                if (!this.didIndexNext || this.nextIndexTerm == null) {
                    // empty if block
                }
                if (useCache) {
                    this.fieldTerm.term = target;
                    TermState cachedState = (TermState)BlockTermsReader.this.termsCache.get((DoubleBarrelLRUCache.CloneableKey)this.fieldTerm);
                    if (cachedState != null) {
                        this.seekPending = true;
                        this.seekExact(target, cachedState);
                        return TermsEnum.SeekStatus.FOUND;
                    }
                }
                boolean doSeek = true;
                if (this.indexIsCurrent) {
                    int cmp = BytesRef.getUTF8SortedAsUnicodeComparator().compare(this.term, target);
                    if (cmp == 0) {
                        return TermsEnum.SeekStatus.FOUND;
                    }
                    if (cmp < 0) {
                        if (!this.didIndexNext) {
                            this.nextIndexTerm = this.indexEnum.next() == -1L ? null : this.indexEnum.term();
                            this.didIndexNext = true;
                        }
                        if (this.nextIndexTerm == null || BytesRef.getUTF8SortedAsUnicodeComparator().compare(target, this.nextIndexTerm) < 0) {
                            doSeek = false;
                        }
                    }
                }
                if (doSeek) {
                    this.in.seek(this.indexEnum.seek(target));
                    boolean result = this.nextBlock();
                    assert (result);
                    this.indexIsCurrent = true;
                    this.didIndexNext = false;
                    this.blocksSinceSeek = 0;
                    if (this.doOrd) {
                        this.state.ord = this.indexEnum.ord() - 1L;
                    }
                    this.term.copyBytes(this.indexEnum.term());
                } else if (this.state.termBlockOrd == this.blockTermCount && !this.nextBlock()) {
                    this.indexIsCurrent = false;
                    return TermsEnum.SeekStatus.END;
                }
                this.seekPending = false;
                int common = 0;
                while (true) {
                    int suffix;
                    if (common < this.termBlockPrefix) {
                        int suffix2;
                        int cmp = (this.term.bytes[common] & 0xFF) - (target.bytes[target.offset + common] & 0xFF);
                        if (cmp < 0) {
                            if (this.state.termBlockOrd < this.blockTermCount) {
                                while (this.state.termBlockOrd < this.blockTermCount - 1) {
                                    ++this.state.termBlockOrd;
                                    ++this.state.ord;
                                    this.termSuffixesReader.skipBytes(this.termSuffixesReader.readVInt());
                                }
                                suffix2 = this.termSuffixesReader.readVInt();
                                this.term.length = this.termBlockPrefix + suffix2;
                                if (this.term.bytes.length < this.term.length) {
                                    this.term.grow(this.term.length);
                                }
                                this.termSuffixesReader.readBytes(this.term.bytes, this.termBlockPrefix, suffix2);
                            }
                            ++this.state.ord;
                            if (!this.nextBlock()) {
                                this.indexIsCurrent = false;
                                return TermsEnum.SeekStatus.END;
                            }
                            common = 0;
                            continue;
                        }
                        if (cmp > 0) {
                            assert (this.state.termBlockOrd == 0);
                            suffix2 = this.termSuffixesReader.readVInt();
                            this.term.length = this.termBlockPrefix + suffix2;
                            if (this.term.bytes.length < this.term.length) {
                                this.term.grow(this.term.length);
                            }
                            this.termSuffixesReader.readBytes(this.term.bytes, this.termBlockPrefix, suffix2);
                            return TermsEnum.SeekStatus.NOT_FOUND;
                        }
                        ++common;
                        continue;
                    }
                    while (true) {
                        ++this.state.termBlockOrd;
                        ++this.state.ord;
                        suffix = this.termSuffixesReader.readVInt();
                        int termLen = this.termBlockPrefix + suffix;
                        int bytePos = this.termSuffixesReader.getPosition();
                        boolean next = false;
                        int limit = target.offset + (termLen < target.length ? termLen : target.length);
                        int targetPos = target.offset + this.termBlockPrefix;
                        while (targetPos < limit) {
                            int cmp;
                            if ((cmp = (this.termSuffixes[bytePos++] & 0xFF) - (target.bytes[targetPos++] & 0xFF)) < 0) {
                                next = true;
                                break;
                            }
                            if (cmp <= 0) continue;
                            this.term.length = this.termBlockPrefix + suffix;
                            if (this.term.bytes.length < this.term.length) {
                                this.term.grow(this.term.length);
                            }
                            this.termSuffixesReader.readBytes(this.term.bytes, this.termBlockPrefix, suffix);
                            return TermsEnum.SeekStatus.NOT_FOUND;
                        }
                        if (!next && target.length <= termLen) {
                            this.term.length = this.termBlockPrefix + suffix;
                            if (this.term.bytes.length < this.term.length) {
                                this.term.grow(this.term.length);
                            }
                            this.termSuffixesReader.readBytes(this.term.bytes, this.termBlockPrefix, suffix);
                            if (target.length == termLen) {
                                if (useCache) {
                                    this.decodeMetaData();
                                    BlockTermsReader.this.termsCache.put((DoubleBarrelLRUCache.CloneableKey)new FieldAndTerm(this.fieldTerm), (Object)((BlockTermState)this.state.clone()));
                                }
                                return TermsEnum.SeekStatus.FOUND;
                            }
                            return TermsEnum.SeekStatus.NOT_FOUND;
                        }
                        if (this.state.termBlockOrd == this.blockTermCount) {
                            this.term.length = this.termBlockPrefix + suffix;
                            if (this.term.bytes.length < this.term.length) {
                                this.term.grow(this.term.length);
                            }
                            break;
                        }
                        this.termSuffixesReader.skipBytes(suffix);
                    }
                    this.termSuffixesReader.readBytes(this.term.bytes, this.termBlockPrefix, suffix);
                    assert (this.indexIsCurrent);
                    if (!this.nextBlock()) {
                        this.indexIsCurrent = false;
                        return TermsEnum.SeekStatus.END;
                    }
                    common = 0;
                }
            }

            public BytesRef next() throws IOException {
                if (this.seekPending) {
                    assert (!this.indexIsCurrent);
                    this.in.seek(this.state.blockFilePointer);
                    int pendingSeekCount = this.state.termBlockOrd;
                    boolean result = this.nextBlock();
                    long savOrd = this.state.ord;
                    assert (result);
                    while (this.state.termBlockOrd < pendingSeekCount) {
                        BytesRef nextResult = this._next();
                        assert (nextResult != null);
                    }
                    this.seekPending = false;
                    this.state.ord = savOrd;
                }
                return this._next();
            }

            private BytesRef _next() throws IOException {
                if (this.state.termBlockOrd == this.blockTermCount && !this.nextBlock()) {
                    this.indexIsCurrent = false;
                    return null;
                }
                int suffix = this.termSuffixesReader.readVInt();
                this.term.length = this.termBlockPrefix + suffix;
                if (this.term.bytes.length < this.term.length) {
                    this.term.grow(this.term.length);
                }
                this.termSuffixesReader.readBytes(this.term.bytes, this.termBlockPrefix, suffix);
                ++this.state.termBlockOrd;
                ++this.state.ord;
                return this.term;
            }

            public BytesRef term() {
                return this.term;
            }

            public int docFreq() throws IOException {
                this.decodeMetaData();
                return this.state.docFreq;
            }

            public long totalTermFreq() throws IOException {
                this.decodeMetaData();
                return this.state.totalTermFreq;
            }

            public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
                this.decodeMetaData();
                return BlockTermsReader.this.postingsReader.docs(FieldReader.this.fieldInfo, this.state, liveDocs, reuse, flags);
            }

            public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
                if (FieldReader.this.fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    return null;
                }
                this.decodeMetaData();
                return BlockTermsReader.this.postingsReader.docsAndPositions(FieldReader.this.fieldInfo, this.state, liveDocs, reuse, flags);
            }

            public void seekExact(BytesRef target, TermState otherState) {
                assert (otherState != null && otherState instanceof BlockTermState);
                assert (!this.doOrd || ((BlockTermState)otherState).ord < FieldReader.this.numTerms);
                this.state.copyFrom(otherState);
                this.seekPending = true;
                this.indexIsCurrent = false;
                this.term.copyBytes(target);
            }

            public TermState termState() throws IOException {
                this.decodeMetaData();
                TermState ts = this.state.clone();
                return ts;
            }

            public void seekExact(long ord) throws IOException {
                if (this.indexEnum == null) {
                    throw new IllegalStateException("terms index was not loaded");
                }
                assert (ord < FieldReader.this.numTerms);
                this.in.seek(this.indexEnum.seek(ord));
                boolean result = this.nextBlock();
                assert (result);
                this.indexIsCurrent = true;
                this.didIndexNext = false;
                this.blocksSinceSeek = 0;
                this.seekPending = false;
                this.state.ord = this.indexEnum.ord() - 1L;
                assert (this.state.ord >= -1L) : "ord=" + this.state.ord;
                this.term.copyBytes(this.indexEnum.term());
                for (int left = (int)(ord - this.state.ord); left > 0; --left) {
                    BytesRef term = this._next();
                    assert (term != null);
                }
            }

            public long ord() {
                if (!this.doOrd) {
                    throw new UnsupportedOperationException();
                }
                return this.state.ord;
            }

            private boolean nextBlock() throws IOException {
                this.state.blockFilePointer = this.in.getFilePointer();
                this.blockTermCount = this.in.readVInt();
                if (this.blockTermCount == 0) {
                    return false;
                }
                this.termBlockPrefix = this.in.readVInt();
                int len = this.in.readVInt();
                if (this.termSuffixes.length < len) {
                    this.termSuffixes = new byte[ArrayUtil.oversize((int)len, (int)1)];
                }
                this.in.readBytes(this.termSuffixes, 0, len);
                this.termSuffixesReader.reset(this.termSuffixes, 0, len);
                len = this.in.readVInt();
                if (this.docFreqBytes.length < len) {
                    this.docFreqBytes = new byte[ArrayUtil.oversize((int)len, (int)1)];
                }
                this.in.readBytes(this.docFreqBytes, 0, len);
                this.freqReader.reset(this.docFreqBytes, 0, len);
                this.metaDataUpto = 0;
                this.state.termBlockOrd = 0;
                BlockTermsReader.this.postingsReader.readTermsBlock(this.in, FieldReader.this.fieldInfo, this.state);
                ++this.blocksSinceSeek;
                this.indexIsCurrent = this.indexIsCurrent && this.blocksSinceSeek < BlockTermsReader.this.indexReader.getDivisor();
                return true;
            }

            private void decodeMetaData() throws IOException {
                if (!this.seekPending) {
                    int limit = this.state.termBlockOrd;
                    this.state.termBlockOrd = this.metaDataUpto;
                    while (this.metaDataUpto < limit) {
                        this.state.docFreq = this.freqReader.readVInt();
                        if (FieldReader.this.fieldInfo.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY) {
                            this.state.totalTermFreq = (long)this.state.docFreq + this.freqReader.readVLong();
                        }
                        BlockTermsReader.this.postingsReader.nextTerm(FieldReader.this.fieldInfo, this.state);
                        ++this.metaDataUpto;
                        ++this.state.termBlockOrd;
                    }
                }
            }
        }
    }

    private static class FieldAndTerm
    extends DoubleBarrelLRUCache.CloneableKey {
        String field;
        BytesRef term;

        public FieldAndTerm() {
        }

        public FieldAndTerm(FieldAndTerm other) {
            this.field = other.field;
            this.term = BytesRef.deepCopyOf((BytesRef)other.term);
        }

        public boolean equals(Object _other) {
            FieldAndTerm other = (FieldAndTerm)((Object)_other);
            return other.field.equals(this.field) && this.term.bytesEquals(other.term);
        }

        public FieldAndTerm clone() {
            return new FieldAndTerm(this);
        }

        public int hashCode() {
            return this.field.hashCode() * 31 + this.term.hashCode();
        }
    }
}

