/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization.jaxb.impl.task;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.model.SubTasksStrategy;
import org.kie.services.client.serialization.JaxbSerializationProvider;

@XmlRootElement(name="task-summary")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={Status.class, SubTasksStrategy.class})
@JsonIgnoreProperties(value={"statusId"})
public class JaxbTaskSummary
implements TaskSummary {
    @XmlElement
    @XmlSchemaType(name="long")
    private Long id;
    @XmlElement
    @XmlSchemaType(name="string")
    private String name;
    @XmlElement
    @XmlSchemaType(name="string")
    private String subject;
    @XmlElement
    @XmlSchemaType(name="string")
    private String description;
    @XmlElement
    private Status status;
    @XmlElement
    @XmlSchemaType(name="int")
    private Integer priority;
    @XmlElement
    @XmlSchemaType(name="boolean")
    private Boolean skipable;
    @XmlElement(name="actual-owner")
    private String actualOwnerId;
    @XmlElement(name="created-by")
    private String createdById;
    @XmlElement(name="created-on")
    @XmlSchemaType(name="dateTime")
    private Date createdOn;
    @XmlElement(name="activation-time")
    @XmlSchemaType(name="dateTime")
    private Date activationTime;
    @XmlElement(name="expiration-time")
    @XmlSchemaType(name="dateTime")
    private Date expirationTime;
    @XmlElement(name="process-instance-id")
    @XmlSchemaType(name="long")
    private long processInstanceId;
    @XmlElement(name="process-id")
    @XmlSchemaType(name="string")
    private String processId;
    @XmlElement(name="process-session-id")
    @XmlSchemaType(name="long")
    private Long processSessionId;
    @XmlElement(name="deployment-id")
    @XmlSchemaType(name="string")
    private String deploymentId;
    @XmlElement(name="quick-task-summary")
    @XmlSchemaType(name="boolean")
    private Boolean quickTaskSummary;
    @XmlElement(name="sub-task-strategy")
    private SubTasksStrategy subTaskStrategy;
    @XmlElement(name="parent-id")
    @XmlSchemaType(name="long")
    private Long parentId;
    @Deprecated
    @XmlElement(name="potential-owner")
    private List<String> potentialOwners;

    public JaxbTaskSummary(TaskSummary taskSum) {
        this.id = taskSum.getId();
        this.processInstanceId = taskSum.getProcessInstanceId();
        this.name = taskSum.getName();
        this.subject = taskSum.getSubject();
        this.description = taskSum.getDescription();
        this.status = taskSum.getStatus();
        this.priority = taskSum.getPriority();
        this.skipable = taskSum.isSkipable();
        User actual = taskSum.getActualOwner();
        this.actualOwnerId = actual != null ? actual.getId() : taskSum.getActualOwnerId();
        User created = taskSum.getCreatedBy();
        this.createdById = created != null ? created.getId() : taskSum.getCreatedById();
        this.createdOn = taskSum.getCreatedOn();
        this.activationTime = taskSum.getActivationTime();
        this.expirationTime = taskSum.getExpirationTime();
        this.processId = taskSum.getProcessId();
        this.processSessionId = taskSum.getProcessSessionId();
        this.deploymentId = taskSum.getDeploymentId();
        this.quickTaskSummary = false;
        this.parentId = taskSum.getParentId();
    }

    public JaxbTaskSummary() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        JaxbSerializationProvider.unsupported(Task.class, Void.class);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        JaxbSerializationProvider.unsupported(Task.class, Void.class);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Boolean isSkipable() {
        return this.skipable;
    }

    public void setSkipable(boolean skipable) {
        this.skipable = skipable;
    }

    @JsonIgnore
    public User getActualOwner() {
        if (this.actualOwnerId == null) {
            return null;
        }
        return new GetterUser(this.actualOwnerId);
    }

    public void setActualOwner(User actualOwner) {
        this.actualOwnerId = actualOwner != null ? actualOwner.getId() : null;
    }

    public String getActualOwnerId() {
        return this.actualOwnerId;
    }

    public void setActualOwnerId(String id) {
        this.actualOwnerId = id;
    }

    @JsonIgnore
    public User getCreatedBy() {
        if (this.createdById == null) {
            return null;
        }
        return new GetterUser(this.createdById);
    }

    public void setCreatedBy(User createdBy) {
        this.createdById = createdBy != null ? createdBy.getId() : null;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public void setCreatedById(String id) {
        this.createdById = id;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Long getProcessSessionId() {
        return this.processSessionId;
    }

    public void setProcessSessionId(long processSessionId) {
        this.processSessionId = processSessionId;
    }

    @Deprecated
    public List<String> getPotentialOwners() {
        return this.potentialOwners;
    }

    @Deprecated
    public void setPotentialOwners(List<String> potentialOwners) {
        this.potentialOwners = potentialOwners;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getStatusId() {
        return this.status != null ? this.status.name() : "";
    }

    public Boolean isQuickTaskSummary() {
        return this.quickTaskSummary;
    }

    public Long getParentId() {
        return this.parentId;
    }

    private class GetterUser
    implements User {
        private final String id;

        public GetterUser(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            JaxbSerializationProvider.unsupported(User.class, Void.class);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            JaxbSerializationProvider.unsupported(User.class, Void.class);
        }
    }
}

