/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.jaxb.gen.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.kie.remote.jaxb.gen.JaxbWrapperType;
import org.kie.remote.jaxb.gen.List;
import org.kie.remote.jaxb.gen.util.JaxbStringObjectPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbUnknownAdapter
extends XmlAdapter<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger(JaxbUnknownAdapter.class);
    private static final Object PRESENT = new Object();
    private static final Map<String, String> classToArrayTypeMap = new HashMap<String, String>();

    public Object marshal(Object o) throws Exception {
        try {
            return this.recursiveMarshal(o, new IdentityHashMap<Object, Object>());
        }
        catch (Exception e) {
            logger.error("Unable to marshal " + o.getClass().getName() + " instance: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object recursiveMarshal(Object o, Map<Object, Object> seenObjectsMap) {
        if (o == null) {
            return o;
        }
        if (seenObjectsMap.put(o, PRESENT) != null) {
            throw new UnsupportedOperationException("Serialization of recursive data structures is not supported!");
        }
        try {
            if (o instanceof java.util.List) {
                java.util.List list = (java.util.List)o;
                java.util.List<Object> serializedList = this.convertCollectionToSerializedList(list, seenObjectsMap);
                List listWrapper = new List();
                listWrapper.getElements().addAll(serializedList);
                listWrapper.setType(JaxbWrapperType.LIST);
                List list2 = listWrapper;
                return list2;
            }
            if (o instanceof Set) {
                Set set = (Set)o;
                java.util.List<Object> serializedList = this.convertCollectionToSerializedList(set, seenObjectsMap);
                List listWrapper = new List();
                listWrapper.getElements().addAll(serializedList);
                listWrapper.setType(JaxbWrapperType.SET);
                List list = listWrapper;
                return list;
            }
            if (o instanceof Map) {
                Map.Entry entry2;
                Map map = (Map)o;
                java.util.List<JaxbStringObjectPair> pairList = new ArrayList(map.size());
                if (map == null || map.isEmpty()) {
                    pairList = Collections.EMPTY_LIST;
                }
                for (Map.Entry entry2 : map.entrySet()) {
                    Object key = entry2.getKey();
                    if (key != null && !(key instanceof String)) {
                        throw new UnsupportedOperationException("Only String keys for Map structures are supported [key was a " + key.getClass().getName() + "]");
                    }
                    pairList.add(new JaxbStringObjectPair((String)key, entry2.getValue()));
                }
                List listWrapper = new List();
                listWrapper.getElements().addAll(pairList);
                listWrapper.setType(JaxbWrapperType.MAP);
                entry2 = listWrapper;
                return entry2;
            }
            if (o.getClass().isArray()) {
                int length = Array.getLength(o);
                ArrayList<Object> serializedList = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    Object elem = this.convertObjectToSerializableVariant(Array.get(o, i), seenObjectsMap);
                    serializedList.add(elem);
                }
                List listWrapper = new List();
                listWrapper.getElements().addAll(serializedList);
                listWrapper.setType(JaxbWrapperType.ARRAY);
                Class<?> componentType = o.getClass().getComponentType();
                String componentTypeName = o.getClass().getComponentType().getCanonicalName();
                if (componentTypeName == null) {
                    throw new UnsupportedOperationException("Local or anonymous classes are not supported for serialization: " + componentType.getName());
                }
                listWrapper.setComponentType(componentTypeName);
                List list = listWrapper;
                return list;
            }
            Object object = o;
            return object;
        }
        finally {
            seenObjectsMap.remove(o);
        }
    }

    private java.util.List<Object> convertCollectionToSerializedList(Collection collection, Map<Object, Object> seenObjectsMap) {
        ArrayList<Object> serializedList = new ArrayList<Object>(collection.size());
        for (Object elem : collection) {
            elem = this.convertObjectToSerializableVariant(elem, seenObjectsMap);
            serializedList.add(elem);
        }
        return serializedList;
    }

    private Object convertObjectToSerializableVariant(Object obj, Map<Object, Object> seenObjectsMap) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof List) && (obj instanceof Collection || obj instanceof Map)) {
            obj = this.recursiveMarshal(obj, seenObjectsMap);
        }
        return obj;
    }

    public Object unmarshal(Object o) throws Exception {
        try {
            return this.recursiveUnmarhsal(o);
        }
        catch (Exception e) {
            logger.error("Unable to *un*marshal " + o.getClass().getName() + " instance: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Object recursiveUnmarhsal(Object o) throws Exception {
        if (o instanceof List) {
            List wrapper = (List)o;
            java.util.List<Object> elements = wrapper.getElements();
            int size = 0;
            if (elements != null) {
                size = elements.size();
            }
            if (wrapper.getType() == null) {
                ArrayList list = new ArrayList(size);
                return this.convertSerializedElementsToCollection(elements, list);
            }
            switch (wrapper.getType()) {
                case LIST: {
                    ArrayList list = new ArrayList(size);
                    return this.convertSerializedElementsToCollection(elements, list);
                }
                case SET: {
                    HashSet set = new HashSet(size);
                    return this.convertSerializedElementsToCollection(elements, set);
                }
                case MAP: {
                    HashMap<String, Object> map = new HashMap<String, Object>(size);
                    if (size > 0) {
                        for (Object keyValueObj : elements) {
                            JaxbStringObjectPair keyValue = (JaxbStringObjectPair)keyValueObj;
                            String key = keyValue.getKey();
                            Object value = this.convertSerializedObjectToObject(keyValue.getValue());
                            map.put(key.toString(), value);
                        }
                    }
                    return map;
                }
                case ARRAY: {
                    java.util.List<Object> objList = wrapper.getElements();
                    int length = objList.size();
                    String componentTypeName = wrapper.getComponentType();
                    Class realArrComponentType = null;
                    realArrComponentType = JaxbUnknownAdapter.getClass(componentTypeName);
                    Object realArr = Array.newInstance(realArrComponentType, objList.size());
                    for (int i = 0; i < length; ++i) {
                        Array.set(realArr, i, objList.get(i));
                    }
                    return realArr;
                }
            }
            throw new IllegalArgumentException("Unknown JAXB collection wrapper type: " + wrapper.getType().toString());
        }
        if (o instanceof JaxbStringObjectPair[]) {
            JaxbStringObjectPair[] value = (JaxbStringObjectPair[])o;
            HashMap<String, Object> r = new HashMap<String, Object>();
            for (JaxbStringObjectPair p : value) {
                if (p.getValue() instanceof List) {
                    r.put(p.getKey(), new ArrayList<java.util.List>(Arrays.asList(((List)p.getValue()).getElements())));
                    continue;
                }
                r.put(p.getKey(), p.getValue());
            }
            return r;
        }
        return o;
    }

    private static Class getClass(String className) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = tccl == null ? JaxbUnknownAdapter.class.getClassLoader() : tccl;
        try {
            if (className.contains(".")) {
                return Class.forName(className, true, loader);
            }
            String arrClassName = classToArrayTypeMap.get(className);
            if (arrClassName == null) {
                throw new IllegalStateException("Unexpected class type encountered during deserialization: " + arrClassName);
            }
            arrClassName = "[" + arrClassName;
            return Class.forName(arrClassName, true, loader).getComponentType();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Class '" + className + "' could not be found during deserialization: " + cnfe.getMessage(), cnfe);
        }
    }

    private Collection convertSerializedElementsToCollection(java.util.List<Object> elements, Collection collection) throws Exception {
        ArrayList<Object> list;
        if (elements == null || elements.isEmpty()) {
            list = Collections.EMPTY_LIST;
        } else {
            list = new ArrayList<Object>(elements.size());
            for (Object elem : elements) {
                elem = this.convertSerializedObjectToObject(elem);
                list.add(elem);
            }
        }
        collection.addAll(list);
        return collection;
    }

    private Object convertSerializedObjectToObject(Object element) throws Exception {
        if (element == null) {
            return element;
        }
        if (element instanceof List) {
            element = this.unmarshal(element);
        }
        return element;
    }

    static {
        classToArrayTypeMap.put("int", "I");
        classToArrayTypeMap.put("boolean", "Z");
        classToArrayTypeMap.put("float", "F");
        classToArrayTypeMap.put("long", "J");
        classToArrayTypeMap.put("short", "S");
        classToArrayTypeMap.put("byte", "B");
        classToArrayTypeMap.put("double", "D");
        classToArrayTypeMap.put("char", "C");
    }
}

