/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards.pmml;

import java.util.List;
import org.dmg.pmml.pmml_4_1.descr.Attribute;
import org.dmg.pmml.pmml_4_1.descr.Characteristic;
import org.dmg.pmml.pmml_4_1.descr.DATATYPE;
import org.dmg.pmml.pmml_4_1.descr.DataDictionary;
import org.dmg.pmml.pmml_4_1.descr.DataField;
import org.dmg.pmml.pmml_4_1.descr.Extension;
import org.dmg.pmml.pmml_4_1.descr.MININGFUNCTION;
import org.dmg.pmml.pmml_4_1.descr.PMML;
import org.dmg.pmml.pmml_4_1.descr.Scorecard;
import org.dmg.pmml.pmml_4_1.descr.SimplePredicate;
import org.dmg.pmml.pmml_4_1.descr.SimpleSetPredicate;

public class ScorecardPMMLUtils {
    public static String getExtensionValue(List extensions, String extensionName) {
        for (Object obj : extensions) {
            Extension extension;
            if (!(obj instanceof Extension) || !extensionName.equalsIgnoreCase((extension = (Extension)obj).getName())) continue;
            return extension.getValue();
        }
        return null;
    }

    public static Extension getExtension(List extensions, String extensionName) {
        for (Object obj : extensions) {
            Extension extension;
            if (!(obj instanceof Extension) || !extensionName.equalsIgnoreCase((extension = (Extension)obj).getName())) continue;
            return extension;
        }
        return null;
    }

    public static Scorecard createScorecard() {
        Scorecard scorecard = new Scorecard();
        scorecard.setUseReasonCodes(Boolean.FALSE);
        scorecard.setIsScorable(Boolean.TRUE);
        scorecard.setFunctionName(MININGFUNCTION.REGRESSION);
        return scorecard;
    }

    public static String getDataType(PMML pmmlDocument, String fieldName) {
        DataDictionary dataDictionary = pmmlDocument.getDataDictionary();
        for (DataField dataField : dataDictionary.getDataFields()) {
            if (!dataField.getName().equalsIgnoreCase(fieldName)) continue;
            DATATYPE datatype = dataField.getDataType();
            if (datatype == DATATYPE.DOUBLE) {
                return "Number";
            }
            if (datatype == DATATYPE.STRING) {
                return "Text";
            }
            if (datatype != DATATYPE.BOOLEAN) continue;
            return "Boolean";
        }
        return null;
    }

    public static String extractFieldNameFromCharacteristic(Characteristic c) {
        String field = "";
        Attribute scoreAttribute = (Attribute)c.getAttributes().get(0);
        if (scoreAttribute.getSimplePredicate() != null) {
            field = scoreAttribute.getSimplePredicate().getField();
        } else if (scoreAttribute.getSimpleSetPredicate() != null) {
            field = scoreAttribute.getSimpleSetPredicate().getField();
        } else if (scoreAttribute.getCompoundPredicate() != null) {
            Object predicate = scoreAttribute.getCompoundPredicate().getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().get(0);
            if (predicate instanceof SimplePredicate) {
                field = ((SimplePredicate)predicate).getField();
            } else if (predicate instanceof SimpleSetPredicate) {
                field = ((SimpleSetPredicate)predicate).getField();
            }
        }
        return field;
    }
}

