/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.servlet.resource;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.servlet.resource.WebResourceLocationProvider;

public class URLClassLoaderResourceProvider
implements WebResourceLocationProvider {
    private final Logger log = Logger.getLogger(URLClassLoaderResourceProvider.class);

    public int getPrecedence() {
        return 100;
    }

    public URL getWebResource(String path, ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            for (URL classLoaderUrl : urlClassLoader.getURLs()) {
                URL possibleWebResourceLocation = this.processClassLoaderSearchPath(classLoaderUrl, path);
                if (possibleWebResourceLocation == null) continue;
                return possibleWebResourceLocation;
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Context class loader is not an URLClassLoader but: " + (classLoader != null ? classLoader.getClass().getName() : "null")));
        }
        return null;
    }

    private URL processClassLoaderSearchPath(URL classPathUrl, String path) {
        block6: {
            String location = classPathUrl.toString();
            if (location.endsWith(".jar")) {
                return null;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Found URL of directory: " + location));
            }
            try {
                if (location.endsWith("/WEB-INF/classes/")) {
                    return new URL(location.substring(0, location.length() - 17) + path);
                }
                if (location.endsWith("/target/classes/")) {
                    return new URL(location.substring(0, location.length() - 16) + "/src/main/webapp" + path);
                }
            }
            catch (MalformedURLException e) {
                if (!this.log.isDebugEnabled()) break block6;
                this.log.debug((Object)"Failed to create URL instance!", (Throwable)e);
            }
        }
        return null;
    }
}

