/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization.jaxb.rest;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.kie.api.command.Command;
import org.kie.services.client.serialization.jaxb.impl.AbstractJaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbRequestStatus;

@XmlRootElement(name="exception-response")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(value={"cause"})
public class JaxbExceptionResponse
extends AbstractJaxbCommandResponse<String> {
    @XmlTransient
    public Exception cause;
    @XmlElement
    @XmlSchemaType(name="string")
    private String message;
    @XmlElement
    @XmlSchemaType(name="string")
    private String stackTrace;

    public JaxbExceptionResponse() {
    }

    public JaxbExceptionResponse(Exception e, int i, Command<?> cmd, JaxbRequestStatus status) {
        super(i, cmd);
        this.initializeExceptionAndMessage(e);
        this.status = status;
    }

    public JaxbExceptionResponse(String requestUrl, Exception e, JaxbRequestStatus status) {
        this.url = requestUrl;
        this.status = status;
        this.initializeExceptionAndMessage(e);
    }

    private void initializeExceptionAndMessage(Exception e) {
        this.cause = e;
        this.message = e.getClass().getSimpleName() + " thrown with message '" + e.getMessage() + "'";
        if (e.getCause() != null) {
            Throwable t = e.getCause();
            this.message = t.getClass().getSimpleName() + " thrown with message '" + t.getMessage() + "'";
        }
        this.stackTrace = JaxbExceptionResponse.convertStackTraceToString(e);
    }

    public static String convertStackTraceToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }

    @Override
    public String prettyPrint() throws JAXBException {
        StringWriter writer = new StringWriter();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)this, (Writer)writer);
        return writer.toString();
    }

    @Override
    public String getResult() {
        return this.message;
    }

    @Override
    public void setResult(String result) {
        this.message = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Exception getCause() {
        return this.cause;
    }

    public void setCause(Exception cause) {
        this.cause = cause;
        if (cause != null) {
            this.stackTrace = JaxbExceptionResponse.convertStackTraceToString(cause);
        }
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }
}

