/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.impl.QuartzSchedulerService;
import org.jbpm.process.core.timer.impl.ThreadPoolSchedulerService;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.identity.UserDataServiceProvider;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.mapper.InMemoryMapper;
import org.jbpm.runtime.manager.impl.mapper.JPAMapper;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuntimeEnvironment
extends SimpleRuntimeEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRuntimeEnvironment.class);

    public DefaultRuntimeEnvironment() {
        this(null, DefaultRuntimeEnvironment.discoverSchedulerService());
    }

    public DefaultRuntimeEnvironment(EntityManagerFactory emf) {
        this(emf, DefaultRuntimeEnvironment.discoverSchedulerService());
    }

    public DefaultRuntimeEnvironment(EntityManagerFactory emf, GlobalSchedulerService globalSchedulerService) {
        super((RegisterableItemsFactory)new DefaultRegisterableItemsFactory());
        this.emf = emf;
        this.schedulerService = globalSchedulerService;
        this.usePersistence = true;
        this.userGroupCallback = UserDataServiceProvider.getUserGroupCallback();
    }

    public DefaultRuntimeEnvironment(EntityManagerFactory emf, boolean usePersistence) {
        this(emf, null);
        this.usePersistence = usePersistence;
        this.emf = emf;
        this.userGroupCallback = UserDataServiceProvider.getUserGroupCallback();
    }

    @Override
    public void init() {
        if (this.emf == null && this.getEnvironmentTemplate().get("org.kie.api.persistence.jpa.CmdScopedEntityManager") == null) {
            this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
        }
        this.addToEnvironment("org.kie.api.persistence.jpa.EntityManagerFactory", this.emf);
        if (this.mapper == null) {
            this.mapper = this.usePersistence ? new JPAMapper(this.emf) : new InMemoryMapper();
        }
    }

    protected static GlobalSchedulerService discoverSchedulerService() {
        if (System.getProperty("org.quartz.properties") != null) {
            return new QuartzSchedulerService();
        }
        if (!"true".equalsIgnoreCase(System.getProperty("org.kie.timer.ejb.disabled"))) {
            try {
                Class<?> clazz = Class.forName("org.jbpm.services.ejb.timer.EjbSchedulerService");
                InitialContext.doLookup("java:module/EJBTimerScheduler");
                return (GlobalSchedulerService)clazz.newInstance();
            }
            catch (Exception e) {
                logger.debug("Unable to find on initialize ejb schduler service due to {}", (Object)e.getMessage());
            }
        }
        return new ThreadPoolSchedulerService(3);
    }
}

