/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.factory;

import javax.persistence.EntityManagerFactory;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.services.task.HumanTaskConfigurator;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.TaskServiceFactory;

public class LocalTaskServiceFactory
implements TaskServiceFactory {
    private RuntimeEnvironment runtimeEnvironment;

    public LocalTaskServiceFactory(RuntimeEnvironment runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment;
    }

    public TaskService newTaskService() {
        TaskService providedTaskService = (TaskService)((SimpleRuntimeEnvironment)this.runtimeEnvironment).getEnvironmentTemplate().get("org.kie.api.task.TaskService");
        if (providedTaskService != null) {
            return providedTaskService;
        }
        EntityManagerFactory emf = ((SimpleRuntimeEnvironment)this.runtimeEnvironment).getEmf();
        if (emf != null) {
            HumanTaskConfigurator configurator = HumanTaskServiceFactory.newTaskServiceConfigurator().environment(this.runtimeEnvironment.getEnvironment()).entityManagerFactory(emf).userGroupCallback(this.runtimeEnvironment.getUserGroupCallback());
            RegisterableItemsFactory itemsFactory = this.runtimeEnvironment.getRegisterableItemsFactory();
            for (TaskLifeCycleEventListener taskListener : itemsFactory.getTaskListeners()) {
                configurator.listener(taskListener);
            }
            TaskService internalTaskService = configurator.getTaskService();
            return internalTaskService;
        }
        return null;
    }

    public void close() {
    }
}

