/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.List;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalTaskSummary;
import org.kie.internal.task.api.model.SubTasksStrategy;

public class TaskSummaryImpl
implements InternalTaskSummary {
    private long id;
    private String name = "";
    private String subject = "";
    private String description = "";
    private Status status;
    private String statusId;
    private int priority;
    private boolean skipable;
    private User actualOwner;
    private String actualOwnerId;
    private User createdBy;
    private String createdById;
    private Date createdOn;
    private Date activationTime;
    private Date expirationTime;
    private long processInstanceId;
    private String processId;
    private long processSessionId;
    private String deploymentId;
    private SubTasksStrategy subTaskStrategy;
    private long parentId;
    private List<String> potentialOwners;
    private boolean quickTaskSummary;

    public TaskSummaryImpl(long id, String name, String subject, String description, Status status, int priority, boolean skipable, User actualOwner, User createdBy, Date createdOn, Date activationTime, Date expirationTime, String processId, long processSessionId, long processInstanceId, String deploymentId, SubTasksStrategy subTaskStrategy, long parentId) {
        this.id = id;
        this.processInstanceId = processInstanceId;
        this.name = name;
        this.subject = subject;
        this.description = description;
        this.status = status;
        this.priority = priority;
        this.skipable = skipable;
        this.actualOwner = actualOwner;
        if (actualOwner != null) {
            this.actualOwnerId = actualOwner.getId();
        }
        this.createdBy = createdBy;
        if (createdBy != null) {
            this.createdById = createdBy.getId();
        }
        this.createdOn = createdOn;
        this.activationTime = activationTime;
        this.expirationTime = expirationTime;
        this.processId = processId;
        this.processSessionId = processSessionId;
        this.subTaskStrategy = subTaskStrategy;
        this.parentId = parentId;
        this.deploymentId = deploymentId;
        this.quickTaskSummary = false;
    }

    public TaskSummaryImpl(long id, String name, String description, Status status, int priority, String actualOwner, String createdBy, Date createdOn, Date activationTime, Date expirationTime, String processId, long processInstanceId, long parentId, String deploymentId) {
        this.id = id;
        this.processInstanceId = processInstanceId;
        this.name = name;
        this.description = description;
        this.status = status;
        if (status != null) {
            this.statusId = status.name();
        }
        this.priority = priority;
        this.actualOwnerId = actualOwner;
        this.createdById = createdBy;
        this.createdOn = createdOn;
        this.activationTime = activationTime;
        this.expirationTime = expirationTime;
        this.processId = processId;
        this.parentId = parentId;
        this.deploymentId = deploymentId;
        this.quickTaskSummary = true;
    }

    public TaskSummaryImpl() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeLong(this.processInstanceId);
        if (this.name != null) {
            out.writeBoolean(true);
            out.writeUTF(this.name);
        } else {
            out.writeBoolean(false);
        }
        if (this.subject != null) {
            out.writeBoolean(true);
            out.writeUTF(this.subject);
        } else {
            out.writeBoolean(false);
        }
        if (this.description != null) {
            out.writeBoolean(true);
            out.writeUTF(this.description);
        } else {
            out.writeBoolean(false);
        }
        if (this.status != null) {
            out.writeBoolean(true);
            out.writeUTF(this.status.toString());
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.priority);
        out.writeLong(this.parentId);
        out.writeBoolean(this.skipable);
        if (this.actualOwner != null) {
            out.writeBoolean(true);
            this.actualOwner.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.createdBy != null) {
            out.writeBoolean(true);
            this.createdBy.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.createdOn != null) {
            out.writeBoolean(true);
            out.writeLong(this.createdOn.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.activationTime != null) {
            out.writeBoolean(true);
            out.writeLong(this.activationTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.expirationTime != null) {
            out.writeBoolean(true);
            out.writeLong(this.expirationTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.processId != null) {
            out.writeBoolean(true);
            out.writeUTF(this.processId);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.processSessionId);
        if (this.subTaskStrategy != null) {
            out.writeBoolean(true);
            out.writeUTF(this.subTaskStrategy.toString());
        } else {
            out.writeBoolean(false);
        }
        if (this.actualOwnerId != null) {
            out.writeBoolean(true);
            out.writeUTF(this.actualOwnerId);
        } else {
            out.writeBoolean(false);
        }
        if (this.createdById != null) {
            out.writeBoolean(true);
            out.writeUTF(this.createdById);
        } else {
            out.writeBoolean(false);
        }
        if (this.statusId != null) {
            out.writeBoolean(true);
            out.writeUTF(this.statusId);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.quickTaskSummary);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.processInstanceId = in.readLong();
        if (in.readBoolean()) {
            this.name = in.readUTF();
        }
        if (in.readBoolean()) {
            this.subject = in.readUTF();
        }
        if (in.readBoolean()) {
            this.description = in.readUTF();
        }
        if (in.readBoolean()) {
            this.status = Status.valueOf((String)in.readUTF());
        }
        this.priority = in.readInt();
        this.parentId = in.readLong();
        this.skipable = in.readBoolean();
        if (in.readBoolean()) {
            this.actualOwner = TaskModelProvider.getFactory().newUser();
            this.actualOwner.readExternal(in);
        }
        if (in.readBoolean()) {
            this.createdBy = TaskModelProvider.getFactory().newUser();
            this.createdBy.readExternal(in);
        }
        if (in.readBoolean()) {
            this.createdOn = new Date(in.readLong());
        }
        if (in.readBoolean()) {
            this.activationTime = new Date(in.readLong());
        }
        if (in.readBoolean()) {
            this.expirationTime = new Date(in.readLong());
        }
        if (in.readBoolean()) {
            this.processId = in.readUTF();
        }
        this.processSessionId = in.readLong();
        if (in.readBoolean()) {
            this.subTaskStrategy = SubTasksStrategy.valueOf((String)in.readUTF());
        }
        if (in.readBoolean()) {
            this.actualOwnerId = in.readUTF();
        }
        if (in.readBoolean()) {
            this.createdById = in.readUTF();
        }
        if (in.readBoolean()) {
            this.statusId = in.readUTF();
        }
        this.quickTaskSummary = in.readBoolean();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Boolean isSkipable() {
        return this.skipable;
    }

    public void setSkipable(boolean skipable) {
        this.skipable = skipable;
    }

    public User getActualOwner() {
        if (this.quickTaskSummary && this.actualOwnerId != null && !this.actualOwnerId.equals("")) {
            this.actualOwner = TaskModelProvider.getFactory().newUser(this.actualOwnerId);
        }
        return this.actualOwner;
    }

    public void setActualOwner(User actualOwner) {
        this.actualOwner = actualOwner;
    }

    public User getCreatedBy() {
        if (this.quickTaskSummary && this.createdById != null && !this.createdById.equals("")) {
            this.createdBy = TaskModelProvider.getFactory().newUser(this.createdById);
        }
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Long getProcessSessionId() {
        return this.processSessionId;
    }

    public void setProcessSessionId(long processSessionId) {
        this.processSessionId = processSessionId;
    }

    public SubTasksStrategy getSubTaskStrategy() {
        return this.subTaskStrategy;
    }

    public void setSubTaskStrategy(SubTasksStrategy subTaskStrategy) {
        this.subTaskStrategy = subTaskStrategy;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public List<String> getPotentialOwners() {
        return this.potentialOwners;
    }

    public void setPotentialOwners(List<String> potentialOwners) {
        this.potentialOwners = potentialOwners;
    }

    public Boolean isQuickTaskSummary() {
        return this.quickTaskSummary;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activationTime == null ? 0 : this.activationTime.hashCode());
        result = 31 * result + (this.actualOwner == null ? 0 : this.actualOwner.hashCode());
        result = 31 * result + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = 31 * result + (this.createdOn == null ? 0 : this.createdOn.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.expirationTime == null ? 0 : this.expirationTime.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.processInstanceId ^ this.processInstanceId >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.subTaskStrategy == null ? 0 : this.subTaskStrategy.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (int)(this.parentId ^ this.parentId >>> 32);
        result = 31 * result + (this.skipable ? 1231 : 1237);
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        result = 31 * result + (this.processId == null ? 0 : this.processId.hashCode());
        result = 31 * result + (int)(this.processSessionId ^ this.processSessionId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSummaryImpl)) {
            return false;
        }
        TaskSummaryImpl other = (TaskSummaryImpl)obj;
        if (this.processInstanceId != other.processInstanceId) {
            return false;
        }
        if (this.activationTime == null ? other.activationTime != null : this.activationTime.getTime() != other.activationTime.getTime()) {
            return false;
        }
        if (this.actualOwner == null ? other.actualOwner != null : !this.actualOwner.equals(other.actualOwner)) {
            return false;
        }
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (this.createdOn == null ? other.createdOn != null : this.createdOn.getTime() != other.createdOn.getTime()) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.expirationTime == null ? other.expirationTime != null : this.expirationTime.getTime() != other.expirationTime.getTime()) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.subTaskStrategy == null ? other.subTaskStrategy != null : !this.subTaskStrategy.equals((Object)other.subTaskStrategy)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.parentId != other.parentId) {
            return false;
        }
        if (this.skipable != other.skipable) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.subject == null ? other.subject != null : !this.subject.equals(other.subject)) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        return this.processSessionId == other.processSessionId;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public String getActualOwnerId() {
        return this.actualOwnerId;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }
}

