/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.net.URL;
import org.kie.remote.client.api.RemoteRestRuntimeEngineBuilder;
import org.kie.remote.client.api.RemoteRestRuntimeEngineFactory;
import org.kie.remote.client.api.exception.InsufficientInfoToBuildException;
import org.kie.services.client.api.AbstractRemoteRuntimeEngineBuilderImpl;
import org.kie.services.client.api.RemoteRuntimeEngineFactory;
import org.kie.services.client.api.command.RemoteConfiguration;
import org.kie.services.client.api.command.RemoteRuntimeEngine;

class RemoteRestRuntimeEngineBuilderImpl
extends AbstractRemoteRuntimeEngineBuilderImpl<RemoteRestRuntimeEngineBuilder, RemoteRestRuntimeEngineFactory>
implements RemoteRestRuntimeEngineBuilder {
    URL url;

    RemoteRestRuntimeEngineBuilderImpl() {
        this.config = new RemoteConfiguration(RemoteConfiguration.Type.REST);
    }

    @Override
    public RemoteRestRuntimeEngineBuilderImpl addUrl(URL url) {
        this.config.setServerBaseRestUrl(url);
        return this;
    }

    private void checkAndFinalizeConfig() {
        RemoteRuntimeEngineFactory.checkAndFinalizeConfig(this.config, this);
    }

    @Override
    public RemoteRestRuntimeEngineFactory buildFactory() throws InsufficientInfoToBuildException {
        this.checkAndFinalizeConfig();
        return new RemoteRestRuntimeEngineFactory(this.config.clone());
    }

    @Override
    public RemoteRuntimeEngine build() {
        this.checkAndFinalizeConfig();
        return new RemoteRuntimeEngine(this.config.clone());
    }

    public static RemoteRestRuntimeEngineBuilderImpl newBuilder() {
        return new RemoteRestRuntimeEngineBuilderImpl();
    }
}

