/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.gwthelper.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="add-source", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class AddSourceMojo
extends AbstractMojo {
    private static final String SRC_MAIN_JAVA = "/src/main/java".replace("/", File.separator);
    private static final String SRC_MAIN_RESOURCES = "/src/main/resources".replace("/", File.separator);
    @Parameter(required=true)
    private String rootDirectories;
    @Parameter(required=false)
    private String includes;
    @Parameter(required=false)
    private String excludes;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        String[] rootDirectoryPaths;
        if (StringUtils.isNotEmpty((String)this.includes) && StringUtils.isNotEmpty((String)this.excludes)) {
            throw new MojoExecutionException("Only one of 'includes' or 'excludes' can be provided");
        }
        for (String rootDirectoryPath : rootDirectoryPaths = this.rootDirectories.split(",")) {
            File rootDirectory = new File(rootDirectoryPath);
            this.loopForMavenModules(rootDirectory);
        }
    }

    private void loopForMavenModules(File source) throws MojoExecutionException {
        this.checkReadableDirectory(source);
        if (this.isMavenModule(source)) {
            this.getLog().debug((CharSequence)("mavenModule " + source.getAbsolutePath()));
            this.loopForGwtModule(source);
            List<File> sources = Arrays.asList(source.listFiles());
            for (File file : sources) {
                if (!file.isDirectory()) continue;
                this.loopForMavenModules(file);
            }
        }
    }

    private void loopForGwtModule(File source) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("loopForGwtModule " + source.getAbsolutePath()));
        if (this.isValidGwtModule(source)) {
            File sources = new File(source.getAbsolutePath() + SRC_MAIN_JAVA);
            this.checkReadableDirectory(sources);
            this.project.addCompileSourceRoot(sources.getAbsolutePath());
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Source directory: " + sources + " added."));
            }
            File resources = new File(source.getAbsolutePath() + SRC_MAIN_RESOURCES);
            this.project.addCompileSourceRoot(resources.getAbsolutePath());
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Source directory: " + resources + " added."));
            }
        }
    }

    private boolean isValidGwtModule(File toCheck) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("isValidGwtModule " + toCheck.getAbsolutePath()));
        File resources = new File(toCheck.getAbsolutePath() + SRC_MAIN_RESOURCES);
        if (!resources.exists()) {
            return false;
        }
        boolean toReturn = false;
        try {
            Optional<Path> first = Files.walk(Paths.get(resources.getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".gwt.xml")).findFirst();
            if (first.isPresent()) {
                String fileName = first.get().getFileName().toString();
                toReturn = StringUtils.isNotEmpty((String)this.includes) ? this.matchPattern(fileName, this.includes) : (StringUtils.isNotEmpty((String)this.excludes) ? !this.matchPattern(fileName, this.excludes) : true);
            }
        }
        catch (IOException e) {
            String errorMessage = StringUtils.isEmpty((String)e.getMessage()) ? e.getClass().getName() : e.getMessage();
            errorMessage = errorMessage + " while analyzing " + toCheck.getAbsolutePath();
            throw new MojoExecutionException(errorMessage);
        }
        return toReturn;
    }

    private boolean isMavenModule(File toCheck) {
        return toCheck.isDirectory() && toCheck.list() != null && Arrays.asList(toCheck.list()).contains("pom.xml");
    }

    private boolean matchPattern(String toCheck, String pattern) {
        return Arrays.stream(pattern.split(",")).anyMatch(toCheck::contains);
    }

    private void checkReadableDirectory(File toCheck) throws MojoExecutionException {
        if (!(toCheck.exists() && toCheck.canRead() && toCheck.isDirectory())) {
            throw new MojoExecutionException("Directory " + toCheck.getAbsolutePath() + " is not a readable directory");
        }
    }
}

