/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.gwthelper.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.kie.maven.gwthelper.plugin.utils.ParserUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Mojo(name="inheritance", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class InheritanceMojo
extends AbstractMojo {
    private static final String SRC_MAIN_RESOURCES = "src/main/resources".replace("/", File.separator);
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component(hint="default")
    protected DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="failOnWarning", defaultValue="false")
    private boolean failOnWarning;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(required=false, defaultValue="inheritance.xml")
    private String fileName;
    @Parameter(property="fileOutput", defaultValue="false")
    private boolean fileOutput;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping pom project");
            return;
        }
        HashMap<String, Set<String>> missingDeclarationMap = new HashMap<String, Set<String>>();
        boolean warning = false;
        if (this.fileOutput) {
            try {
                Document document = ParserUtil.createEmptyDocument();
                Element rootElement = document.createElement("InheritanceTree");
                document.appendChild(rootElement);
                warning = this.checkInheritance(missingDeclarationMap, document, rootElement);
                String toPrint = ParserUtil.getString(document);
                Files.write(Paths.get(this.fileName, new String[0]), toPrint.getBytes(), new OpenOption[0]);
            }
            catch (Exception e) {
                String errorMessage = "Exception " + e.getClass().getName() + " while creating XML Document";
                if (this.verbose) {
                    this.getLog().error((CharSequence)errorMessage, (Throwable)e);
                } else {
                    this.getLog().error((CharSequence)errorMessage);
                }
                throw new MojoFailureException(errorMessage);
            }
        } else {
            warning = this.checkInheritance(missingDeclarationMap);
        }
        if (!missingDeclarationMap.isEmpty()) {
            this.getLog().warn((CharSequence)"Missing inherited modules");
            missingDeclarationMap.forEach((key, value) -> {
                this.getLog().warn((CharSequence)"*********");
                this.getLog().warn((CharSequence)("Module: " + key));
                value.forEach(s -> this.getLog().warn((CharSequence)("\tmissing: " + s)));
            });
        }
        if (warning && this.failOnWarning) {
            throw new MojoExecutionException("Inheritance problems found");
        }
    }

    protected boolean checkInheritance(Map<String, Set<String>> missingDeclarationMap) throws MojoExecutionException {
        String errorMessage;
        Map<JarEntry, Artifact> inheritedGwtModuleArtifactMap = this.getMavenInheritedGwtModuleArtifactMap();
        Set<File> currentModuleGwtModuleList = this.currentModuleGwtModules();
        boolean toReturn = false;
        for (File gwtModuleFile : currentModuleGwtModuleList) {
            try {
                toReturn |= this.printInheritance(gwtModuleFile, inheritedGwtModuleArtifactMap, missingDeclarationMap);
            }
            catch (Exception e) {
                errorMessage = "Exception " + e.getClass().getName() + " while printing inheritance of File " + gwtModuleFile.getName();
                if (this.verbose) {
                    this.getLog().error((CharSequence)errorMessage, (Throwable)e);
                } else {
                    this.getLog().error((CharSequence)errorMessage);
                }
                toReturn = true;
            }
        }
        for (JarEntry jarEntry : inheritedGwtModuleArtifactMap.keySet()) {
            try {
                toReturn |= this.printInheritance(jarEntry, inheritedGwtModuleArtifactMap, missingDeclarationMap);
            }
            catch (Exception e) {
                errorMessage = "Exception " + e.getClass().getName() + " while printing inheritance of JarEntry " + jarEntry.getName();
                if (this.verbose) {
                    this.getLog().error((CharSequence)errorMessage, (Throwable)e);
                } else {
                    this.getLog().error((CharSequence)errorMessage);
                }
                toReturn = true;
            }
        }
        return toReturn;
    }

    protected boolean checkInheritance(Map<String, Set<String>> missingDeclarationMap, Document document, Element rootElement) throws MojoExecutionException {
        String errorMessage;
        Map<JarEntry, Artifact> inheritedGwtModuleArtifactMap = this.getMavenInheritedGwtModuleArtifactMap();
        Set<File> currentModuleGwtModuleList = this.currentModuleGwtModules();
        boolean toReturn = false;
        for (File gwtModuleFile : currentModuleGwtModuleList) {
            try {
                toReturn |= this.printInheritance(gwtModuleFile, inheritedGwtModuleArtifactMap, missingDeclarationMap, document, rootElement);
            }
            catch (Exception e) {
                errorMessage = "Exception " + e.getClass().getName() + " while printing inheritance of File " + gwtModuleFile.getName();
                if (this.verbose) {
                    this.getLog().error((CharSequence)errorMessage, (Throwable)e);
                } else {
                    this.getLog().error((CharSequence)errorMessage);
                }
                toReturn = true;
            }
        }
        for (JarEntry jarEntry : inheritedGwtModuleArtifactMap.keySet()) {
            try {
                toReturn |= this.printInheritance(jarEntry, inheritedGwtModuleArtifactMap, missingDeclarationMap, document, rootElement);
            }
            catch (Exception e) {
                errorMessage = "Exception " + e.getClass().getName() + " while printing inheritance of JarEntry " + jarEntry.getName();
                if (this.verbose) {
                    this.getLog().error((CharSequence)errorMessage, (Throwable)e);
                } else {
                    this.getLog().error((CharSequence)errorMessage);
                }
                toReturn = true;
            }
        }
        return toReturn;
    }

    protected boolean printInheritance(File file, Map<JarEntry, Artifact> inheritedGwtModuleArtifactMap, Map<String, Set<String>> missingDeclarationMap) throws IOException, ParserConfigurationException, SAXException {
        String content = this.getStringContent(file);
        return this.printInheritance(content, file.getName().replace(".gwt.xml", "").replace("/", "."), inheritedGwtModuleArtifactMap, missingDeclarationMap);
    }

    protected boolean printInheritance(File file, Map<JarEntry, Artifact> inheritedGwtModuleArtifactMap, Map<String, Set<String>> missingDeclarationMap, Document document, Element rootElement) throws IOException, ParserConfigurationException, SAXException {
        String content = this.getStringContent(file);
        return this.printInheritance(content, file.getName().replace(".gwt.xml", "").replace("/", "."), inheritedGwtModuleArtifactMap, missingDeclarationMap, document, rootElement);
    }

    protected boolean printInheritance(JarEntry jarEntry, Map<JarEntry, Artifact> inheritedGwtModuleArtifactMap, Map<String, Set<String>> missingDeclarationMap) throws IOException, ParserConfigurationException, SAXException {
        String content = this.getContentFromJarEntry(jarEntry, inheritedGwtModuleArtifactMap);
        return this.printInheritance(content, jarEntry.getName().replace(".gwt.xml", "").replace("/", "."), inheritedGwtModuleArtifactMap, missingDeclarationMap);
    }

    protected boolean printInheritance(JarEntry jarEntry, Map<JarEntry, Artifact> inheritedGwtModuleArtifactMap, Map<String, Set<String>> missingDeclarationMap, Document document, Element rootElement) throws IOException, ParserConfigurationException, SAXException {
        String content = this.getContentFromJarEntry(jarEntry, inheritedGwtModuleArtifactMap);
        return this.printInheritance(content, jarEntry.getName().replace(".gwt.xml", "").replace("/", "."), inheritedGwtModuleArtifactMap, missingDeclarationMap, document, rootElement);
    }

    protected boolean printInheritance(String content, String moduleName, Map<JarEntry, Artifact> inheritedGwtModuleArtifactMap, Map<String, Set<String>> missingDeclarationMap) throws IOException, ParserConfigurationException, SAXException {
        List<String> inheritDeclarations = this.getInheritDeclarations(content);
        this.commonPrintInheritanceInit(moduleName);
        boolean toReturn = false;
        for (String inheritDeclaration : inheritDeclarations) {
            Optional<String> mappedArtifactInfo = this.getMappedArtifactInfo(inheritDeclaration, inheritedGwtModuleArtifactMap);
            toReturn = this.commonPrintInherit(inheritDeclaration, moduleName, mappedArtifactInfo, missingDeclarationMap);
        }
        return toReturn;
    }

    protected boolean printInheritance(String content, String moduleName, Map<JarEntry, Artifact> inheritedGwtModuleArtifactMap, Map<String, Set<String>> missingDeclarationMap, Document document, Element rootElement) throws IOException, ParserConfigurationException, SAXException {
        List<String> inheritDeclarations = this.getInheritDeclarations(content);
        this.commonPrintInheritanceInit(moduleName);
        boolean toReturn = false;
        Element moduleElement = this.initModuleNode(moduleName, document, rootElement);
        for (String inheritDeclaration : inheritDeclarations) {
            Optional<String> mappedArtifactInfo = this.getMappedArtifactInfo(inheritDeclaration, inheritedGwtModuleArtifactMap);
            toReturn = this.commonPrintInherit(inheritDeclaration, moduleName, mappedArtifactInfo, missingDeclarationMap);
            if (mappedArtifactInfo.isPresent()) {
                this.addInheritanceToElement(moduleElement, document, inheritDeclaration, mappedArtifactInfo.get());
                continue;
            }
            this.addMissingInheritanceToElement(moduleElement, document, inheritDeclaration);
        }
        return toReturn;
    }

    protected void commonPrintInheritanceInit(String moduleName) {
        this.getLog().info((CharSequence)"*********");
        this.getLog().info((CharSequence)("Module: " + moduleName));
    }

    protected Optional<String> getMappedArtifactInfo(String inheritDeclaration, Map<JarEntry, Artifact> inheritedGwtModuleArtifactMap) {
        return inheritedGwtModuleArtifactMap.keySet().stream().filter(jarEntry -> {
            String jarEntryName = jarEntry.getName().replace(".gwt.xml", "").replace("/", ".");
            return jarEntryName.endsWith(inheritDeclaration);
        }).findFirst().map(jarEntry -> {
            Artifact artifact = (Artifact)inheritedGwtModuleArtifactMap.get(jarEntry);
            StringBuilder optional = new StringBuilder();
            optional.append(artifact.getGroupId());
            optional.append(":");
            optional.append(artifact.getArtifactId());
            optional.append(":");
            optional.append(artifact.getVersion());
            return optional.toString();
        });
    }

    protected boolean commonPrintInherit(String inheritDeclaration, String moduleName, Optional<String> mappedArtifactInfo, Map<String, Set<String>> missingDeclarationMap) {
        String toPrint;
        boolean toReturn = false;
        if (mappedArtifactInfo.isPresent()) {
            toPrint = mappedArtifactInfo.get();
        } else {
            toPrint = "UNKNOWN";
            toReturn = true;
            if (!missingDeclarationMap.containsKey(moduleName)) {
                missingDeclarationMap.put(moduleName, new HashSet());
            }
            missingDeclarationMap.get(moduleName).add(inheritDeclaration);
        }
        if (toReturn) {
            this.getLog().warn((CharSequence)("\tinherits " + inheritDeclaration + " from " + toPrint));
        } else {
            this.getLog().info((CharSequence)("\tinherits " + inheritDeclaration + " from " + toPrint));
        }
        return toReturn;
    }

    protected String getContentFromJarEntry(JarEntry jarEntry, Map<JarEntry, Artifact> inheritedGwtModuleArtifactMap) throws IOException {
        JarFile jarFile = new JarFile(inheritedGwtModuleArtifactMap.get(jarEntry).getFile());
        return this.getStringContent(jarFile, jarEntry);
    }

    protected Element initModuleNode(String moduleName, Document document, Element rootElement) {
        Element toReturn = document.createElement("module");
        Element moduleNode = document.createElement("name");
        moduleNode.setTextContent(moduleName);
        toReturn.appendChild(moduleNode);
        rootElement.appendChild(toReturn);
        return toReturn;
    }

    protected void addInheritanceToElement(Element container, Document document, String gwtModule, String artifactInfo) {
        Element inheritNode = document.createElement("inherit");
        Element moduleNode = document.createElement("gwt-module");
        moduleNode.setTextContent(gwtModule);
        Element artifactNode = document.createElement("artifact");
        artifactNode.setTextContent(artifactInfo);
        inheritNode.appendChild(moduleNode);
        inheritNode.appendChild(artifactNode);
        container.appendChild(inheritNode);
    }

    protected void addMissingInheritanceToElement(Element container, Document document, String gwtModule) {
        Element inheritNode = document.createElement("missing-inherit");
        inheritNode.setTextContent(gwtModule);
        container.appendChild(inheritNode);
    }

    protected String getStringContent(JarFile jarFile, JarEntry toRead) throws IOException {
        InputStream input = jarFile.getInputStream(toRead);
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, Charset.forName(StandardCharsets.UTF_8.name())));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        return textBuilder.toString();
    }

    protected String getStringContent(File toRead) throws IOException {
        return new String(Files.readAllBytes(Paths.get(toRead.getAbsolutePath(), new String[0])));
    }

    protected List<String> getInheritDeclarations(String content) throws IOException, SAXException, ParserConfigurationException {
        return ParserUtil.getTagAttributes(content, "inherits", "name");
    }

    protected Set<File> currentModuleGwtModules() throws MojoExecutionException {
        HashSet<File> toReturn = new HashSet<File>();
        for (String compileSourceRoot : this.project.getCompileSourceRoots()) {
            this.populateGwtModuleList(toReturn, compileSourceRoot);
        }
        String resourcePath = this.project.getBasedir().getAbsolutePath();
        if (!resourcePath.endsWith(File.separator)) {
            resourcePath = resourcePath + File.separator;
        }
        resourcePath = resourcePath + SRC_MAIN_RESOURCES;
        this.populateGwtModuleList(toReturn, resourcePath);
        return toReturn;
    }

    protected void populateGwtModuleList(Set<File> toPopulate, String parentPath) throws MojoExecutionException {
        File file = new File(parentPath);
        if (!file.exists() || !file.canRead()) {
            throw new MojoExecutionException("Failed to read path " + parentPath);
        }
        this.populateGwtModuleList(toPopulate, file);
    }

    protected void populateGwtModuleList(Set<File> toPopulate, File parentFile) {
        if (parentFile.isDirectory()) {
            File[] innerFiles = parentFile.listFiles();
            if (innerFiles != null) {
                for (File innerFile : innerFiles) {
                    this.populateGwtModuleList(toPopulate, innerFile);
                }
            }
        } else if (parentFile.getName().endsWith(".gwt.xml")) {
            toPopulate.add(parentFile);
        }
    }

    protected Map<JarEntry, Artifact> getMavenInheritedGwtModuleArtifactMap() throws MojoExecutionException {
        LinkedHashMap<JarEntry, Artifact> toReturn = new LinkedHashMap<JarEntry, Artifact>();
        DependencyNode dependencyNode = this.getDependencyNode(this.session, this.dependencyGraphBuilder, this.project);
        try {
            this.recursivelyReadDependencyNode(toReturn, dependencyNode);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to build GwtModuleArtifactMap ", e);
        }
        return toReturn;
    }

    protected void recursivelyReadDependencyNode(Map<JarEntry, Artifact> toPopulate, DependencyNode toRead) throws IOException {
        this.populateGwtModuleArtifactMap(toPopulate, toRead.getArtifact());
        for (DependencyNode dependencyNode : toRead.getChildren()) {
            this.recursivelyReadDependencyNode(toPopulate, dependencyNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateGwtModuleArtifactMap(Map<JarEntry, Artifact> toPopulate, Artifact toRead) throws IOException {
        File file = toRead.getFile();
        if (file != null && file.getName().endsWith(".jar")) {
            JarFile jarFile = new JarFile(file);
            try {
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String entryName = jarEntry.getName();
                    if (!entryName.endsWith(".gwt.xml")) continue;
                    toPopulate.put(jarEntry, toRead);
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected DependencyNode getDependencyNode(MavenSession session, DependencyGraphBuilder dependencyGraphBuilder, MavenProject project) throws MojoExecutionException {
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
            buildingRequest.setProject(project);
            return dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
        }
        catch (DependencyGraphBuilderException exception) {
            throw new MojoExecutionException("Cannot build project dependency graph", (Exception)((Object)exception));
        }
    }
}

