/*
 * Decompiled with CFR 0.152.
 */
package org.kie.provider.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.kie.internal.identity.IdentityProvider;
import org.kie.provider.SessionInfoProvider;
import org.uberfire.rpc.SessionInfo;

@SessionScoped
public class SafeSessionInfoProvider
implements SessionInfoProvider,
Serializable {
    @Inject
    private Instance<SessionInfo> delegate;
    @Inject
    private IdentityProvider identityProvider;
    private static String UNKNOWN_SESSION_ID = "--";

    @Override
    public String getId() {
        if (this.delegate.isUnsatisfied()) {
            return UNKNOWN_SESSION_ID;
        }
        try {
            return ((SessionInfo)this.delegate.get()).getId();
        }
        catch (Exception e) {
            return UNKNOWN_SESSION_ID;
        }
    }

    @Override
    public User getIdentity() {
        if (this.delegate.isUnsatisfied()) {
            List roleStrList = this.identityProvider.getRoles();
            ArrayList<RoleImpl> roles = new ArrayList<RoleImpl>(roleStrList.size());
            for (String roleStr : roleStrList) {
                roles.add(new RoleImpl(roleStr));
            }
            return new UserImpl(this.identityProvider.getName(), roles);
        }
        try {
            return ((SessionInfo)this.delegate.get()).getIdentity();
        }
        catch (Exception e) {
            return new UserImpl("unknown");
        }
    }
}

