/*
 * Decompiled with CFR 0.152.
 */
package org.kie.command;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kie.command.BatchExecutionCommand;
import org.kie.command.Command;
import org.kie.command.KieCommands;
import org.kie.command.Setter;
import org.kie.runtime.ObjectFilter;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.rule.FactHandle;

public class CommandFactory {
    private static volatile KieCommands provider;

    public static Command newInsert(Object object) {
        return CommandFactory.getCommandFactoryProvider().newInsert(object);
    }

    public static Command newInsert(Object object, String outIdentifier) {
        return CommandFactory.getCommandFactoryProvider().newInsert(object, outIdentifier, true, null);
    }

    public static Command newInsert(Object object, String outIdentifier, boolean returnObject, String entryPoint) {
        return CommandFactory.getCommandFactoryProvider().newInsert(object, outIdentifier, returnObject, entryPoint);
    }

    public static Command newInsertElements(Collection objects) {
        return CommandFactory.getCommandFactoryProvider().newInsertElements(objects);
    }

    public static Command newInsertElements(Collection objects, String outIdentifier, boolean returnObject, String entryPoint) {
        return CommandFactory.getCommandFactoryProvider().newInsertElements(objects, outIdentifier, returnObject, entryPoint);
    }

    public static Command newRetract(FactHandle factHandle) {
        return CommandFactory.getCommandFactoryProvider().newRetract(factHandle);
    }

    public static Setter newSetter(String accessor, String value) {
        return CommandFactory.getCommandFactoryProvider().newSetter(accessor, value);
    }

    public static Command newModify(FactHandle factHandle, List<Setter> setters) {
        return CommandFactory.getCommandFactoryProvider().newModify(factHandle, setters);
    }

    public static Command newGetObject(FactHandle factHandle) {
        return CommandFactory.getCommandFactoryProvider().newGetObject(factHandle);
    }

    public static Command newGetObject(FactHandle factHandle, String outIdentifier) {
        return CommandFactory.getCommandFactoryProvider().newGetObject(factHandle, outIdentifier);
    }

    public static Command newGetObjects() {
        return CommandFactory.getCommandFactoryProvider().newGetObjects();
    }

    public static Command newGetObjects(String outIdentifier) {
        return CommandFactory.getCommandFactoryProvider().newGetObjects(outIdentifier);
    }

    public static Command newGetObjects(ObjectFilter filter) {
        return CommandFactory.getCommandFactoryProvider().newGetObjects(filter);
    }

    public static Command newGetObjects(ObjectFilter filter, String outIdentifier) {
        return CommandFactory.getCommandFactoryProvider().newGetObjects(filter);
    }

    public static Command newSetGlobal(String identifier, Object object) {
        return CommandFactory.getCommandFactoryProvider().newSetGlobal(identifier, object);
    }

    public static Command newSetGlobal(String identifier, Object object, boolean out) {
        return CommandFactory.getCommandFactoryProvider().newSetGlobal(identifier, object, out);
    }

    public static Command newSetGlobal(String identifier, Object object, String outIdentifier) {
        return CommandFactory.getCommandFactoryProvider().newSetGlobal(identifier, object, outIdentifier);
    }

    public static Command newGetGlobal(String identifier) {
        return CommandFactory.getCommandFactoryProvider().newGetGlobal(identifier);
    }

    public static Command newGetGlobal(String identifier, String outIdentifier) {
        return CommandFactory.getCommandFactoryProvider().newGetGlobal(identifier, outIdentifier);
    }

    public static Command newFireAllRules() {
        return CommandFactory.getCommandFactoryProvider().newFireAllRules();
    }

    public static Command newFireAllRules(int max) {
        return CommandFactory.getCommandFactoryProvider().newFireAllRules(max);
    }

    public static Command newFireAllRules(String outidentifier) {
        return CommandFactory.getCommandFactoryProvider().newFireAllRules(outidentifier);
    }

    public static Command newStartProcess(String processId) {
        return CommandFactory.getCommandFactoryProvider().newStartProcess(processId);
    }

    public static Command newStartProcess(String processId, Map<String, Object> parameters) {
        return CommandFactory.getCommandFactoryProvider().newStartProcess(processId, parameters);
    }

    public static Command newSignalEvent(String type, Object event) {
        return CommandFactory.getCommandFactoryProvider().newSignalEvent(type, event);
    }

    public static Command newSignalEvent(long processInstanceId, String type, Object event) {
        return CommandFactory.getCommandFactoryProvider().newSignalEvent(processInstanceId, type, event);
    }

    public static Command newRegisterWorkItemHandlerCommand(WorkItemHandler handler, String workItemName) {
        return CommandFactory.getCommandFactoryProvider().newRegisterWorkItemHandlerCommand(handler, workItemName);
    }

    public static Command newCompleteWorkItem(long workItemId, Map<String, Object> results) {
        return CommandFactory.getCommandFactoryProvider().newCompleteWorkItem(workItemId, results);
    }

    public static Command newAbortWorkItem(long workItemId) {
        return CommandFactory.getCommandFactoryProvider().newAbortWorkItem(workItemId);
    }

    public static Command newQuery(String identifier, String name) {
        return CommandFactory.getCommandFactoryProvider().newQuery(identifier, name);
    }

    public static Command newQuery(String identifier, String name, Object[] arguments) {
        return CommandFactory.getCommandFactoryProvider().newQuery(identifier, name, arguments);
    }

    public static BatchExecutionCommand newBatchExecution(List<? extends Command> commands) {
        return CommandFactory.getCommandFactoryProvider().newBatchExecution(commands, null);
    }

    public static BatchExecutionCommand newBatchExecution(List<? extends Command> commands, String lookup) {
        return CommandFactory.getCommandFactoryProvider().newBatchExecution(commands, lookup);
    }

    private static synchronized void setCommandFactoryProvider(KieCommands provider) {
        CommandFactory.provider = provider;
    }

    private static synchronized KieCommands getCommandFactoryProvider() {
        if (provider == null) {
            CommandFactory.loadProvider();
        }
        return provider;
    }

    private static void loadProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.command.impl.CommandFactoryServiceImpl");
            CommandFactory.setCommandFactoryProvider((KieCommands)cls.newInstance());
        }
        catch (Exception e2) {
            throw new RuntimeException("Provider org.drools.command.impl.CommandFactoryProviderImpl could not be set.", e2);
        }
    }

    @Deprecated
    public static Command newKBuilderSetPropertyCommand(String id, String name, String value) {
        return CommandFactory.getCommandFactoryProvider().newKBuilderSetPropertyCommand(id, name, value);
    }

    public static Command newKnowledgeBuilderSetPropertyCommand(String id, String name, String value) {
        return CommandFactory.getCommandFactoryProvider().newKnowledgeBuilderSetPropertyCommand(id, name, value);
    }

    public static Command newNewKnowledgeBuilderConfigurationCommand(String localId) {
        return CommandFactory.getCommandFactoryProvider().newNewKnowledgeBuilderConfigurationCommand(localId);
    }

    public static Command<FactHandle> fromExternalFactHandleCommand(String factHandleExternalForm) {
        return CommandFactory.getCommandFactoryProvider().fromExternalFactHandleCommand(factHandleExternalForm);
    }

    public static Command<FactHandle> fromExternalFactHandleCommand(String factHandleExternalForm, boolean disconnected) {
        return CommandFactory.getCommandFactoryProvider().fromExternalFactHandleCommand(factHandleExternalForm, disconnected);
    }
}

