/*
 * Decompiled with CFR 0.152.
 */
package org.kie.io;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.kie.definition.KnowledgeDescr;
import org.kie.io.Resource;
import org.kie.io.ResourceChangeNotifier;
import org.kie.io.ResourceChangeScanner;
import org.kie.io.ResourceFactoryService;
import org.kie.util.ServiceRegistryImpl;

public class ResourceFactory {
    private static ResourceFactoryService factoryService;

    public static ResourceChangeNotifier getResourceChangeNotifierService() {
        return ResourceFactory.getFactoryService().getResourceChangeNotifierService();
    }

    public static ResourceChangeScanner getResourceChangeScannerService() {
        return ResourceFactory.getFactoryService().getResourceChangeScannerService();
    }

    public static Resource newUrlResource(URL url) {
        return ResourceFactory.getFactoryService().newUrlResource(url);
    }

    public static Resource newUrlResource(String path) {
        return ResourceFactory.getFactoryService().newUrlResource(path);
    }

    public static Resource newFileResource(File file) {
        return ResourceFactory.getFactoryService().newFileSystemResource(file);
    }

    public static Resource newFileResource(String fileName) {
        return ResourceFactory.getFactoryService().newFileSystemResource(fileName);
    }

    public static Resource newByteArrayResource(byte[] bytes) {
        return ResourceFactory.getFactoryService().newByteArrayResource(bytes);
    }

    public static Resource newInputStreamResource(InputStream stream) {
        return ResourceFactory.getFactoryService().newInputStreamResource(stream);
    }

    public static Resource newInputStreamResource(InputStream stream, String encoding) {
        return ResourceFactory.getFactoryService().newInputStreamResource(stream, encoding);
    }

    public static Resource newReaderResource(Reader reader) {
        return ResourceFactory.getFactoryService().newReaderResource(reader);
    }

    public static Resource newReaderResource(Reader reader, String encoding) {
        return ResourceFactory.getFactoryService().newReaderResource(reader, encoding);
    }

    public static Resource newClassPathResource(String path) {
        return ResourceFactory.getFactoryService().newClassPathResource(path);
    }

    public static Resource newClassPathResource(String path, Class clazz) {
        return ResourceFactory.getFactoryService().newClassPathResource(path, clazz);
    }

    public static Resource newClassPathResource(String path, ClassLoader classLoader) {
        return ResourceFactory.getFactoryService().newClassPathResource(path, classLoader);
    }

    public static Resource newClassPathResource(String path, String encoding) {
        return ResourceFactory.getFactoryService().newClassPathResource(path, encoding);
    }

    public static Resource newClassPathResource(String path, String encoding, Class clazz) {
        return ResourceFactory.getFactoryService().newClassPathResource(path, encoding, clazz);
    }

    public static Resource newClassPathResource(String path, String encoding, ClassLoader classLoader) {
        return ResourceFactory.getFactoryService().newClassPathResource(path, encoding, classLoader);
    }

    public static Resource newDescrResource(KnowledgeDescr descr) {
        return ResourceFactory.getFactoryService().newDescrResource(descr);
    }

    private static synchronized void setFactoryService(ResourceFactoryService factoryService) {
        ResourceFactory.factoryService = factoryService;
    }

    private static synchronized ResourceFactoryService getFactoryService() {
        if (factoryService == null) {
            ResourceFactory.loadFactoryService();
        }
        return factoryService;
    }

    private static void loadFactoryService() {
        ResourceFactory.setFactoryService((ResourceFactoryService)ServiceRegistryImpl.getInstance().get(ResourceFactoryService.class));
    }
}

