/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.manager.deploy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorIO;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.internal.runtime.manager.deploy.TransientNamedObjectModel;
import org.kie.internal.runtime.manager.deploy.TransientObjectModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentDescriptorTest {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentDescriptorTest.class);

    @Test
    public void testWriteDeploymentDescriptorXml() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.testCustomStrategy", new Object[]{new ObjectModel("java.lang.String", new Object[]{"param1"}), "param2"})).addRequiredRole("experts");
        String deploymentDescriptorXml = descriptor.toXml();
        Assertions.assertThat((String)deploymentDescriptorXml).isNotNull();
        logger.info(deploymentDescriptorXml);
        ByteArrayInputStream stream = new ByteArrayInputStream(deploymentDescriptorXml.getBytes());
        DeploymentDescriptor fromXml = DeploymentDescriptorIO.fromXml((InputStream)stream);
        Assertions.assertThat((Object)fromXml).isNotNull();
        Assertions.assertThat((String)fromXml.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)fromXml.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)fromXml.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)fromXml.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)fromXml.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)fromXml.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)fromXml.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getRequiredRoles().size()).isEqualTo(1);
    }

    @Test
    public void testReadDeploymentDescriptorFromXml() throws Exception {
        InputStream input = this.getClass().getResourceAsStream("/deployment/deployment-descriptor-defaults.xml");
        DeploymentDescriptor descriptor = DeploymentDescriptorIO.fromXml((InputStream)input);
        Assertions.assertThat((Object)descriptor).isNotNull();
        Assertions.assertThat((String)descriptor.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)descriptor.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)descriptor.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)descriptor.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)descriptor.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)descriptor.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getRequiredRoles().size()).isEqualTo(0);
    }

    @Test
    public void testReadDeploymentDescriptorMSFromXml() throws Exception {
        InputStream input = this.getClass().getResourceAsStream("/deployment/deployment-descriptor-defaults-and-ms.xml");
        DeploymentDescriptor descriptor = DeploymentDescriptorIO.fromXml((InputStream)input);
        Assertions.assertThat((Object)descriptor).isNotNull();
        Assertions.assertThat((String)descriptor.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)descriptor.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)descriptor.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)descriptor.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)descriptor.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)descriptor.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)descriptor.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getRequiredRoles().size()).isEqualTo(1);
    }

    @Test
    public void testReadPartialDeploymentDescriptorFromXml() throws Exception {
        InputStream input = this.getClass().getResourceAsStream("/deployment/partial-deployment-descriptor.xml");
        DeploymentDescriptor descriptor = DeploymentDescriptorIO.fromXml((InputStream)input);
        Assertions.assertThat((Object)descriptor).isNotNull();
        Assertions.assertThat((String)descriptor.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)descriptor.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)descriptor.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)descriptor.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)descriptor.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.PER_PROCESS_INSTANCE);
        Assertions.assertThat((int)descriptor.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getRequiredRoles().size()).isEqualTo(0);
    }

    @Test
    public void testCreateDeploymentDescriptorWithSetters() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.setAuditMode(AuditMode.JMS);
        descriptor.setEnvironmentEntries(null);
        ArrayList<ObjectModel> marshallingStrategies = new ArrayList<ObjectModel>();
        marshallingStrategies.add(new ObjectModel("org.jbpm.testCustomStrategy", new Object[]{new ObjectModel("java.lang.String", new Object[]{"param1"}), "param2"}));
        descriptor.setMarshallingStrategies(marshallingStrategies);
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("experts");
        descriptor.setRequiredRoles(roles);
        Assertions.assertThat((Object)descriptor).isNotNull();
        Assertions.assertThat((String)descriptor.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)descriptor.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)descriptor.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)descriptor.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)descriptor.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)descriptor.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)descriptor.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getRequiredRoles().size()).isEqualTo(1);
    }

    @Test
    public void testPrintDescriptor() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()", new Object[0])).addWorkItemHandler(new NamedObjectModel("mvel", "WebService", "new org.jbpm.process.workitem.webservice.WebServiceWorkItemHandler(ksession)", new Object[0])).addWorkItemHandler(new NamedObjectModel("mvel", "Rest", "new org.jbpm.process.workitem.rest.RESTWorkItemHandler()", new Object[0])).addWorkItemHandler(new NamedObjectModel("mvel", "Service Task", "new org.jbpm.process.workitem.bpmn2.ServiceTaskHandler(ksession)", new Object[0]));
        logger.debug(descriptor.toXml());
    }

    @Test
    public void testWriteDeploymentDescriptorXmlWithDuplicateNamedObjects() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()", new Object[0])).addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.CustomSystemOutWorkItemHandler()", new Object[0])).addRequiredRole("experts");
        String deploymentDescriptorXml = descriptor.toXml();
        Assertions.assertThat((String)deploymentDescriptorXml).isNotNull();
        logger.info(deploymentDescriptorXml);
        ByteArrayInputStream stream = new ByteArrayInputStream(deploymentDescriptorXml.getBytes());
        DeploymentDescriptor fromXml = DeploymentDescriptorIO.fromXml((InputStream)stream);
        Assertions.assertThat((Object)fromXml).isNotNull();
        Assertions.assertThat((String)fromXml.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)fromXml.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)fromXml.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)fromXml.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)fromXml.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)fromXml.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getWorkItemHandlers().size()).isEqualTo(1);
        Assertions.assertThat((int)fromXml.getRequiredRoles().size()).isEqualTo(1);
    }

    @Test
    public void testCreateDeploymentDescriptorWithPrefixedRoles() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.setAuditMode(AuditMode.JMS);
        descriptor.setEnvironmentEntries(null);
        ArrayList<ObjectModel> marshallingStrategies = new ArrayList<ObjectModel>();
        marshallingStrategies.add(new ObjectModel("org.jbpm.testCustomStrategy", new Object[]{new ObjectModel("java.lang.String", new Object[]{"param1"}), "param2"}));
        descriptor.setMarshallingStrategies(marshallingStrategies);
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("view:managers");
        roles.add("execute:experts");
        roles.add("all:everyone");
        roles.add("employees");
        descriptor.setRequiredRoles(roles);
        Assertions.assertThat((Object)descriptor).isNotNull();
        Assertions.assertThat((String)descriptor.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)descriptor.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)descriptor.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)descriptor.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)descriptor.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)descriptor.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)descriptor.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((int)descriptor.getRequiredRoles().size()).isEqualTo(4);
        List toVerify = descriptor.getRequiredRoles();
        Assertions.assertThat((int)toVerify.size()).isEqualTo(4);
        Assertions.assertThat((boolean)toVerify.contains("view:managers")).isTrue();
        Assertions.assertThat((boolean)toVerify.contains("execute:experts")).isTrue();
        Assertions.assertThat((boolean)toVerify.contains("all:everyone")).isTrue();
        Assertions.assertThat((boolean)toVerify.contains("employees")).isTrue();
        toVerify = descriptor.getRequiredRoles("all");
        Assertions.assertThat((int)toVerify.size()).isEqualTo(4);
        Assertions.assertThat((boolean)toVerify.contains("managers")).isTrue();
        Assertions.assertThat((boolean)toVerify.contains("experts")).isTrue();
        Assertions.assertThat((boolean)toVerify.contains("everyone")).isTrue();
        Assertions.assertThat((boolean)toVerify.contains("employees")).isTrue();
        toVerify = descriptor.getRequiredRoles("execute");
        Assertions.assertThat((int)toVerify.size()).isEqualTo(2);
        Assertions.assertThat((boolean)toVerify.contains("experts")).isTrue();
        Assertions.assertThat((boolean)toVerify.contains("employees")).isTrue();
        toVerify = descriptor.getRequiredRoles("view");
        Assertions.assertThat((int)toVerify.size()).isEqualTo(2);
        Assertions.assertThat((boolean)toVerify.contains("managers")).isTrue();
        Assertions.assertThat((boolean)toVerify.contains("employees")).isTrue();
    }

    @Test
    public void testWriteDeploymentDescriptorXmlWithTransientElements() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().addMarshalingStrategy((ObjectModel)new TransientObjectModel("org.jbpm.testCustomStrategy", new Object[]{new ObjectModel("java.lang.String", new Object[]{"param1"}), "param2"})).addWorkItemHandler((NamedObjectModel)new TransientNamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()", new Object[0])).addRequiredRole("experts");
        String deploymentDescriptorXml = descriptor.toXml();
        Assertions.assertThat((String)deploymentDescriptorXml).isNotNull();
        logger.info(deploymentDescriptorXml);
        ByteArrayInputStream stream = new ByteArrayInputStream(deploymentDescriptorXml.getBytes());
        DeploymentDescriptor fromXml = DeploymentDescriptorIO.fromXml((InputStream)stream);
        Assertions.assertThat((Object)fromXml).isNotNull();
        Assertions.assertThat((String)fromXml.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)fromXml.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)fromXml.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)fromXml.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)fromXml.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)fromXml.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getRequiredRoles().size()).isEqualTo(1);
    }

    @Test
    public void testEmptyDeploymentDescriptor() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.testCustomStrategy", new Object[]{new ObjectModel("java.lang.String", new Object[]{"param1"}), "param2"})).addRequiredRole("experts");
        Assertions.assertThat((boolean)descriptor.isEmpty()).isFalse();
        InputStream input = this.getClass().getResourceAsStream("/deployment/empty-descriptor.xml");
        DeploymentDescriptor fromXml = DeploymentDescriptorIO.fromXml((InputStream)input);
        Assertions.assertThat((Object)fromXml).isNotNull();
        Assertions.assertThat((boolean)((DeploymentDescriptorImpl)fromXml).isEmpty()).isTrue();
        Assertions.assertThat((String)fromXml.getPersistenceUnit()).isNull();
        Assertions.assertThat((String)fromXml.getAuditPersistenceUnit()).isNull();
        Assertions.assertThat((Comparable)fromXml.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)fromXml.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)fromXml.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)fromXml.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((int)fromXml.getRequiredRoles().size()).isEqualTo(0);
    }
}

