/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.support.PomModel;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieMetaInfoBuilder;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.maven.plugin.AbstractKieMojo;
import org.kie.maven.plugin.CompilerHelper;
import org.kie.maven.plugin.DiskResourceStore;
import org.kie.maven.plugin.ExecModelMode;
import org.kie.maven.plugin.ProjectPomModel;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class BuildMojo
extends AbstractKieMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="src/main/resources")
    private File sourceFolder;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=false, defaultValue="no")
    private String usesPMML;
    @Inject
    private PlexusContainer container;
    @Parameter(property="generateModel", defaultValue="no")
    private String generateModel;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!ExecModelMode.shouldGenerateModel(this.generateModel)) {
            this.buildDrl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDrl() throws MojoFailureException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : this.project.getCompileClasspathElements()) {
                urls.add(new File(element).toURI().toURL());
            }
            this.project.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            for (Artifact artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                if (file == null) continue;
                urls.add(file.toURI().toURL());
            }
            urls.add(this.outputDirectory.toURI().toURL());
            URLClassLoader projectClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(projectClassLoader);
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
        try {
            this.setSystemProperties(this.properties);
            KieServices ks = KieServices.Factory.get();
            KieBuilderImpl kieBuilder = (KieBuilderImpl)ks.newKieBuilder(this.project.getBasedir());
            kieBuilder.setPomModel((PomModel)new ProjectPomModel(this.mavenSession));
            kieBuilder.buildAll(DrlProject.SUPPLIER, s -> s.contains(this.sourceFolder.getAbsolutePath()) || s.endsWith("pom.xml"));
            InternalKieModule kModule = (InternalKieModule)kieBuilder.getKieModule();
            ResultsImpl messages = (ResultsImpl)kieBuilder.getResults();
            List errors = messages != null ? messages.filterMessages(new Message.Level[]{Message.Level.ERROR}) : Collections.emptyList();
            Map<String, Object> kieMap = this.getKieMap();
            if (this.container != null && !kieMap.isEmpty()) {
                CompilerHelper helper = new CompilerHelper();
                helper.share(kieMap, kModule, this.getLog());
            } else {
                new KieMetaInfoBuilder(kModule).writeKieModuleMetaInfo((ResourceStore)new DiskResourceStore(this.outputDirectory));
            }
            if (!errors.isEmpty()) {
                for (Message error : errors) {
                    this.getLog().error((CharSequence)error.toString());
                }
                throw new MojoFailureException("Build failed!");
            }
            this.writeClassFiles(kModule);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.getLog().info((CharSequence)"KieModule successfully built!");
    }

    private void writeClassFiles(InternalKieModule kModule) throws MojoFailureException {
        MemoryFileSystem mfs = ((MemoryKieModule)kModule).getMemoryFileSystem();
        kModule.getFileNames().stream().filter(name -> name.endsWith(".class") && !name.contains("target/classes") && !name.contains("target\\classes")).forEach(fileName -> {
            try {
                this.saveFile(mfs, (String)fileName);
            }
            catch (MojoFailureException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void saveFile(MemoryFileSystem mfs, String fileName) throws MojoFailureException {
        MemoryFile memFile = (MemoryFile)mfs.getFile(fileName);
        Path path = Paths.get(this.outputDirectory.getPath(), memFile.getPath().toPortableString());
        try {
            Files.deleteIfExists(path);
            Files.createDirectories(path, new FileAttribute[0]);
            Files.copy(memFile.getContents(), path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iox) {
            iox.printStackTrace();
            throw new MojoFailureException("Unable to write file", (Throwable)iox);
        }
    }

    private Map<String, Object> getKieMap() {
        try {
            Map kieMap = (Map)this.container.lookup(Map.class, "java.util.HashMap", "kieMap");
            return Optional.ofNullable(kieMap).orElse(Collections.emptyMap());
        }
        catch (ComponentLookupException cle) {
            this.getLog().info((CharSequence)"kieMap not present");
            return Collections.emptyMap();
        }
    }
}

