/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.AFReleaseIdImpl;
import org.appformer.maven.support.DependencyFilter;
import org.appformer.maven.support.PomModel;

public class ProjectPomModel
implements PomModel {
    private final AFReleaseId releaseId;
    private final AFReleaseId parentReleaseId;
    private final Map<String, Set<AFReleaseId>> dependenciesByScope;

    public ProjectPomModel(MavenSession mavenSession) {
        this.releaseId = this.getReleaseIdFromMavenProject(mavenSession.getCurrentProject());
        MavenProject parentProject = mavenSession.getCurrentProject().getParent();
        this.parentReleaseId = parentProject != null ? this.getReleaseIdFromMavenProject(parentProject) : null;
        this.dependenciesByScope = this.getDirectDependenciesFromMavenSession(mavenSession);
    }

    public AFReleaseId getReleaseId() {
        return this.releaseId;
    }

    public AFReleaseId getParentReleaseId() {
        return this.parentReleaseId;
    }

    public Collection<AFReleaseId> getDependencies() {
        return this.dependenciesByScope.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<AFReleaseId> getDependencies(DependencyFilter filter) {
        HashSet<AFReleaseId> filteredDependencies = new HashSet<AFReleaseId>();
        for (Map.Entry<String, Set<AFReleaseId>> entry : this.dependenciesByScope.entrySet()) {
            for (AFReleaseId dependencyReleaseId : entry.getValue()) {
                if (!filter.accept(dependencyReleaseId, entry.getKey())) continue;
                filteredDependencies.add(dependencyReleaseId);
            }
        }
        return filteredDependencies;
    }

    private AFReleaseId getReleaseIdFromMavenProject(MavenProject mavenProject) {
        return new AFReleaseIdImpl(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion(), mavenProject.getPackaging());
    }

    private AFReleaseId getReleaseIdFromDependency(Dependency dependency) {
        return new AFReleaseIdImpl(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType());
    }

    private Map<String, Set<AFReleaseId>> getDirectDependenciesFromMavenSession(MavenSession mavenSession) {
        List dependencies = mavenSession.getCurrentProject().getDependencies();
        HashMap<String, Set<AFReleaseId>> result = new HashMap<String, Set<AFReleaseId>>();
        for (Dependency dependency : dependencies) {
            Set scopeDependencies = result.computeIfAbsent(dependency.getScope(), s -> new HashSet());
            scopeDependencies.add(this.getReleaseIdFromDependency(dependency));
        }
        return result;
    }
}

