/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.validation.DMNValidator;
import org.kie.maven.plugin.AbstractDMNValidationAwareMojo;
import org.kie.maven.plugin.ValidateDMNMojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDMNMojoFlagsTest {
    public static final Logger LOG = LoggerFactory.getLogger(ValidateDMNMojoFlagsTest.class);
    private AbstractDMNValidationAwareMojo mojo;

    @Before
    public void init() {
        this.mojo = new ValidateDMNMojo();
        this.mojo.setLog((Log)new SystemStreamLog());
    }

    @Test
    public void testFlagsOK() {
        List result = this.mojo.computeFlagsFromCSVString("VALIDATE_SCHEMA,VALIDATE_MODEL");
        ((ListAssert)((ListAssert)Assertions.assertThat((List)result).isNotNull()).hasSize(2)).contains((Object[])new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
    }

    @Test
    public void testFlagsDisable() {
        List result = this.mojo.computeFlagsFromCSVString("disabled");
        ((ListAssert)Assertions.assertThat((List)result).isNotNull()).hasSize(0);
    }

    @Test
    public void testFlagsUnknown() {
        List result = this.mojo.computeFlagsFromCSVString("VALIDATE_SCHEMA,boh");
        ((ListAssert)Assertions.assertThat((List)result).isNotNull()).hasSize(0);
    }
}

