/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.executors;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.util.io.InternalResource;
import org.kie.api.KieServices;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.dmn.api.core.GeneratedSource;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceWithConfigurationImpl;
import org.kie.maven.plugin.KieMavenPluginContext;
import org.kie.maven.plugin.helpers.ExecutorHelper;
import org.kie.maven.plugin.helpers.GenerateCodeHelper;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.JavaConfiguration;

public class GenerateDMNModelExecutor {
    public static final String RULE_CLASS_FILE_NAME = "META-INF/kie/dmn";

    private GenerateDMNModelExecutor() {
    }

    public static void generateDMN(KieMavenPluginContext kieMavenPluginContext) throws MojoExecutionException {
        File projectDir = kieMavenPluginContext.getProjectDir();
        Map<String, String> properties = kieMavenPluginContext.getProperties();
        File targetDirectory = kieMavenPluginContext.getTargetDirectory();
        String dumpKieSourcesFolder = kieMavenPluginContext.getDumpKieSourcesFolder();
        JavaConfiguration.CompilerType compilerType = kieMavenPluginContext.getCompilerType();
        Log log = kieMavenPluginContext.getLog();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        JavaCompilerSettings javaCompilerSettings = GenerateCodeHelper.createJavaCompilerSettings();
        KieServices ks = KieServices.Factory.get();
        try {
            ExecutorHelper.setSystemProperties(properties, log);
            KieBuilderImpl kieBuilder = (KieBuilderImpl)ks.newKieBuilder(projectDir);
            DMNCompilerConfigurationImpl dmnCompilerConfiguration = (DMNCompilerConfigurationImpl)DMNFactory.newCompilerConfiguration();
            HashMap<String, String> classNameSourceMap = new HashMap<String, String>();
            dmnCompilerConfiguration.setDeferredCompilation(Boolean.valueOf(true));
            dmnCompilerConfiguration.addListener(generatedSource -> {
                for (GeneratedSource generatedFile : generatedSource) {
                    Path fileNameRelative = GenerateDMNModelExecutor.transformPathToMavenPath(generatedFile);
                    log.info((CharSequence)("Generating new DMN file: " + generatedFile));
                    classNameSourceMap.put(GenerateDMNModelExecutor.getCompiledClassName(fileNameRelative), generatedFile.getSourceContent());
                }
            });
            InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModuleIgnoringErrors();
            List<String> dmnFiles = GenerateDMNModelExecutor.getDMNFIles(kieModule);
            log.info((CharSequence)("dmnFiles to process: " + dmnFiles));
            DMNAssemblerService assemblerService = new DMNAssemblerService(dmnCompilerConfiguration);
            KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            for (String dmnFile : dmnFiles) {
                GenerateDMNModelExecutor.compileDMNFile(kieModule, assemblerService, knowledgeBuilder, dmnFile);
            }
            GenerateDMNModelExecutor.createDMNFile(targetDirectory, classNameSourceMap.keySet());
            GenerateCodeHelper.compileAndWriteClasses(targetDirectory, contextClassLoader, javaCompilerSettings, compilerType, classNameSourceMap, dumpKieSourcesFolder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        log.info((CharSequence)"DMN Model successfully generated");
    }

    private static void createDMNFile(File targetDirectory, Collection<String> compiledClassNames) {
        Path dmnCompiledClassFile = Paths.get(targetDirectory.getPath(), "classes", RULE_CLASS_FILE_NAME);
        try {
            if (!Files.exists(dmnCompiledClassFile, new LinkOption[0])) {
                Files.createDirectories(dmnCompiledClassFile.getParent(), new FileAttribute[0]);
            }
            Files.write(dmnCompiledClassFile, compiledClassNames, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write file", e);
        }
    }

    private static List<String> getDMNFIles(InternalKieModule kieModule) {
        return ExecutorHelper.getFilesByType(kieModule, "dmn");
    }

    private static void compileDMNFile(InternalKieModule kieModule, DMNAssemblerService assemblerService, KnowledgeBuilder knowledgeBuilder, String dmnFile) throws Exception {
        InternalResource resource = kieModule.getResource(dmnFile);
        ResourceConfiguration resourceConfiguration = kieModule.getResourceConfiguration(dmnFile);
        ResourceWithConfigurationImpl resourceWithConfiguration = new ResourceWithConfigurationImpl((Resource)resource, resourceConfiguration, a -> {}, b -> {});
        assemblerService.addResourcesAfterRules((Object)knowledgeBuilder, Collections.singletonList(resourceWithConfiguration), ResourceType.DMN);
    }

    private static String getCompiledClassName(Path fileNameRelative) {
        return fileNameRelative.toString().replace("/", ".").replace(".java", "");
    }

    private static Path transformPathToMavenPath(GeneratedSource generatedFile) {
        Path originalFilePath;
        Path fileName = Paths.get(generatedFile.getFileName(), new String[0]);
        Path fileNameRelative = fileName.startsWith(originalFilePath = Paths.get("src/main/java", new String[0])) ? originalFilePath.relativize(fileName) : fileName;
        return fileNameRelative;
    }
}

