/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.mojos;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.kie.maven.plugin.KieMavenPluginContext;
import org.kie.maven.plugin.executors.BuildDrlExecutor;
import org.kie.maven.plugin.executors.GenerateANCExecutor;
import org.kie.maven.plugin.executors.GenerateDMNModelExecutor;
import org.kie.maven.plugin.executors.GenerateModelExecutor;
import org.kie.maven.plugin.executors.GeneratePMMLModelExecutor;
import org.kie.maven.plugin.helpers.DMNModelModeHelper;
import org.kie.maven.plugin.helpers.ExecModelModeHelper;
import org.kie.maven.plugin.mojos.AbstractKieMojo;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class BuildMojo
extends AbstractKieMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        KieMavenPluginContext kieMavenPluginContext = this.getKieMavenPluginContext();
        this.executeGenerateModel(kieMavenPluginContext);
        this.executeGenerateDMNModel(kieMavenPluginContext);
        this.executeGeneratePMMLModel(kieMavenPluginContext);
        this.executeGenerateANC(kieMavenPluginContext);
        this.executeBuildDRL(kieMavenPluginContext);
    }

    private void executeGenerateModel(KieMavenPluginContext kieMavenPluginContext) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"GenerateModel");
        boolean modelParameterEnabled = kieMavenPluginContext.isModelParameterEnabled();
        boolean modelCompilerInClassPath = kieMavenPluginContext.isModelCompilerInClass();
        if (modelParameterEnabled && modelCompilerInClassPath) {
            GenerateModelExecutor.generateModel(kieMavenPluginContext);
        } else if (modelParameterEnabled) {
            this.getLog().warn((CharSequence)"You're trying to build rule assets in a project from an executable rule model, but you did not provide the required dependency on the project classpath.\nTo enable executable rule models for your project, add the `drools-model-compiler` dependency in the `pom.xml` file of your project.\n");
        }
    }

    private void executeGenerateDMNModel(KieMavenPluginContext kieMavenPluginContext) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"GenerateDMNModel");
        boolean dmnModelParameterEnabled = DMNModelModeHelper.dmnModelParameterEnabled(kieMavenPluginContext.getGenerateDMNModel());
        boolean modelCompilerInClassPath = kieMavenPluginContext.isModelCompilerInClass();
        if (dmnModelParameterEnabled && modelCompilerInClassPath) {
            GenerateDMNModelExecutor.generateDMN(kieMavenPluginContext);
        }
    }

    private void executeGeneratePMMLModel(KieMavenPluginContext kieMavenPluginContext) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"GeneratePMMLModel");
        boolean modelCompilerInClassPath = kieMavenPluginContext.isModelCompilerInClass();
        if (!modelCompilerInClassPath) {
            this.getLog().warn((CharSequence)"Skipping `generatePMMLModel` because you did not provide the required dependency on the project classpath.\nTo enable it for your project, add the `drools-model-compiler` dependency in the `pom.xml` file of your project.\n");
        } else {
            GeneratePMMLModelExecutor.generatePMMLModel(kieMavenPluginContext);
        }
    }

    private void executeGenerateANC(KieMavenPluginContext kieMavenPluginContext) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"GenerateANC");
        String generateModel = kieMavenPluginContext.getGenerateModel();
        boolean ancParameterEnabled = ExecModelModeHelper.ancEnabled(generateModel);
        boolean modelCompilerInClassPath = kieMavenPluginContext.isModelCompilerInClass();
        if (ancParameterEnabled && modelCompilerInClassPath) {
            GenerateANCExecutor.generateANC(kieMavenPluginContext);
        } else if (ancParameterEnabled) {
            this.getLog().warn((CharSequence)"You're trying to build rule assets in a project from an executable rule model, but you did not provide the required dependency on the project classpath.\nTo enable executable rule models for your project, add the `drools-model-compiler` dependency in the `pom.xml` file of your project.\n");
        }
    }

    private void executeBuildDRL(KieMavenPluginContext kieMavenPluginContext) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"BuildDRL");
        boolean modelParameterEnabled = kieMavenPluginContext.isModelParameterEnabled();
        boolean modelCompilerInClassPath = kieMavenPluginContext.isModelCompilerInClass();
        if (!modelParameterEnabled || !modelCompilerInClassPath) {
            BuildDrlExecutor.buildDrl(kieMavenPluginContext);
        }
    }
}

