/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.mojos;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.WriterFactory;
import org.apache.maven.shared.utils.io.IOUtil;
import org.apache.maven.shared.utils.xml.XmlStreamWriter;
import org.kie.maven.plugin.ArtifactItem;
import org.kie.maven.plugin.KieMavenPluginContext;
import org.kie.maven.plugin.mojos.AbstractKieMojo;

@Mojo(name="package-dependencies-kjar", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageKjarDependenciesMojo
extends AbstractKieMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.*)::(.+)");
    @Parameter
    private String classifier;
    @Component
    private ProjectBuilder projectBuilder;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private DependencyResolver dependencyResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Parameter(property="remoteRepositories")
    private String remoteRepositories;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Parameter
    private List<ArtifactItem> artifactItems;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.artifactItems == null || this.artifactItems.isEmpty()) {
            log.info((CharSequence)"Skipping plugin execution");
            return;
        }
        KieMavenPluginContext kieMavenPluginContext = this.getKieMavenPluginContext();
        MavenSession mavenSession = kieMavenPluginContext.getMavenSession();
        File outputDirectory = kieMavenPluginContext.getOutputDirectory();
        try {
            File outputFolder;
            ArtifactRepositoryPolicy always = new ArtifactRepositoryPolicy(true, "always", "warn");
            ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>();
            if (this.pomRemoteRepositories != null) {
                repoList.addAll(this.pomRemoteRepositories);
            }
            if (this.remoteRepositories != null) {
                String[] repos;
                for (String repo : repos = StringUtils.split((String)this.remoteRepositories, (String)",")) {
                    repoList.add(PackageKjarDependenciesMojo.parseRepository(repo, always, this.repositoryLayouts));
                }
            }
            if (!(outputFolder = new File(outputDirectory + "/KIE-INF/lib")).exists()) {
                outputFolder.mkdirs();
            }
            log.info((CharSequence)("Create directory: " + outputFolder));
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            for (ArtifactItem artifactItem : this.artifactItems) {
                ArtifactCoordinate coordinate = PackageKjarDependenciesMojo.toArtifactCoordinate(artifactItem, this.artifactHandlerManager);
                Artifact kjar = PackageKjarDependenciesMojo.resolveArtifact(coordinate, this.artifactResolver, repoList, mavenSession, this.repositorySystem, log);
                log.info((CharSequence)("Resolved kjar " + kjar + " dependency"));
                artifacts.add(kjar);
                ProjectBuildingRequest buildingRequest = PackageKjarDependenciesMojo.buildMavenRequest(repoList, mavenSession, this.repositorySystem);
                Iterable results = this.dependencyResolver.resolveDependencies(buildingRequest, (DependableCoordinate)PackageKjarDependenciesMojo.toDefaultDependableCoordinate(kjar), null);
                for (ArtifactResult result : results) {
                    coordinate = PackageKjarDependenciesMojo.toArtifactCoordinate(result.getArtifact(), this.artifactHandlerManager);
                    Artifact kjarDependency = PackageKjarDependenciesMojo.resolveArtifact(coordinate, this.artifactResolver, repoList, mavenSession, this.repositorySystem, log);
                    artifacts.add(kjarDependency);
                }
            }
            for (Artifact artifact : artifacts) {
                log.info((CharSequence)("Copying artifact and creating effective pom: " + artifact));
                PackageKjarDependenciesMojo.writeEffectivePom(this.projectBuilder.build(artifact, mavenSession.getProjectBuildingRequest()).getProject(), new File(outputFolder, PackageKjarDependenciesMojo.toFile(artifact)), log);
                File local = artifact.getFile();
                try (FileOutputStream fos = new FileOutputStream(new File(outputFolder, local.getName()));){
                    Files.copy(local.toPath(), fos);
                }
            }
        }
        catch (IOException | ProjectBuildingException | ArtifactResolverException | DependencyResolverException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)e);
        }
    }

    private static String toFile(Artifact kjarDependency) {
        return kjarDependency.getArtifactId() + "-" + kjarDependency.getVersion() + ".pom";
    }

    private static File writeEffectivePom(MavenProject mavenProject, File output, Log log) throws MojoExecutionException {
        Model m = mavenProject.getModel();
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter((File)output);
            new MavenXpp3Writer().write((Writer)writer, m);
            log.debug((CharSequence)("Written effective pom at:" + output.getAbsolutePath()));
            File file = output;
            return file;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing file: " + e.getMessage(), (Exception)e);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private static Artifact resolveArtifact(ArtifactCoordinate artifact, ArtifactResolver artifactResolver, List<ArtifactRepository> repoList, MavenSession mavenSession, RepositorySystem repositorySystem, Log log) throws ArtifactResolverException {
        ProjectBuildingRequest buildingRequest = PackageKjarDependenciesMojo.buildMavenRequest(repoList, mavenSession, repositorySystem);
        log.debug((CharSequence)("resolving kjar dependency: " + artifact));
        ArtifactResult artifactResolverResult = artifactResolver.resolveArtifact(buildingRequest, artifact);
        return artifactResolverResult.getArtifact();
    }

    private static ProjectBuildingRequest buildMavenRequest(List<ArtifactRepository> repoList, MavenSession mavenSession, RepositorySystem repositorySystem) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(mavenSession.getProjectBuildingRequest());
        Settings settings = mavenSession.getSettings();
        repositorySystem.injectMirror(repoList, settings.getMirrors());
        repositorySystem.injectProxy(repoList, settings.getProxies());
        repositorySystem.injectAuthentication(repoList, settings.getServers());
        buildingRequest.setRemoteRepositories(repoList);
        return buildingRequest;
    }

    private static ArtifactCoordinate toArtifactCoordinate(Artifact artifact, ArtifactHandlerManager artifactHandlerManager) {
        ArtifactHandler artifactHandler = artifactHandlerManager.getArtifactHandler(artifact.getType());
        DefaultArtifactCoordinate gav = new DefaultArtifactCoordinate();
        gav.setGroupId(artifact.getGroupId());
        gav.setArtifactId(artifact.getArtifactId());
        gav.setVersion(artifact.getVersion());
        gav.setClassifier(artifact.getClassifier());
        gav.setExtension(artifactHandler.getExtension());
        return gav;
    }

    private static ArtifactCoordinate toArtifactCoordinate(ArtifactItem artifact, ArtifactHandlerManager artifactHandlerManager) {
        ArtifactHandler artifactHandler = artifactHandlerManager.getArtifactHandler(artifact.getType());
        DefaultArtifactCoordinate gav = new DefaultArtifactCoordinate();
        gav.setGroupId(artifact.getGroupId());
        gav.setArtifactId(artifact.getArtifactId());
        gav.setVersion(artifact.getVersion());
        gav.setClassifier(artifact.getClassifier());
        gav.setExtension(artifactHandler.getExtension());
        return gav;
    }

    private static DefaultDependableCoordinate toDefaultDependableCoordinate(Artifact artifact) {
        DefaultDependableCoordinate gav = new DefaultDependableCoordinate();
        gav.setArtifactId(artifact.getArtifactId());
        gav.setGroupId(artifact.getGroupId());
        gav.setVersion(artifact.getVersion());
        gav.setClassifier(artifact.getClassifier());
        gav.setType(artifact.getType());
        return gav;
    }

    private static ArtifactRepository parseRepository(String repo, ArtifactRepositoryPolicy policy, Map<String, ArtifactRepositoryLayout> repositoryLayouts) throws MojoFailureException {
        String id = "temp";
        ArtifactRepositoryLayout layout = PackageKjarDependenciesMojo.getLayout("default", repositoryLayouts);
        String url = repo;
        if (repo.contains("::")) {
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(repo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)repo, "Invalid syntax for repository: " + repo, "Invalid syntax for repository. Use \"id::layout::url\" or \"URL\".");
            }
            id = matcher.group(1).trim();
            if (!StringUtils.isEmpty((String)matcher.group(2))) {
                layout = PackageKjarDependenciesMojo.getLayout(matcher.group(2).trim(), repositoryLayouts);
            }
            url = matcher.group(3).trim();
        }
        return new MavenArtifactRepository(id, url, layout, policy, policy);
    }

    private static ArtifactRepositoryLayout getLayout(String id, Map<String, ArtifactRepositoryLayout> repositoryLayouts) throws MojoFailureException {
        ArtifactRepositoryLayout layout = repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoFailureException((Object)id, "Invalid repository layout", "Invalid repository layout: " + id);
        }
        return layout;
    }
}

