/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.mojos;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.maven.plugin.helpers.DMNValidationHelper;
import org.kie.maven.plugin.mojos.AbstractKieMojo;

@Mojo(name="validateDMN", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ValidateDMNMojo
extends AbstractKieMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        ArrayList<DMNValidator.Validation> actualFlags = new ArrayList<DMNValidator.Validation>(DMNValidationHelper.computeFlagsFromCSVString(this.validateDMN, log));
        actualFlags.retainAll(Arrays.asList(DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL));
        if (actualFlags.isEmpty()) {
            log.info((CharSequence)"No VALIDATE_SCHEMA or VALIDATE_MODEL flags set, skipping.");
            return;
        }
        List<Path> dmnModelPaths = ValidateDMNMojo.computeDmnModelPaths(this.resources, log);
        if (dmnModelPaths.isEmpty()) {
            log.info((CharSequence)"No DMN Models found.");
            return;
        }
        dmnModelPaths.forEach(x -> log.info((CharSequence)("Will validate DMN model: " + x.toString())));
        log.info((CharSequence)"Initializing DMNValidator...");
        DMNValidator validator = ValidateDMNMojo.getDMNValidator(this.resources, log);
        log.info((CharSequence)"DMNValidator initialized.");
        List validation = validator.validateUsing(actualFlags.toArray(new DMNValidator.Validation[0])).theseModels(dmnModelPaths.stream().map(Path::toFile).collect(Collectors.toList()).toArray(new File[0]));
        DMNValidationHelper.logValidationMessages(validation, ValidateDMNMojo::validateMsgPrefixer, Message::getText, log);
        if (validation.stream().anyMatch(m -> m.getLevel() == Message.Level.ERROR)) {
            throw new MojoFailureException("There are DMN Validation Error(s).");
        }
    }

    private static String validateMsgPrefixer(DMNMessage msg) {
        if (msg.getSourceReference() instanceof DMNModelInstrumentedBase) {
            DMNModelInstrumentedBase ib = (DMNModelInstrumentedBase)msg.getSourceReference();
            while (ib.getParent() != null) {
                ib = ib.getParent();
            }
            if (ib instanceof Definitions) {
                return ((Definitions)ib).getName() + ": ";
            }
        }
        return "";
    }

    private static List<Path> computeDmnModelPaths(List<Resource> resources, Log log) throws MojoExecutionException {
        ArrayList<Path> dmnModelPaths = new ArrayList<Path>();
        for (Path p : DMNValidationHelper.resourcesPaths(resources, log)) {
            log.info((CharSequence)("Looking for DMN models in path: " + p));
            try {
                Stream<Path> walk = Files.walk(p, new FileVisitOption[0]);
                try {
                    walk.filter(f -> f.toString().endsWith(".dmn")).forEach(dmnModelPaths::add);
                }
                finally {
                    if (walk == null) continue;
                    walk.close();
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed executing ValidateDMNMojo", e);
            }
        }
        return dmnModelPaths;
    }

    private static DMNValidator getDMNValidator(List<Resource> resources, Log log) throws MojoExecutionException {
        List<DMNProfile> dmnProfiles = DMNValidationHelper.computeDMNProfiles(resources, log);
        return DMNValidatorFactory.newValidator(dmnProfiles);
    }
}

