/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.utils;

import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.utils.PrimitiveBoxedUtils;

public class PrimitiveBoxedUtilsTest {
    private static final Class<?>[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Double.TYPE};
    private static final Class<?>[] boxeds = new Class[]{Boolean.class, Byte.class, Character.class, Float.class, Integer.class, Long.class, Short.class, Double.class};
    private static final int types = primitives.length;

    @Test
    public void areSameWithBoxing() {
        int i;
        for (i = 0; i < types; ++i) {
            Assert.assertTrue((boolean)PrimitiveBoxedUtils.areSameWithBoxing(primitives[i], boxeds[i]));
            Assert.assertTrue((boolean)PrimitiveBoxedUtils.areSameWithBoxing(boxeds[i], primitives[i]));
            Assert.assertTrue((boolean)PrimitiveBoxedUtils.areSameWithBoxing(primitives[i], primitives[i]));
            Assert.assertTrue((boolean)PrimitiveBoxedUtils.areSameWithBoxing(boxeds[i], boxeds[i]));
        }
        for (i = 0; i < types; ++i) {
            Assert.assertFalse((boolean)PrimitiveBoxedUtils.areSameWithBoxing(primitives[i], boxeds[types - 1 - i]));
            Assert.assertFalse((boolean)PrimitiveBoxedUtils.areSameWithBoxing(boxeds[i], primitives[types - 1 - i]));
        }
        Assert.assertFalse((boolean)PrimitiveBoxedUtils.areSameWithBoxing(String.class, String.class));
        Assert.assertFalse((boolean)PrimitiveBoxedUtils.areSameWithBoxing(Double.TYPE, String.class));
        Assert.assertFalse((boolean)PrimitiveBoxedUtils.areSameWithBoxing(String.class, Double.class));
    }

    @Test
    public void getKiePMMLPrimitiveBoxed() {
        for (int i = 0; i < types; ++i) {
            Assert.assertTrue((boolean)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(primitives[i]).isPresent());
            Assert.assertTrue((boolean)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(boxeds[i]).isPresent());
        }
        Assert.assertFalse((boolean)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(String.class).isPresent());
    }

    @Test
    public void isSameWithBoxing() {
        for (int i = 0; i < types; ++i) {
            Assert.assertTrue((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(primitives[i]).get()).isSameWithBoxing(boxeds[i]));
            Assert.assertTrue((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(boxeds[i]).get()).isSameWithBoxing(primitives[i]));
            Assert.assertTrue((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(primitives[i]).get()).isSameWithBoxing(primitives[i]));
            Assert.assertTrue((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(boxeds[i]).get()).isSameWithBoxing(boxeds[i]));
            Assert.assertFalse((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(primitives[i]).get()).isSameWithBoxing(String.class));
            Assert.assertFalse((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(boxeds[i]).get()).isSameWithBoxing(String.class));
        }
    }
}

