/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.Test;
import org.kie.pmml.api.enums.builtinfunctions.DistributionFunctions;

public class DistributionFunctionsTest {
    public static final List<DistributionFunctions> supportedDistributionFunctions = new ArrayList<DistributionFunctions>();
    public static final List<DistributionFunctions> unsupportedDistributionFunctions;

    @Test
    public void getNormalCDFValueCorrectInput() {
        Object[] input1 = new Object[]{24.11, 24.54, 1.23};
        Object retrieved = DistributionFunctions.NORMAL_CDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.363, Offset.offset((Number)0.001));
        Object[] input2 = new Object[]{9.12, 11.35, 3.78};
        retrieved = DistributionFunctions.NORMAL_CDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.278, Offset.offset((Number)0.001));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNormalCDFValueWrongSizeInput() {
        Object[] input = new Object[]{34};
        DistributionFunctions.NORMAL_CDF.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNormalCDFValueWrongTypeInput() {
        Object[] input = new Object[]{34, 25.3, "22.1"};
        DistributionFunctions.NORMAL_CDF.getValue(input);
    }

    @Test
    public void getNormalPDFValueCorrectInput() {
        Object[] input1 = new Object[]{2, 7, 2};
        Object retrieved = DistributionFunctions.NORMAL_PDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.00876, Offset.offset((Number)0.001));
        Object[] input2 = new Object[]{9.12, 11.35, 3.78};
        retrieved = DistributionFunctions.NORMAL_PDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.08868, Offset.offset((Number)0.001));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNormalPDFValueWrongSizeInput() {
        Object[] input = new Object[]{34};
        DistributionFunctions.NORMAL_PDF.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNormalPDFValueWrongTypeInput() {
        Object[] input = new Object[]{34, 25.3, "22.1"};
        DistributionFunctions.NORMAL_PDF.getValue(input);
    }

    @Test
    public void getStdNormalCDFValueCorrectInput() {
        Object[] input1 = new Object[]{2};
        Object retrieved = DistributionFunctions.STD_NORMAL_CDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.97725, Offset.offset((Number)0.001));
        Object[] input2 = new Object[]{1.243};
        retrieved = DistributionFunctions.STD_NORMAL_CDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.89307, Offset.offset((Number)0.001));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getStdNormalCDFValueWrongSizeInput() {
        Object[] input = new Object[]{34, 312, 11};
        DistributionFunctions.STD_NORMAL_CDF.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getStdNormalCDFValueWrongTypeInput() {
        Object[] input = new Object[]{"34"};
        DistributionFunctions.STD_NORMAL_CDF.getValue(input);
    }

    @Test
    public void getStdNormalPDFValueCorrectInput() {
        Object[] input1 = new Object[]{2};
        Object retrieved = DistributionFunctions.STD_NORMAL_PDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.05399, Offset.offset((Number)0.001));
        Object[] input2 = new Object[]{1.243};
        retrieved = DistributionFunctions.STD_NORMAL_PDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.18425, Offset.offset((Number)0.001));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getStdNormalPDFValueWrongSizeInput() {
        Object[] input = new Object[]{34, 312, 11};
        DistributionFunctions.STD_NORMAL_PDF.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getStdNormalPDFValueWrongTypeInput() {
        Object[] input = new Object[]{"34"};
        DistributionFunctions.STD_NORMAL_PDF.getValue(input);
    }

    @Test
    public void getErfValueCorrectInput() {
        Object[] input1 = new Object[]{2};
        Object retrieved = DistributionFunctions.ERF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.9953223, Offset.offset((Number)0.001));
        Object[] input2 = new Object[]{1.243};
        retrieved = DistributionFunctions.ERF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.92123, Offset.offset((Number)0.001));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getErfValueWrongSizeInput() {
        Object[] input = new Object[]{34, 312, 11};
        DistributionFunctions.ERF.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getErfValueWrongTypeInput() {
        Object[] input = new Object[]{"34"};
        DistributionFunctions.ERF.getValue(input);
    }

    @Test
    public void getNormalIDFValueCorrectInput() {
        Object[] input1 = new Object[]{0.75, 1.23, 0.2};
        Object retrieved = DistributionFunctions.NORMAL_IDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(1.36, Offset.offset((Number)0.01));
        Object[] input2 = new Object[]{0.912, 11.35, 3.78};
        retrieved = DistributionFunctions.NORMAL_IDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(16.46, Offset.offset((Number)0.01));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNormalIDFValueWrongSizeInput() {
        Object[] input = new Object[]{34};
        DistributionFunctions.NORMAL_IDF.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNormalIDFValueWrongTypeInput() {
        Object[] input = new Object[]{34, 25.3, "22.1"};
        DistributionFunctions.NORMAL_IDF.getValue(input);
    }

    @Test
    public void getStdNormalIDFValueCorrectInput() {
        Object[] input1 = new Object[]{0.75};
        Object retrieved = DistributionFunctions.STD_NORMAL_IDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.67, Offset.offset((Number)0.01));
        Object[] input2 = new Object[]{0.912};
        retrieved = DistributionFunctions.STD_NORMAL_IDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(1.35, Offset.offset((Number)0.01));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getStdNormalIDFValueWrongSizeInput() {
        Object[] input = new Object[]{34, 312, 11};
        DistributionFunctions.STD_NORMAL_IDF.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getStdNormalIDFValueWrongTypeInput() {
        Object[] input = new Object[]{"34"};
        DistributionFunctions.STD_NORMAL_IDF.getValue(input);
    }

    static {
        supportedDistributionFunctions.add(DistributionFunctions.NORMAL_CDF);
        supportedDistributionFunctions.add(DistributionFunctions.NORMAL_PDF);
        supportedDistributionFunctions.add(DistributionFunctions.STD_NORMAL_CDF);
        supportedDistributionFunctions.add(DistributionFunctions.STD_NORMAL_PDF);
        supportedDistributionFunctions.add(DistributionFunctions.ERF);
        supportedDistributionFunctions.add(DistributionFunctions.NORMAL_IDF);
        supportedDistributionFunctions.add(DistributionFunctions.STD_NORMAL_IDF);
        unsupportedDistributionFunctions = new ArrayList<DistributionFunctions>();
    }
}

