/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.builtinfunctions.BooleanFunctions;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;

public class BooleanFunctionsTest {
    public static final List<BooleanFunctions> supportedBooleanFunctions;
    public static final List<BooleanFunctions> unsupportedBooleanFunctions;
    private static final MiningField EMPTY_MINING_FIELD;

    @Test
    public void getIsMissingValueCorrectInput() {
        Object[] input1 = new Object[]{null};
        Object retrieved = BooleanFunctions.IS_MISSING.getValue(input1, EMPTY_MINING_FIELD);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35};
        retrieved = BooleanFunctions.IS_MISSING.getValue(input2, EMPTY_MINING_FIELD);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        for (INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod : INVALID_VALUE_TREATMENT_METHOD.values()) {
            MiningField referredByFieldRef = this.getReferredByFieldRef(invalidValueTreatmentMethod, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
            boolean expected = INVALID_VALUE_TREATMENT_METHOD.AS_MISSING.equals((Object)invalidValueTreatmentMethod);
            Assertions.assertThat((Object)BooleanFunctions.IS_MISSING.getValue(input2, referredByFieldRef)).isEqualTo((Object)expected);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsMissingValueWrongSizeInput() {
        Object[] input = new Object[]{34, 34, 34};
        BooleanFunctions.IS_MISSING.getValue(input, EMPTY_MINING_FIELD);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsMissingValueNoMiningField() {
        Object[] input = new Object[]{34};
        BooleanFunctions.IS_MISSING.getValue(input, null);
    }

    @Test
    public void getIsNotMissingValueCorrectInput() {
        Object[] input1 = new Object[]{35};
        Object retrieved = BooleanFunctions.IS_NOT_MISSING.getValue(input1, EMPTY_MINING_FIELD);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{null};
        retrieved = BooleanFunctions.IS_NOT_MISSING.getValue(input2, EMPTY_MINING_FIELD);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        for (INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod : INVALID_VALUE_TREATMENT_METHOD.values()) {
            MiningField referredByFieldRef = this.getReferredByFieldRef(invalidValueTreatmentMethod, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
            boolean expected = !INVALID_VALUE_TREATMENT_METHOD.AS_MISSING.equals((Object)invalidValueTreatmentMethod);
            Assertions.assertThat((Object)BooleanFunctions.IS_NOT_MISSING.getValue(input1, referredByFieldRef)).isEqualTo((Object)expected);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsNotMissingValueWrongSizeInput() {
        Object[] input = new Object[]{34, 34, 34};
        BooleanFunctions.IS_NOT_MISSING.getValue(input, EMPTY_MINING_FIELD);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsNotMissingValueNoMiningField() {
        Object[] input = new Object[]{34};
        BooleanFunctions.IS_NOT_MISSING.getValue(input, null);
    }

    @Test
    public void getIsValidValueCorrectInput() {
        Object[] input1 = new Object[]{35};
        MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
        Object retrieved = BooleanFunctions.IS_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "35"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "36"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{"VALUE"};
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "VALUE"), Collections.emptyList());
        retrieved = BooleanFunctions.IS_VALID.getValue(input2, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "VELUE"), Collections.emptyList());
        retrieved = BooleanFunctions.IS_VALID.getValue(input2, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input3 = new Object[]{null};
        retrieved = BooleanFunctions.IS_VALID.getValue(input3, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsValidValueWrongSizeInput() {
        Object[] input = new Object[]{34, 34};
        MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
        BooleanFunctions.IS_VALID.getValue(input, referredByFieldRef);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsValidValueWrongTypeInput() {
        Object[] input = new Object[]{"34"};
        MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
        BooleanFunctions.IS_VALID.getValue(input, referredByFieldRef);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsValidValueWrongNoMiningField() {
        Object[] input = new Object[]{34};
        BooleanFunctions.IS_VALID.getValue(input, null);
    }

    @Test
    public void getIsNotValidValueCorrectInput() {
        Object[] input1 = new Object[]{35};
        MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
        Object retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "35"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        referredByFieldRef = this.getReferredByFieldRef(INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, Arrays.asList("123", "36"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        referredByFieldRef = this.getReferredByFieldRef(INVALID_VALUE_TREATMENT_METHOD.AS_IS, Arrays.asList("123", "36"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "36"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{"VALUE"};
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "VALUE"), Collections.emptyList());
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input2, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "VELUE"), Collections.emptyList());
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input2, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input3 = new Object[]{null};
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input3, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsNotValidValueWrongSizeInput() {
        Object[] input = new Object[]{34, 34};
        MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
        BooleanFunctions.IS_NOT_VALID.getValue(input, referredByFieldRef);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsNotValidValueWrongTypeInput() {
        Object[] input = new Object[]{"34"};
        MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
        BooleanFunctions.IS_NOT_VALID.getValue(input, referredByFieldRef);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsNotValidValueWrongNoMiningField() {
        Object[] input = new Object[]{34};
        BooleanFunctions.IS_NOT_VALID.getValue(input, null);
    }

    @Test
    public void getEqualValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12};
        Object retrieved = BooleanFunctions.EQUAL.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.EQUAL.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getEqualValueWrongSizeInput() {
        Object[] input = new Object[]{34, 34, 34};
        BooleanFunctions.EQUAL.getValue(input, null);
    }

    @Test
    public void getNotEqualValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12};
        Object retrieved = BooleanFunctions.NOT_EQUAL.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.NOT_EQUAL.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNotEqualValueWrongSizeInput() {
        Object[] input = new Object[]{34, 34, 34};
        BooleanFunctions.NOT_EQUAL.getValue(input, null);
    }

    @Test
    public void getLessThanValueCorrectInput() {
        Object[] input1 = new Object[]{35, 37};
        Object retrieved = BooleanFunctions.LESS_THAN.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.LESS_THAN.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input3 = new Object[]{35, 12};
        retrieved = BooleanFunctions.LESS_THAN.getValue(input3, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getLessThanValueWrongTypeInput() {
        Object[] input = new Object[]{34, "A"};
        BooleanFunctions.LESS_THAN.getValue(input, null);
    }

    @Test
    public void getLessOrEqualValueCorrectInput() {
        Object[] input1 = new Object[]{35, 37};
        Object retrieved = BooleanFunctions.LESS_OR_EQUAL.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.LESS_OR_EQUAL.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input3 = new Object[]{35, 12};
        retrieved = BooleanFunctions.LESS_OR_EQUAL.getValue(input3, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getLessOrEqualValueWrongTypeInput() {
        Object[] input = new Object[]{34, "A"};
        BooleanFunctions.LESS_OR_EQUAL.getValue(input, null);
    }

    @Test
    public void getGreaterThanValueCorrectInput() {
        Object[] input1 = new Object[]{35, 37};
        Object retrieved = BooleanFunctions.GREATER_THAN.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.GREATER_THAN.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input3 = new Object[]{35, 12};
        retrieved = BooleanFunctions.GREATER_THAN.getValue(input3, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getGreaterThanValueWrongTypeInput() {
        Object[] input = new Object[]{34, "A"};
        BooleanFunctions.GREATER_THAN.getValue(input, null);
    }

    @Test
    public void getGreaterOrEqualValueCorrectInput() {
        Object[] input1 = new Object[]{35, 37};
        Object retrieved = BooleanFunctions.GREATER_OR_EQUAL.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.GREATER_OR_EQUAL.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input3 = new Object[]{35, 12};
        retrieved = BooleanFunctions.GREATER_OR_EQUAL.getValue(input3, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getGreaterOrEqualValueWrongTypeInput() {
        Object[] input = new Object[]{34, "A"};
        BooleanFunctions.GREATER_OR_EQUAL.getValue(input, null);
    }

    @Test
    public void getAndValueCorrectInput() {
        Object[] input1 = new Object[]{true, Boolean.valueOf("false")};
        Object retrieved = BooleanFunctions.AND.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{true, Boolean.valueOf("true")};
        retrieved = BooleanFunctions.AND.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAndValueWrongTypeInput() {
        Object[] input = new Object[]{true, "false"};
        BooleanFunctions.AND.getValue(input, null);
    }

    @Test
    public void getOrValueCorrectInput() {
        Object[] input1 = new Object[]{true, Boolean.valueOf("false")};
        Object retrieved = BooleanFunctions.OR.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{false, Boolean.valueOf("true")};
        retrieved = BooleanFunctions.OR.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input3 = new Object[]{false, Boolean.valueOf("false")};
        retrieved = BooleanFunctions.OR.getValue(input3, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getOrValueWrongTypeInput() {
        Object[] input = new Object[]{true, "false"};
        BooleanFunctions.OR.getValue(input, null);
    }

    @Test
    public void getNotValueCorrectInput() {
        Object[] input1 = new Object[]{true};
        Object retrieved = BooleanFunctions.NOT.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{Boolean.valueOf("false")};
        retrieved = BooleanFunctions.NOT.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNotValueWrongTypeInput() {
        Object[] input = new Object[]{"false"};
        BooleanFunctions.NOT.getValue(input, null);
    }

    @Test
    public void getIsInValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 35, 435, "A"};
        Object retrieved = BooleanFunctions.IS_IN.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35, 36, "35"};
        retrieved = BooleanFunctions.IS_IN.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsInEqualValueWrongSizeInput() {
        Object[] input = new Object[]{34};
        BooleanFunctions.IS_IN.getValue(input, null);
    }

    @Test
    public void getIsNotInValueCorrectInput() {
        Object[] input1 = new Object[]{35, 36, "35"};
        Object retrieved = BooleanFunctions.IS_NOT_IN.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35, 12, 35, 435, "A"};
        retrieved = BooleanFunctions.IS_NOT_IN.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIsNotInEqualValueWrongSizeInput() {
        Object[] input = new Object[]{34};
        BooleanFunctions.IS_NOT_IN.getValue(input, null);
    }

    @Test
    public void getIfFValueCorrectInput() {
        Object[] input1 = new Object[]{true, 36, "35"};
        Object retrieved = BooleanFunctions.IF.getValue(input1, null);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)36);
        Object[] input2 = new Object[]{false, 12, 35};
        retrieved = BooleanFunctions.IF.getValue(input2, null);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)35);
        Object[] input3 = new Object[]{false, 12};
        retrieved = BooleanFunctions.IF.getValue(input3, null);
        Assertions.assertThat((Object)retrieved).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIfFEqualValueWrongSizeInput() {
        Object[] input = new Object[]{34};
        BooleanFunctions.IF.getValue(input, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getIfFEqualValueWrongTypeInput() {
        Object[] input = new Object[]{"true", 36, "35"};
        BooleanFunctions.IF.getValue(input, null);
    }

    private MiningField getReferredByFieldRef(INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod, List<String> allowedValues, List<Interval> intervals) {
        return new MiningField("TEST", null, null, null, null, invalidValueTreatmentMethod, null, null, allowedValues, intervals);
    }

    static {
        EMPTY_MINING_FIELD = new MiningField("TEST", null, null, null, null, null, null, null, null, null);
        supportedBooleanFunctions = new ArrayList<BooleanFunctions>();
        supportedBooleanFunctions.add(BooleanFunctions.EQUAL);
        supportedBooleanFunctions.add(BooleanFunctions.NOT_EQUAL);
        supportedBooleanFunctions.add(BooleanFunctions.LESS_THAN);
        supportedBooleanFunctions.add(BooleanFunctions.LESS_OR_EQUAL);
        supportedBooleanFunctions.add(BooleanFunctions.GREATER_THAN);
        supportedBooleanFunctions.add(BooleanFunctions.GREATER_OR_EQUAL);
        supportedBooleanFunctions.add(BooleanFunctions.AND);
        supportedBooleanFunctions.add(BooleanFunctions.OR);
        supportedBooleanFunctions.add(BooleanFunctions.NOT);
        supportedBooleanFunctions.add(BooleanFunctions.IS_MISSING);
        supportedBooleanFunctions.add(BooleanFunctions.IS_NOT_MISSING);
        supportedBooleanFunctions.add(BooleanFunctions.IS_VALID);
        supportedBooleanFunctions.add(BooleanFunctions.IS_NOT_VALID);
        supportedBooleanFunctions.add(BooleanFunctions.IS_IN);
        supportedBooleanFunctions.add(BooleanFunctions.IS_NOT_IN);
        supportedBooleanFunctions.add(BooleanFunctions.IF);
        unsupportedBooleanFunctions = new ArrayList<BooleanFunctions>();
    }
}

