/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.builtinfunctions.StringFunctions;

public class StringFunctionsTest {
    public static final List<StringFunctions> supportedStringFunctions = new ArrayList<StringFunctions>();
    public static final List<StringFunctions> unsupportedStringFunctions;

    @Test
    public void getLowercaseValueCorrectInput() {
        Object[] input = new Object[]{"AwdC"};
        Object retrieved = StringFunctions.LOWERCASE.getValue(input);
        Assert.assertEquals((Object)"awdc", (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getLowercaseValueWrongSizeInput() {
        Object[] input = new Object[]{"AwdC", "AwdB"};
        StringFunctions.LOWERCASE.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getLowercaseValueWrongTypeInput() {
        Object[] input = new Object[]{34};
        StringFunctions.LOWERCASE.getValue(input);
    }

    @Test
    public void getUppercaseValueCorrectInput() {
        Object[] input = new Object[]{"AwdC"};
        Object retrieved = StringFunctions.UPPERCASE.getValue(input);
        Assert.assertEquals((Object)"AWDC", (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getUppercaseValueWrongSizeInput() {
        Object[] input = new Object[]{"AwdC", "AwdB"};
        StringFunctions.UPPERCASE.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getUppercaseValueWrongTypeInput() {
        Object[] input = new Object[]{34};
        StringFunctions.UPPERCASE.getValue(input);
    }

    @Test
    public void getStringLengthValueCorrectInput() {
        Object[] input = new Object[]{"AwdC"};
        Object retrieved = StringFunctions.STRING_LENGTH.getValue(input);
        Assert.assertEquals((Object)4, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getStringLengthValueWrongSizeInput() {
        Object[] input = new Object[]{"AwdC", "AwdB"};
        StringFunctions.STRING_LENGTH.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getStringLengthValueWrongTypeInput() {
        Object[] input = new Object[]{34};
        StringFunctions.STRING_LENGTH.getValue(input);
    }

    @Test
    public void getSubstringValueCorrectInput() {
        Object[] input = new Object[]{"aBc9x", 2, 3};
        Object retrieved = StringFunctions.SUBSTRING.getValue(input);
        Assert.assertEquals((Object)"Bc9", (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSubstringValueWrongSizeInput() {
        Object[] input = new Object[]{"AwdC", 1};
        StringFunctions.SUBSTRING.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSubstringValueWrongTypeInput() {
        Object[] input = new Object[]{"aBc9x", "2", 3};
        StringFunctions.SUBSTRING.getValue(input);
    }

    @Test
    public void getTrimBlanksValueCorrectInput() {
        Object[] input1 = new Object[]{" aBcas9x  "};
        Object retrieved = StringFunctions.TRIM_BLANKS.getValue(input1);
        Assert.assertEquals((Object)"aBcas9x", (Object)retrieved);
        Object[] input2 = new Object[]{" aB ca  s9x  "};
        retrieved = StringFunctions.TRIM_BLANKS.getValue(input2);
        Assert.assertEquals((Object)"aB ca  s9x", (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTrimBlanksValueWrongSizeInput() {
        Object[] input = new Object[]{"AwdC", 1};
        StringFunctions.TRIM_BLANKS.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTrimBlanksValueWrongTypeInput() {
        Object[] input = new Object[]{3};
        StringFunctions.TRIM_BLANKS.getValue(input);
    }

    @Test
    public void getConcatValueCorrectInput() {
        Object[] input1 = new Object[]{" aBc", "as9x  "};
        Object retrieved = StringFunctions.CONCAT.getValue(input1);
        Assert.assertEquals((Object)" aBcas9x  ", (Object)retrieved);
        Object[] input2 = new Object[]{" aB ", "ca  s9x"};
        retrieved = StringFunctions.CONCAT.getValue(input2);
        Assert.assertEquals((Object)" aB ca  s9x", (Object)retrieved);
        Object[] input3 = new Object[]{2, "-", 2000};
        retrieved = StringFunctions.CONCAT.getValue(input3);
        Assert.assertEquals((Object)"2-2000", (Object)retrieved);
        Object[] input4 = new Object[]{2, null, 2000};
        retrieved = StringFunctions.CONCAT.getValue(input4);
        Assert.assertEquals((Object)"2null2000", (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getConcatValueWrongSizeInput() {
        Object[] input = new Object[]{"BBBB"};
        StringFunctions.CONCAT.getValue(input);
    }

    @Test
    public void getReplaceValueCorrectInput() {
        Object[] input = new Object[]{"BBBB", "B+", "c"};
        Object retrieved = StringFunctions.REPLACE.getValue(input);
        Assert.assertEquals((Object)"c", (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getReplaceValueWrongSizeInput() {
        Object[] input = new Object[]{"BBBB", "B+"};
        StringFunctions.REPLACE.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getReplaceValueWrongTypeInput() {
        Object[] input = new Object[]{"BBBB", "B+", 3};
        StringFunctions.REPLACE.getValue(input);
    }

    @Test
    public void getMatchesValueCorrectInput() {
        Object[] input1 = new Object[]{"BBBB", "B+"};
        Assert.assertTrue((boolean)((Boolean)StringFunctions.MATCHES.getValue(input1)));
        Object[] input2 = new Object[]{"BBBB", "."};
        Assert.assertTrue((boolean)((Boolean)StringFunctions.MATCHES.getValue(input2)));
        Object[] input3 = new Object[]{"aBcDDeFF", "DeF"};
        Assert.assertTrue((boolean)((Boolean)StringFunctions.MATCHES.getValue(input3)));
        Object[] input4 = new Object[]{"BBBB", "\\d"};
        Assert.assertFalse((boolean)((Boolean)StringFunctions.MATCHES.getValue(input4)));
        Object[] input5 = new Object[]{"aBcDDeFF", "dell"};
        Assert.assertFalse((boolean)((Boolean)StringFunctions.MATCHES.getValue(input5)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getMatchesValueWrongSizeInput() {
        Object[] input = new Object[]{"BBBB", "B+", "c"};
        StringFunctions.MATCHES.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getMatchesValueWrongTypeInput() {
        Object[] input = new Object[]{"BBBB", 3};
        StringFunctions.MATCHES.getValue(input);
    }

    @Test
    public void getFormatNumberValueCorrectInput() {
        Object[] input1 = new Object[]{2, "%3d"};
        Object retrieved = StringFunctions.FORMAT_NUMBER.getValue(input1);
        Assert.assertEquals((Object)"  2", (Object)retrieved);
        Object[] input2 = new Object[]{4.2352989244, "%.2f"};
        retrieved = StringFunctions.FORMAT_NUMBER.getValue(input2);
        Assert.assertEquals((Object)"4.24", (Object)retrieved);
        Object[] input3 = new Object[]{4.2352989244, "%.3f"};
        retrieved = StringFunctions.FORMAT_NUMBER.getValue(input3);
        Assert.assertEquals((Object)"4.235", (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFormatNumberValueWrongSizeInput() {
        Object[] input = new Object[]{3, "B+", "c"};
        StringFunctions.FORMAT_NUMBER.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFormatNumberValueWrongTypeInput() {
        Object[] input = new Object[]{"BBBB", 3};
        StringFunctions.FORMAT_NUMBER.getValue(input);
    }

    @Test
    public void getFormatDatetimeValueCorrectInput() {
        Date inputDate = new GregorianCalendar(2004, 7, 20).getTime();
        Object[] input1 = new Object[]{inputDate, "%m/%d/%y"};
        Object retrieved = StringFunctions.FORMAT_DATE_TIME.getValue(input1);
        Assert.assertEquals((Object)"08/20/04", (Object)retrieved);
        Object[] input2 = new Object[]{inputDate, "%B/%d/%y"};
        retrieved = StringFunctions.FORMAT_DATE_TIME.getValue(input2);
        String month = String.format("%1$tB", inputDate);
        String expected = String.format("%s/20/04", month);
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFormatDatetimeValueWrongSizeInput() {
        Object[] input = new Object[]{3, "B+", "c"};
        StringFunctions.FORMAT_DATE_TIME.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFormatDatetimeValueWrongTypeInput() {
        Object[] input = new Object[]{"BBBB", 3};
        StringFunctions.FORMAT_DATE_TIME.getValue(input);
    }

    static {
        supportedStringFunctions.add(StringFunctions.LOWERCASE);
        supportedStringFunctions.add(StringFunctions.UPPERCASE);
        supportedStringFunctions.add(StringFunctions.STRING_LENGTH);
        supportedStringFunctions.add(StringFunctions.SUBSTRING);
        supportedStringFunctions.add(StringFunctions.TRIM_BLANKS);
        supportedStringFunctions.add(StringFunctions.CONCAT);
        supportedStringFunctions.add(StringFunctions.REPLACE);
        supportedStringFunctions.add(StringFunctions.MATCHES);
        supportedStringFunctions.add(StringFunctions.FORMAT_NUMBER);
        supportedStringFunctions.add(StringFunctions.FORMAT_DATE_TIME);
        unsupportedStringFunctions = new ArrayList<StringFunctions>();
    }
}

