/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.builtinfunctions.DistributionFunctions;

public class DistributionFunctionsTest {
    public static final List<DistributionFunctions> supportedDistributionFunctions = new ArrayList<DistributionFunctions>();
    public static final List<DistributionFunctions> unsupportedDistributionFunctions;

    @Test
    void getNormalCDFValueCorrectInput() {
        Object[] input1 = new Object[]{24.11, 24.54, 1.23};
        Object retrieved = DistributionFunctions.NORMAL_CDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.363, Offset.offset((Number)0.001));
        Object[] input2 = new Object[]{9.12, 11.35, 3.78};
        retrieved = DistributionFunctions.NORMAL_CDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.278, Offset.offset((Number)0.001));
    }

    @Test
    void getNormalCDFValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            DistributionFunctions.NORMAL_CDF.getValue(input);
        });
    }

    @Test
    void getNormalCDFValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 25.3, "22.1"};
            DistributionFunctions.NORMAL_CDF.getValue(input);
        });
    }

    @Test
    void getNormalPDFValueCorrectInput() {
        Object[] input1 = new Object[]{2, 7, 2};
        Object retrieved = DistributionFunctions.NORMAL_PDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.00876, Offset.offset((Number)0.001));
        Object[] input2 = new Object[]{9.12, 11.35, 3.78};
        retrieved = DistributionFunctions.NORMAL_PDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.08868, Offset.offset((Number)0.001));
    }

    @Test
    void getNormalPDFValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            DistributionFunctions.NORMAL_PDF.getValue(input);
        });
    }

    @Test
    void getNormalPDFValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 25.3, "22.1"};
            DistributionFunctions.NORMAL_PDF.getValue(input);
        });
    }

    @Test
    void getStdNormalCDFValueCorrectInput() {
        Object[] input1 = new Object[]{2};
        Object retrieved = DistributionFunctions.STD_NORMAL_CDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.97725, Offset.offset((Number)0.001));
        Object[] input2 = new Object[]{1.243};
        retrieved = DistributionFunctions.STD_NORMAL_CDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.89307, Offset.offset((Number)0.001));
    }

    @Test
    void getStdNormalCDFValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 312, 11};
            DistributionFunctions.STD_NORMAL_CDF.getValue(input);
        });
    }

    @Test
    void getStdNormalCDFValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"34"};
            DistributionFunctions.STD_NORMAL_CDF.getValue(input);
        });
    }

    @Test
    void getStdNormalPDFValueCorrectInput() {
        Object[] input1 = new Object[]{2};
        Object retrieved = DistributionFunctions.STD_NORMAL_PDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.05399, Offset.offset((Number)0.001));
        Object[] input2 = new Object[]{1.243};
        retrieved = DistributionFunctions.STD_NORMAL_PDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.18425, Offset.offset((Number)0.001));
    }

    @Test
    void getStdNormalPDFValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 312, 11};
            DistributionFunctions.STD_NORMAL_PDF.getValue(input);
        });
    }

    @Test
    void getStdNormalPDFValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"34"};
            DistributionFunctions.STD_NORMAL_PDF.getValue(input);
        });
    }

    @Test
    void getErfValueCorrectInput() {
        Object[] input1 = new Object[]{2};
        Object retrieved = DistributionFunctions.ERF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.9953223, Offset.offset((Number)0.001));
        Object[] input2 = new Object[]{1.243};
        retrieved = DistributionFunctions.ERF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.92123, Offset.offset((Number)0.001));
    }

    @Test
    void getErfValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 312, 11};
            DistributionFunctions.ERF.getValue(input);
        });
    }

    @Test
    void getErfValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"34"};
            DistributionFunctions.ERF.getValue(input);
        });
    }

    @Test
    void getNormalIDFValueCorrectInput() {
        Object[] input1 = new Object[]{0.75, 1.23, 0.2};
        Object retrieved = DistributionFunctions.NORMAL_IDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(1.36, Offset.offset((Number)0.01));
        Object[] input2 = new Object[]{0.912, 11.35, 3.78};
        retrieved = DistributionFunctions.NORMAL_IDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(16.46, Offset.offset((Number)0.01));
    }

    @Test
    void getNormalIDFValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            DistributionFunctions.NORMAL_IDF.getValue(input);
        });
    }

    @Test
    void getNormalIDFValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 25.3, "22.1"};
            DistributionFunctions.NORMAL_IDF.getValue(input);
        });
    }

    @Test
    void getStdNormalIDFValueCorrectInput() {
        Object[] input1 = new Object[]{0.75};
        Object retrieved = DistributionFunctions.STD_NORMAL_IDF.getValue(input1);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.67, Offset.offset((Number)0.01));
        Object[] input2 = new Object[]{0.912};
        retrieved = DistributionFunctions.STD_NORMAL_IDF.getValue(input2);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(1.35, Offset.offset((Number)0.01));
    }

    @Test
    void getStdNormalIDFValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 312, 11};
            DistributionFunctions.STD_NORMAL_IDF.getValue(input);
        });
    }

    @Test
    void getStdNormalIDFValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"34"};
            DistributionFunctions.STD_NORMAL_IDF.getValue(input);
        });
    }

    static {
        supportedDistributionFunctions.add(DistributionFunctions.NORMAL_CDF);
        supportedDistributionFunctions.add(DistributionFunctions.NORMAL_PDF);
        supportedDistributionFunctions.add(DistributionFunctions.STD_NORMAL_CDF);
        supportedDistributionFunctions.add(DistributionFunctions.STD_NORMAL_PDF);
        supportedDistributionFunctions.add(DistributionFunctions.ERF);
        supportedDistributionFunctions.add(DistributionFunctions.NORMAL_IDF);
        supportedDistributionFunctions.add(DistributionFunctions.STD_NORMAL_IDF);
        unsupportedDistributionFunctions = new ArrayList<DistributionFunctions>();
    }
}

