/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.identifiers;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.identifiers.LocalId;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.pmml.api.identifiers.LocalComponentIdPmml;

class LocalComponentIdPmmlTest {
    private static final String fileName = "fileName";
    private static final String name = "name";

    LocalComponentIdPmmlTest() {
    }

    @Test
    void equals() {
        LocalComponentIdPmml original = new LocalComponentIdPmml(fileName, name);
        LocalComponentIdPmml compare = new LocalComponentIdPmml(fileName, name);
        Assertions.assertThat((boolean)original.equals((Object)compare)).isTrue();
        String path = original.fullPath();
        LocalUri parsed = LocalUri.parse((String)path);
        compare = new ModelLocalUriId(parsed);
        Assertions.assertThat((boolean)original.equals((Object)compare)).isTrue();
    }

    @Test
    void prefix() {
        String retrieved = new LocalComponentIdPmml(fileName, name).asLocalUri().toUri().getPath();
        String expected = "/pmml/";
        Assertions.assertThat((String)retrieved).startsWith((CharSequence)expected);
    }

    @Test
    void getFileName() {
        LocalComponentIdPmml retrieved = new LocalComponentIdPmml(fileName, name);
        Assertions.assertThat((String)retrieved.getFileName()).isEqualTo(fileName);
    }

    @Test
    void name() {
        LocalComponentIdPmml retrieved = new LocalComponentIdPmml(fileName, name);
        Assertions.assertThat((String)retrieved.name()).isEqualTo(name);
    }

    @Test
    void toLocalId() {
        LocalComponentIdPmml LocalComponentIdPmml2 = new LocalComponentIdPmml(fileName, name);
        LocalId retrieved = LocalComponentIdPmml2.toLocalId();
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)LocalComponentIdPmml2);
    }
}

