/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.builtinfunctions.ArithmeticFunctions;

public class ArithmeticFunctionsTest {
    public static final List<ArithmeticFunctions> supportedArithmeticFunctions = new ArrayList<ArithmeticFunctions>();
    public static final List<ArithmeticFunctions> unsupportedArithmeticFunctions;

    @Test
    void getAvgValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = ArithmeticFunctions.AVG.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)103.8);
        Object[] input2 = new Object[]{35, 12, -347, 2, 123};
        retrieved = ArithmeticFunctions.AVG.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)-35.0);
    }

    @Test
    void getAvgValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 34};
            ArithmeticFunctions.AVG.getValue(input);
        });
    }

    @Test
    void getDivisionValueCorrectInput() {
        Object[] input = new Object[]{35, 5};
        Object retrieved = ArithmeticFunctions.DIVISION.getValue(input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)7.0);
    }

    @Test
    void getDivisionValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{35};
            ArithmeticFunctions.DIVISION.getValue(input);
        });
    }

    @Test
    void getDivisionValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 34};
            ArithmeticFunctions.DIVISION.getValue(input);
        });
    }

    @Test
    void getMaxValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = ArithmeticFunctions.MAX.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)347.0);
        Object[] input2 = new Object[]{35, 12, -347, 2, 123};
        retrieved = ArithmeticFunctions.MAX.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)123.0);
    }

    @Test
    void getMaxValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 34};
            ArithmeticFunctions.MAX.getValue(input);
        });
    }

    @Test
    void getMedianValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = ArithmeticFunctions.MEDIAN.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)35.0);
        Object[] input2 = new Object[]{35, 12, 2, 123};
        retrieved = ArithmeticFunctions.MEDIAN.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)23.5);
    }

    @Test
    void getMedianValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 34};
            ArithmeticFunctions.MEDIAN.getValue(input);
        });
    }

    @Test
    void getMinValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = ArithmeticFunctions.MIN.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)2.0);
        Object[] input2 = new Object[]{35, 12, -347, 2, 123};
        retrieved = ArithmeticFunctions.MIN.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)-347.0);
    }

    @Test
    void getMinValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 34};
            ArithmeticFunctions.MIN.getValue(input);
        });
    }

    @Test
    void getMinusValueCorrectInput() {
        Object[] input = new Object[]{35, 12};
        Object retrieved = ArithmeticFunctions.MINUS.getValue(input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)23.0);
    }

    @Test
    void getMinusValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{35};
            ArithmeticFunctions.MINUS.getValue(input);
        });
    }

    @Test
    void getMinusValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 34};
            ArithmeticFunctions.MINUS.getValue(input);
        });
    }

    @Test
    void getMultiValueCorrectInput() {
        Object[] input = new Object[]{7, 5};
        Object retrieved = ArithmeticFunctions.MULTI.getValue(input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)35.0);
    }

    @Test
    void getMultiValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{35};
            ArithmeticFunctions.MULTI.getValue(input);
        });
    }

    @Test
    void getMultiValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 34};
            ArithmeticFunctions.MULTI.getValue(input);
        });
    }

    @Test
    void getPlusValueCorrectInput() {
        Object[] input = new Object[]{35, 12};
        Object retrieved = ArithmeticFunctions.PLUS.getValue(input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)47.0);
    }

    @Test
    void getPlusValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{35};
            ArithmeticFunctions.PLUS.getValue(input);
        });
    }

    @Test
    void getPlusValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 34};
            ArithmeticFunctions.PLUS.getValue(input);
        });
    }

    @Test
    void getProductValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = ArithmeticFunctions.PRODUCT.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)3.585204E7);
        Object[] input2 = new Object[]{35, 12, -2, 123};
        retrieved = ArithmeticFunctions.PRODUCT.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)-103320.0);
    }

    @Test
    void getProductValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 34};
            ArithmeticFunctions.PRODUCT.getValue(input);
        });
    }

    @Test
    void getSumValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = ArithmeticFunctions.SUM.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)519.0);
        Object[] input2 = new Object[]{35, 12, -347, 2, 123};
        retrieved = ArithmeticFunctions.SUM.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)-175.0);
    }

    @Test
    void getSumValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 34};
            ArithmeticFunctions.SUM.getValue(input);
        });
    }

    @Test
    void getLog10ValueCorrectInput() {
        Object[] input = new Object[]{35};
        Object retrieved = ArithmeticFunctions.LOG10.getValue(input);
        Assertions.assertThat((double)((Double)retrieved)).isCloseTo(1.5440680443503, Offset.offset((Number)1.0E-8));
    }

    @Test
    void getLog10ValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A"};
            ArithmeticFunctions.LOG10.getValue(input);
        });
    }

    @Test
    void getLnValueCorrectInput() {
        Object[] input = new Object[]{35};
        Object retrieved = ArithmeticFunctions.LN.getValue(input);
        Assertions.assertThat((double)((Double)retrieved)).isCloseTo(3.5553480614894, Offset.offset((Number)1.0E-8));
    }

    @Test
    void getLnValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A"};
            ArithmeticFunctions.LN.getValue(input);
        });
    }

    @Test
    void getSqrtValueCorrectInput() {
        Object[] input = new Object[]{81};
        Object retrieved = ArithmeticFunctions.SQRT.getValue(input);
        Assertions.assertThat((double)((Double)retrieved)).isCloseTo(9.0, Offset.offset((Number)1.0E-8));
    }

    @Test
    void getSqrtValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A"};
            ArithmeticFunctions.SQRT.getValue(input);
        });
    }

    @Test
    void getAbsValueCorrectInput() {
        Object[] input = new Object[]{-3.5553480614894};
        Object retrieved = ArithmeticFunctions.ABS.getValue(input);
        Assertions.assertThat((double)((Double)retrieved)).isCloseTo(3.5553480614894, Offset.offset((Number)1.0E-8));
    }

    @Test
    void getAbsValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A"};
            ArithmeticFunctions.ABS.getValue(input);
        });
    }

    @Test
    void getExpValueCorrectInput() {
        Object[] input = new Object[]{-3.5553480614894};
        Object retrieved = ArithmeticFunctions.EXP.getValue(input);
        Assertions.assertThat((double)((Double)retrieved)).isCloseTo(0.0285714285714, Offset.offset((Number)1.0E-8));
    }

    @Test
    void getExpValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A"};
            ArithmeticFunctions.EXP.getValue(input);
        });
    }

    @Test
    void getPowValueCorrectInput() {
        Object[] input = new Object[]{3, 4};
        Object retrieved = ArithmeticFunctions.POW.getValue(input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)81.0);
    }

    @Test
    void getPowValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 32};
            ArithmeticFunctions.POW.getValue(input);
        });
    }

    @Test
    void getThresholdValueCorrectInput() {
        Object[] input1 = new Object[]{5, 4};
        Object retrieved = ArithmeticFunctions.THRESHOLD.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)1.0);
        Object[] input2 = new Object[]{5, 5};
        retrieved = ArithmeticFunctions.THRESHOLD.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)0.0);
        Object[] input3 = new Object[]{4, 5};
        retrieved = ArithmeticFunctions.THRESHOLD.getValue(input3);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)0.0);
    }

    @Test
    void getThresholdValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 32};
            ArithmeticFunctions.THRESHOLD.getValue(input);
        });
    }

    @Test
    void getFloorValueCorrectInput() {
        Object[] input1 = new Object[]{-3.5553480614894};
        Object retrieved = ArithmeticFunctions.FLOOR.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)-4.0);
        Object[] input2 = new Object[]{3.5553480614894};
        retrieved = ArithmeticFunctions.FLOOR.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)3.0);
    }

    @Test
    void getFloorValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A"};
            ArithmeticFunctions.FLOOR.getValue(input);
        });
    }

    @Test
    void getCeilValueCorrectInput() {
        Object[] input1 = new Object[]{-3.5553480614894};
        Object retrieved = ArithmeticFunctions.CEIL.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)-3.0);
        Object[] input2 = new Object[]{3.5553480614894};
        retrieved = ArithmeticFunctions.CEIL.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)4.0);
    }

    @Test
    void getCeilValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A"};
            ArithmeticFunctions.CEIL.getValue(input);
        });
    }

    @Test
    void getRoundValueCorrectInput() {
        Object[] input1 = new Object[]{3.3553480614894};
        Object retrieved = ArithmeticFunctions.ROUND.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)3.0);
        Object[] input2 = new Object[]{3.5553480614894};
        retrieved = ArithmeticFunctions.ROUND.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)4.0);
    }

    @Test
    void getRoundValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A"};
            ArithmeticFunctions.ROUND.getValue(input);
        });
    }

    @Test
    void getModuloValueCorrectInput() {
        Object[] input = new Object[]{35, 8};
        Object retrieved = ArithmeticFunctions.MODULO.getValue(input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)3.0);
    }

    @Test
    void getModuloValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"A", 35};
            ArithmeticFunctions.MODULO.getValue(input);
        });
    }

    static {
        supportedArithmeticFunctions.add(ArithmeticFunctions.AVG);
        supportedArithmeticFunctions.add(ArithmeticFunctions.MAX);
        supportedArithmeticFunctions.add(ArithmeticFunctions.MEDIAN);
        supportedArithmeticFunctions.add(ArithmeticFunctions.MIN);
        supportedArithmeticFunctions.add(ArithmeticFunctions.MINUS);
        supportedArithmeticFunctions.add(ArithmeticFunctions.MULTI);
        supportedArithmeticFunctions.add(ArithmeticFunctions.DIVISION);
        supportedArithmeticFunctions.add(ArithmeticFunctions.PLUS);
        supportedArithmeticFunctions.add(ArithmeticFunctions.PRODUCT);
        supportedArithmeticFunctions.add(ArithmeticFunctions.SUM);
        supportedArithmeticFunctions.add(ArithmeticFunctions.LOG10);
        supportedArithmeticFunctions.add(ArithmeticFunctions.LN);
        supportedArithmeticFunctions.add(ArithmeticFunctions.SQRT);
        supportedArithmeticFunctions.add(ArithmeticFunctions.ABS);
        supportedArithmeticFunctions.add(ArithmeticFunctions.EXP);
        supportedArithmeticFunctions.add(ArithmeticFunctions.POW);
        supportedArithmeticFunctions.add(ArithmeticFunctions.THRESHOLD);
        supportedArithmeticFunctions.add(ArithmeticFunctions.FLOOR);
        supportedArithmeticFunctions.add(ArithmeticFunctions.CEIL);
        supportedArithmeticFunctions.add(ArithmeticFunctions.ROUND);
        supportedArithmeticFunctions.add(ArithmeticFunctions.MODULO);
        unsupportedArithmeticFunctions = new ArrayList<ArithmeticFunctions>();
    }
}

