/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.builtinfunctions.StringFunctions;

public class StringFunctionsTest {
    public static final List<StringFunctions> supportedStringFunctions = new ArrayList<StringFunctions>();
    public static final List<StringFunctions> unsupportedStringFunctions;

    @Test
    void getLowercaseValueCorrectInput() {
        Object[] input = new Object[]{"AwdC"};
        Object retrieved = StringFunctions.LOWERCASE.getValue(input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"awdc");
    }

    @Test
    void getLowercaseValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"AwdC", "AwdB"};
            StringFunctions.LOWERCASE.getValue(input);
        });
    }

    @Test
    void getLowercaseValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            StringFunctions.LOWERCASE.getValue(input);
        });
    }

    @Test
    void getUppercaseValueCorrectInput() {
        Object[] input = new Object[]{"AwdC"};
        Object retrieved = StringFunctions.UPPERCASE.getValue(input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"AWDC");
    }

    @Test
    void getUppercaseValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"AwdC", "AwdB"};
            StringFunctions.UPPERCASE.getValue(input);
        });
    }

    @Test
    void getUppercaseValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            StringFunctions.UPPERCASE.getValue(input);
        });
    }

    @Test
    void getStringLengthValueCorrectInput() {
        Object[] input = new Object[]{"AwdC"};
        Object retrieved = StringFunctions.STRING_LENGTH.getValue(input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)4);
    }

    @Test
    void getStringLengthValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"AwdC", "AwdB"};
            StringFunctions.STRING_LENGTH.getValue(input);
        });
    }

    @Test
    void getStringLengthValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            StringFunctions.STRING_LENGTH.getValue(input);
        });
    }

    @Test
    void getSubstringValueCorrectInput() {
        Object[] input = new Object[]{"aBc9x", 2, 3};
        Object retrieved = StringFunctions.SUBSTRING.getValue(input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"Bc9");
    }

    @Test
    void getSubstringValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"AwdC", 1};
            StringFunctions.SUBSTRING.getValue(input);
        });
    }

    @Test
    void getSubstringValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"aBc9x", "2", 3};
            StringFunctions.SUBSTRING.getValue(input);
        });
    }

    @Test
    void getTrimBlanksValueCorrectInput() {
        Object[] input1 = new Object[]{" aBcas9x  "};
        Object retrieved = StringFunctions.TRIM_BLANKS.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"aBcas9x");
        Object[] input2 = new Object[]{" aB ca  s9x  "};
        retrieved = StringFunctions.TRIM_BLANKS.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"aB ca  s9x");
    }

    @Test
    void getTrimBlanksValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"AwdC", 1};
            StringFunctions.TRIM_BLANKS.getValue(input);
        });
    }

    @Test
    void getTrimBlanksValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{3};
            StringFunctions.TRIM_BLANKS.getValue(input);
        });
    }

    @Test
    void getConcatValueCorrectInput() {
        Object[] input1 = new Object[]{" aBc", "as9x  "};
        Object retrieved = StringFunctions.CONCAT.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)" aBcas9x  ");
        Object[] input2 = new Object[]{" aB ", "ca  s9x"};
        retrieved = StringFunctions.CONCAT.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)" aB ca  s9x");
        Object[] input3 = new Object[]{2, "-", 2000};
        retrieved = StringFunctions.CONCAT.getValue(input3);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"2-2000");
        Object[] input4 = new Object[]{2, null, 2000};
        retrieved = StringFunctions.CONCAT.getValue(input4);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"2null2000");
    }

    @Test
    void getConcatValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"BBBB"};
            StringFunctions.CONCAT.getValue(input);
        });
    }

    @Test
    void getReplaceValueCorrectInput() {
        Object[] input = new Object[]{"BBBB", "B+", "c"};
        Object retrieved = StringFunctions.REPLACE.getValue(input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"c");
    }

    @Test
    void getReplaceValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"BBBB", "B+"};
            StringFunctions.REPLACE.getValue(input);
        });
    }

    @Test
    void getReplaceValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"BBBB", "B+", 3};
            StringFunctions.REPLACE.getValue(input);
        });
    }

    @Test
    void getMatchesValueCorrectInput() {
        Object[] input1 = new Object[]{"BBBB", "B+"};
        Assertions.assertThat((boolean)((Boolean)StringFunctions.MATCHES.getValue(input1))).isTrue();
        Object[] input2 = new Object[]{"BBBB", "."};
        Assertions.assertThat((boolean)((Boolean)StringFunctions.MATCHES.getValue(input2))).isTrue();
        Object[] input3 = new Object[]{"aBcDDeFF", "DeF"};
        Assertions.assertThat((boolean)((Boolean)StringFunctions.MATCHES.getValue(input3))).isTrue();
        Object[] input4 = new Object[]{"BBBB", "\\d"};
        Assertions.assertThat((boolean)((Boolean)StringFunctions.MATCHES.getValue(input4))).isFalse();
        Object[] input5 = new Object[]{"aBcDDeFF", "dell"};
        Assertions.assertThat((boolean)((Boolean)StringFunctions.MATCHES.getValue(input5))).isFalse();
    }

    @Test
    void getMatchesValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"BBBB", "B+", "c"};
            StringFunctions.MATCHES.getValue(input);
        });
    }

    @Test
    void getMatchesValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"BBBB", 3};
            StringFunctions.MATCHES.getValue(input);
        });
    }

    @Test
    void getFormatNumberValueCorrectInput() {
        Object[] input1 = new Object[]{2, "%3d"};
        Object retrieved = StringFunctions.FORMAT_NUMBER.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"  2");
        Object[] input2 = new Object[]{4.2352989244, "%.2f"};
        retrieved = StringFunctions.FORMAT_NUMBER.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"4.24");
        Object[] input3 = new Object[]{4.2352989244, "%.3f"};
        retrieved = StringFunctions.FORMAT_NUMBER.getValue(input3);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"4.235");
    }

    @Test
    void getFormatNumberValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{3, "B+", "c"};
            StringFunctions.FORMAT_NUMBER.getValue(input);
        });
    }

    @Test
    void getFormatNumberValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"BBBB", 3};
            StringFunctions.FORMAT_NUMBER.getValue(input);
        });
    }

    @Test
    void getFormatDatetimeValueCorrectInput() {
        Date inputDate = new GregorianCalendar(2004, 7, 20).getTime();
        Object[] input1 = new Object[]{inputDate, "%m/%d/%y"};
        Object retrieved = StringFunctions.FORMAT_DATE_TIME.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"08/20/04");
        Object[] input2 = new Object[]{inputDate, "%B/%d/%y"};
        retrieved = StringFunctions.FORMAT_DATE_TIME.getValue(input2);
        String month = String.format("%1$tB", inputDate);
        String expected = String.format("%s/20/04", month);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    @Test
    void getFormatDatetimeValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{3, "B+", "c"};
            StringFunctions.FORMAT_DATE_TIME.getValue(input);
        });
    }

    @Test
    void getFormatDatetimeValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"BBBB", 3};
            StringFunctions.FORMAT_DATE_TIME.getValue(input);
        });
    }

    static {
        supportedStringFunctions.add(StringFunctions.LOWERCASE);
        supportedStringFunctions.add(StringFunctions.UPPERCASE);
        supportedStringFunctions.add(StringFunctions.STRING_LENGTH);
        supportedStringFunctions.add(StringFunctions.SUBSTRING);
        supportedStringFunctions.add(StringFunctions.TRIM_BLANKS);
        supportedStringFunctions.add(StringFunctions.CONCAT);
        supportedStringFunctions.add(StringFunctions.REPLACE);
        supportedStringFunctions.add(StringFunctions.MATCHES);
        supportedStringFunctions.add(StringFunctions.FORMAT_NUMBER);
        supportedStringFunctions.add(StringFunctions.FORMAT_DATE_TIME);
        unsupportedStringFunctions = new ArrayList<StringFunctions>();
    }
}

