/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.identifiers;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.identifiers.LocalId;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.pmml.api.identifiers.LocalComponentIdRedirectPmml;

class LocalComponentIdRedirectPmmlTest {
    private static final String redirectModel = "redirectModel";
    private static final String fileName = "fileName";
    private static final String name = "name";

    LocalComponentIdRedirectPmmlTest() {
    }

    @Test
    void equals() {
        LocalComponentIdRedirectPmml original = new LocalComponentIdRedirectPmml(redirectModel, fileName, name);
        LocalComponentIdRedirectPmml compare = new LocalComponentIdRedirectPmml(redirectModel, fileName, name);
        Assertions.assertThat((boolean)original.equals((Object)compare)).isTrue();
        String path = original.fullPath();
        LocalUri parsed = LocalUri.parse((String)path);
        compare = new ModelLocalUriId(parsed);
        Assertions.assertThat((boolean)original.equals((Object)compare)).isTrue();
    }

    @Test
    void prefix() {
        String retrieved = new LocalComponentIdRedirectPmml(redirectModel, fileName, name).asLocalUri().toUri().getPath();
        String expected = "/redirectModel/";
        Assertions.assertThat((String)retrieved).startsWith((CharSequence)expected);
    }

    @Test
    void getRedirectModel() {
        LocalComponentIdRedirectPmml retrieved = new LocalComponentIdRedirectPmml(redirectModel, fileName, name);
        Assertions.assertThat((String)retrieved.getRedirectModel()).isEqualTo(redirectModel);
    }

    @Test
    void getFileName() {
        LocalComponentIdRedirectPmml retrieved = new LocalComponentIdRedirectPmml(redirectModel, fileName, name);
        Assertions.assertThat((String)retrieved.getFileName()).isEqualTo(fileName);
    }

    @Test
    void name() {
        LocalComponentIdRedirectPmml retrieved = new LocalComponentIdRedirectPmml(redirectModel, fileName, name);
        Assertions.assertThat((String)retrieved.name()).isEqualTo(name);
    }

    @Test
    void toLocalId() {
        LocalComponentIdRedirectPmml LocalComponentIdRedirectPmml2 = new LocalComponentIdRedirectPmml(redirectModel, fileName, name);
        LocalId retrieved = LocalComponentIdRedirectPmml2.toLocalId();
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)LocalComponentIdRedirectPmml2);
    }
}

