/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.utils;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.utils.PrimitiveBoxedUtils;

public class PrimitiveBoxedUtilsTest {
    private static final Class<?>[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Double.TYPE};
    private static final Class<?>[] boxeds = new Class[]{Boolean.class, Byte.class, Character.class, Float.class, Integer.class, Long.class, Short.class, Double.class};
    private static final int types = primitives.length;

    @Test
    void areSameWithBoxing() {
        int i;
        for (i = 0; i < types; ++i) {
            Assertions.assertThat((boolean)PrimitiveBoxedUtils.areSameWithBoxing(primitives[i], boxeds[i])).isTrue();
            Assertions.assertThat((boolean)PrimitiveBoxedUtils.areSameWithBoxing(boxeds[i], primitives[i])).isTrue();
            Assertions.assertThat((boolean)PrimitiveBoxedUtils.areSameWithBoxing(primitives[i], primitives[i])).isTrue();
            Assertions.assertThat((boolean)PrimitiveBoxedUtils.areSameWithBoxing(boxeds[i], boxeds[i])).isTrue();
        }
        for (i = 0; i < types; ++i) {
            Assertions.assertThat((boolean)PrimitiveBoxedUtils.areSameWithBoxing(primitives[i], boxeds[types - 1 - i])).isFalse();
            Assertions.assertThat((boolean)PrimitiveBoxedUtils.areSameWithBoxing(boxeds[i], primitives[types - 1 - i])).isFalse();
        }
        Assertions.assertThat((boolean)PrimitiveBoxedUtils.areSameWithBoxing(String.class, String.class)).isFalse();
        Assertions.assertThat((boolean)PrimitiveBoxedUtils.areSameWithBoxing(Double.TYPE, String.class)).isFalse();
        Assertions.assertThat((boolean)PrimitiveBoxedUtils.areSameWithBoxing(String.class, Double.class)).isFalse();
    }

    @Test
    void getKiePMMLPrimitiveBoxed() {
        for (int i = 0; i < types; ++i) {
            Assertions.assertThat((boolean)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(primitives[i]).isPresent()).isTrue();
            Assertions.assertThat((boolean)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(boxeds[i]).isPresent()).isTrue();
        }
        Assertions.assertThat((Optional)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(String.class)).isNotPresent();
    }

    @Test
    void isSameWithBoxing() {
        for (int i = 0; i < types; ++i) {
            Assertions.assertThat((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(primitives[i]).get()).isSameWithBoxing(boxeds[i])).isTrue();
            Assertions.assertThat((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(boxeds[i]).get()).isSameWithBoxing(primitives[i])).isTrue();
            Assertions.assertThat((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(primitives[i]).get()).isSameWithBoxing(primitives[i])).isTrue();
            Assertions.assertThat((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(boxeds[i]).get()).isSameWithBoxing(boxeds[i])).isTrue();
            Assertions.assertThat((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(primitives[i]).get()).isSameWithBoxing(String.class)).isFalse();
            Assertions.assertThat((boolean)((PrimitiveBoxedUtils.PrimitiveBoxed)PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(boxeds[i]).get()).isSameWithBoxing(String.class)).isFalse();
        }
    }
}

