/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.builtinfunctions.MathematicalFunctions;

public class MathematicalFunctionsTest {
    public static final List<MathematicalFunctions> supportedMathematicalFunctions = new ArrayList<MathematicalFunctions>();
    public static final List<MathematicalFunctions> unsupportedMathematicalFunctions;

    @Test
    void getExpm1ValueCorrectInput() {
        Object[] input = new Object[]{24.11};
        Object retrieved = MathematicalFunctions.EXPM1.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(2.956922613825104E10, Offset.offset((Number)1.0E-7));
    }

    @Test
    void getExpm1ValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 24.11};
            MathematicalFunctions.EXPM1.getValue(input);
        });
    }

    @Test
    void getExpm1ValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.EXPM1.getValue(input);
        });
    }

    @Test
    void getHypotValueCorrectInput() {
        Object[] input = new Object[]{24.11, 11};
        Object retrieved = MathematicalFunctions.HYPOT.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(26.5, Offset.offset((Number)0.001));
    }

    @Test
    void getHypotValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            MathematicalFunctions.HYPOT.getValue(input);
        });
    }

    @Test
    void getHypotValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1", 11};
            MathematicalFunctions.HYPOT.getValue(input);
        });
    }

    @Test
    void getLn1pValueCorrectInput() {
        Object[] input = new Object[]{24.11};
        Object retrieved = MathematicalFunctions.LN1P.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(3.223, Offset.offset((Number)0.001));
    }

    @Test
    void getLn1pValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 11};
            MathematicalFunctions.LN1P.getValue(input);
        });
    }

    @Test
    void getLn1pValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.LN1P.getValue(input);
        });
    }

    @Test
    void getRintValueCorrectInput() {
        Object[] input1 = new Object[]{24.11};
        Double retrieved = (Double)MathematicalFunctions.RINT.getValue(input1);
        Assertions.assertThat((Double)retrieved).isCloseTo(24.0, Offset.offset((Number)0.0));
        Object[] input2 = new Object[]{24.91};
        retrieved = (Double)MathematicalFunctions.RINT.getValue(input2);
        Assertions.assertThat((Double)retrieved).isCloseTo(25.0, Offset.offset((Number)0.0));
    }

    @Test
    void getRintValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 11};
            MathematicalFunctions.RINT.getValue(input);
        });
    }

    @Test
    void getRintValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.RINT.getValue(input);
        });
    }

    @Test
    void getSinValueCorrectInput() {
        Object[] input = new Object[]{24.11};
        Object retrieved = MathematicalFunctions.SIN.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(-0.8535, Offset.offset((Number)1.0E-4));
    }

    @Test
    void getSinValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 11};
            MathematicalFunctions.SIN.getValue(input);
        });
    }

    @Test
    void getSinValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.SIN.getValue(input);
        });
    }

    @Test
    void getAsinValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.ASIN.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(1.1944, Offset.offset((Number)1.0E-4));
    }

    @Test
    void getAsinValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 11};
            MathematicalFunctions.ASIN.getValue(input);
        });
    }

    @Test
    void getAsinValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.ASIN.getValue(input);
        });
    }

    @Test
    void getSinhValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.SINH.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(1.0699, Offset.offset((Number)1.0E-4));
    }

    @Test
    void getSinhValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 11};
            MathematicalFunctions.SINH.getValue(input);
        });
    }

    @Test
    void getSinhValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.SINH.getValue(input);
        });
    }

    @Test
    void getCosValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.COS.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.5978, Offset.offset((Number)1.0E-4));
    }

    @Test
    void getCosValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 11};
            MathematicalFunctions.COS.getValue(input);
        });
    }

    @Test
    void getCosValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.COS.getValue(input);
        });
    }

    @Test
    void getAcosValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.ACOS.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.3763, Offset.offset((Number)1.0E-4));
    }

    @Test
    void getAcosValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 11};
            MathematicalFunctions.ACOS.getValue(input);
        });
    }

    @Test
    void getAcosValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.ACOS.getValue(input);
        });
    }

    @Test
    void getCoshValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.COSH.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(1.4645, Offset.offset((Number)1.0E-4));
    }

    @Test
    void getCoshValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 11};
            MathematicalFunctions.COSH.getValue(input);
        });
    }

    @Test
    void getCoshValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.COSH.getValue(input);
        });
    }

    @Test
    void getTanValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.TAN.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(1.3408, Offset.offset((Number)1.0E-4));
    }

    @Test
    void getTanValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 11};
            MathematicalFunctions.TAN.getValue(input);
        });
    }

    @Test
    void getTanValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.TAN.getValue(input);
        });
    }

    @Test
    void getAtanValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.ATAN.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.7491, Offset.offset((Number)1.0E-4));
    }

    @Test
    void getAtanValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 11};
            MathematicalFunctions.ATAN.getValue(input);
        });
    }

    @Test
    void getAtanValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.ATAN.getValue(input);
        });
    }

    @Test
    void getTanhValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.TANH.getValue(input);
        Assertions.assertThat((Double)((Double)retrieved)).isCloseTo(0.7305, Offset.offset((Number)1.0E-4));
    }

    @Test
    void getTanhValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 11};
            MathematicalFunctions.TANH.getValue(input);
        });
    }

    @Test
    void getTanhValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"22.1"};
            MathematicalFunctions.TANH.getValue(input);
        });
    }

    static {
        supportedMathematicalFunctions.add(MathematicalFunctions.EXPM1);
        supportedMathematicalFunctions.add(MathematicalFunctions.HYPOT);
        supportedMathematicalFunctions.add(MathematicalFunctions.LN1P);
        supportedMathematicalFunctions.add(MathematicalFunctions.RINT);
        supportedMathematicalFunctions.add(MathematicalFunctions.SIN);
        supportedMathematicalFunctions.add(MathematicalFunctions.ASIN);
        supportedMathematicalFunctions.add(MathematicalFunctions.SINH);
        supportedMathematicalFunctions.add(MathematicalFunctions.COS);
        supportedMathematicalFunctions.add(MathematicalFunctions.ACOS);
        supportedMathematicalFunctions.add(MathematicalFunctions.COSH);
        supportedMathematicalFunctions.add(MathematicalFunctions.TAN);
        supportedMathematicalFunctions.add(MathematicalFunctions.ATAN);
        supportedMathematicalFunctions.add(MathematicalFunctions.TANH);
        unsupportedMathematicalFunctions = new ArrayList<MathematicalFunctions>();
    }
}

