/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.builtinfunctions.DateFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFunctionsTest {
    public static final List<DateFunctions> supportedDateFunctions;
    public static final List<DateFunctions> unsupportedDateFunctions;
    private static final Logger logger;

    @Test
    void getDateDaysSinceYearCorrectInput() {
        LocalDateTime inputDateLocalDateTime = LocalDateTime.of(1960, 1, 1, 0, 0, 0);
        logger.debug("inputDateLocalDateTime {}", (Object)inputDateLocalDateTime);
        Date inputDate = Date.from(inputDateLocalDateTime.atZone(ZoneId.systemDefault()).toInstant());
        logger.debug("Input date");
        logger.debug("{}", (Object)inputDate);
        logger.debug("{}", (Object)inputDate.getTime());
        Object[] input1 = new Object[]{inputDate, 1960};
        Object retrieved = DateFunctions.DATE_DAYS_SINCE_YEAR.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)0);
        inputDateLocalDateTime = LocalDateTime.of(2003, 4, 1, 0, 0, 0);
        logger.debug("inputDateLocalDateTime {}", (Object)inputDateLocalDateTime);
        inputDate = Date.from(inputDateLocalDateTime.atZone(ZoneId.systemDefault()).toInstant());
        logger.debug("Input date");
        logger.debug("{}", (Object)inputDate);
        logger.debug("{}", (Object)inputDate.getTime());
        Object[] input2 = new Object[]{inputDate, 1960};
        retrieved = DateFunctions.DATE_DAYS_SINCE_YEAR.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)15796);
    }

    @Test
    void getDateDaysSinceYearWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            DateFunctions.DATE_DAYS_SINCE_YEAR.getValue(input);
        });
    }

    @Test
    void getDateDaysSinceYearWrongTypeInput() {
        Object[] input1 = new Object[]{34, 1970};
        Date inputDate = new GregorianCalendar(2003, 3, 1).getTime();
        Object[] input2 = new Object[]{inputDate, "1970"};
        List<Object[]> inputs = Arrays.asList(input1, input2);
        for (Object[] input : inputs) {
            try {
                DateFunctions.DATE_DAYS_SINCE_YEAR.getValue(input);
                Assertions.fail((String)"Expecting IllegalArgumentException");
            }
            catch (Exception e) {
                Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
            }
        }
    }

    @Test
    void getDateSecondsSinceYearCorrectInput() {
        Date inputDate = new GregorianCalendar(1960, 0, 3, 3, 30, 3).getTime();
        Object[] input1 = new Object[]{inputDate, 1960};
        Object retrieved = DateFunctions.DATE_SECONDS_SINCE_YEAR.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)185403);
    }

    @Test
    void getDateSecondsSinceYearWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            DateFunctions.DATE_SECONDS_SINCE_YEAR.getValue(input);
        });
    }

    @Test
    void getDateSecondsSinceYearWrongTypeInput() {
        Object[] input1 = new Object[]{34, 1970};
        Date inputDate = new GregorianCalendar(2003, 3, 1).getTime();
        Object[] input2 = new Object[]{inputDate, "1970"};
        List<Object[]> inputs = Arrays.asList(input1, input2);
        for (Object[] input : inputs) {
            try {
                DateFunctions.DATE_SECONDS_SINCE_YEAR.getValue(input);
                Assertions.fail((String)"Expecting IllegalArgumentException");
            }
            catch (Exception e) {
                Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
            }
        }
    }

    @Test
    void getDateSecondsSinceMidnightCorrectInput() {
        Date inputDate = new GregorianCalendar(1960, 0, 2, 0, 0, 1).getTime();
        Object[] input1 = new Object[]{inputDate};
        Object retrieved = DateFunctions.DATE_SECONDS_SINCE_MIDNIGHT.getValue(input1);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)1);
        inputDate = new GregorianCalendar(1960, 2, 12, 0, 1, 0).getTime();
        Object[] input2 = new Object[]{inputDate};
        retrieved = DateFunctions.DATE_SECONDS_SINCE_MIDNIGHT.getValue(input2);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)60);
        inputDate = new GregorianCalendar(1960, 11, 23, 5, 23, 30).getTime();
        Object[] input3 = new Object[]{inputDate};
        retrieved = DateFunctions.DATE_SECONDS_SINCE_MIDNIGHT.getValue(input3);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)19410);
    }

    @Test
    void getDateSecondsSinceMidnightWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Date inputDate1 = new GregorianCalendar(2003, 3, 1).getTime();
            Date inputDate2 = new GregorianCalendar(2003, 3, 1).getTime();
            Object[] input = new Object[]{inputDate1, inputDate2};
            DateFunctions.DATE_SECONDS_SINCE_MIDNIGHT.getValue(input);
        });
    }

    @Test
    void getDateSecondsSinceMidnightWrongTypeInput() {
        Object[] input1 = new Object[]{34};
        Object[] input2 = new Object[]{"1970"};
        List<Object[]> inputs = Arrays.asList(input1, input2);
        for (Object[] input : inputs) {
            try {
                DateFunctions.DATE_SECONDS_SINCE_MIDNIGHT.getValue(input);
                Assertions.fail((String)"Expecting IllegalArgumentException");
            }
            catch (Exception e) {
                Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(DateFunctionsTest.class);
        supportedDateFunctions = new ArrayList<DateFunctions>();
        supportedDateFunctions.add(DateFunctions.DATE_DAYS_SINCE_YEAR);
        supportedDateFunctions.add(DateFunctions.DATE_SECONDS_SINCE_YEAR);
        supportedDateFunctions.add(DateFunctions.DATE_SECONDS_SINCE_MIDNIGHT);
        unsupportedDateFunctions = new ArrayList<DateFunctions>();
    }
}

