/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class PrimitiveBoxedUtils {
    private static final Set<PrimitiveBoxed> KIE_PMML_PRIMITIVE_BOXEDS = new HashSet<PrimitiveBoxed>(Arrays.asList(new PrimitiveBoxed(Boolean.TYPE, Boolean.class), new PrimitiveBoxed(Byte.TYPE, Byte.class), new PrimitiveBoxed(Character.TYPE, Character.class), new PrimitiveBoxed(Float.TYPE, Float.class), new PrimitiveBoxed(Integer.TYPE, Integer.class), new PrimitiveBoxed(Long.TYPE, Long.class), new PrimitiveBoxed(Short.TYPE, Short.class), new PrimitiveBoxed(Double.TYPE, Double.class)));

    public static Optional<PrimitiveBoxed> getKiePMMLPrimitiveBoxed(Class<?> c) {
        return KIE_PMML_PRIMITIVE_BOXEDS.stream().filter(pBoxed -> c.equals(pBoxed.getPrimitive()) || c.equals(pBoxed.getBoxed())).findFirst();
    }

    public static boolean areSameWithBoxing(Class<?> a, Class<?> b) {
        Optional<PrimitiveBoxed> pmmlPrimitiveBoxed = PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed(a);
        return pmmlPrimitiveBoxed.filter(kiePMMLPrimitiveBoxed -> a.equals(b) || kiePMMLPrimitiveBoxed.isSameWithBoxing(b)).isPresent();
    }

    public static class PrimitiveBoxed {
        private final Class<?> primitive;
        private final Class<?> boxed;

        public PrimitiveBoxed(Class<?> primitive, Class<?> boxed) {
            this.primitive = primitive;
            this.boxed = boxed;
        }

        public Class<?> getPrimitive() {
            return this.primitive;
        }

        public Class<?> getBoxed() {
            return this.boxed;
        }

        public boolean isSameWithBoxing(Class<?> c) {
            return c.equals(this.primitive) || c.equals(this.boxed);
        }
    }
}

