/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.enums;

import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.commons.model.enums.DATA_TYPE;

public class DATA_TYPETest {
    private static final Date NOW = new Date();
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private Map<DATA_TYPE, Object> unconvertedValues;
    private Map<DATA_TYPE, Object> convertedValues;

    @Before
    public void setup() {
        this.unconvertedValues = new HashMap<DATA_TYPE, Object>();
        this.unconvertedValues.put(DATA_TYPE.STRING, "_string_");
        this.unconvertedValues.put(DATA_TYPE.INTEGER, 32);
        this.unconvertedValues.put(DATA_TYPE.FLOAT, Float.valueOf(123.123f));
        this.unconvertedValues.put(DATA_TYPE.DOUBLE, 2342.23);
        this.unconvertedValues.put(DATA_TYPE.BOOLEAN, true);
        this.unconvertedValues.put(DATA_TYPE.DATE, NOW);
        this.unconvertedValues.put(DATA_TYPE.TIME, NOW);
        this.unconvertedValues.put(DATA_TYPE.DATE_TIME, NOW);
        this.unconvertedValues.put(DATA_TYPE.DATE_DAYS_SINCE_0, 23452352534634L);
        this.unconvertedValues.put(DATA_TYPE.DATE_DAYS_SINCE_1960, 23452352534634L);
        this.unconvertedValues.put(DATA_TYPE.DATE_DAYS_SINCE_1970, 23452352534634L);
        this.unconvertedValues.put(DATA_TYPE.DATE_DAYS_SINCE_1980, 23452352534634L);
        this.unconvertedValues.put(DATA_TYPE.TIME_SECONDS, 23452352534634L);
        this.unconvertedValues.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_0, 23452352534634L);
        this.unconvertedValues.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1960, 23452352534634L);
        this.unconvertedValues.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1970, 23452352534634L);
        this.unconvertedValues.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1980, 23452352534634L);
        this.convertedValues = new HashMap<DATA_TYPE, Object>();
        this.convertedValues.put(DATA_TYPE.INTEGER, "32");
        this.convertedValues.put(DATA_TYPE.FLOAT, "123.123");
        this.convertedValues.put(DATA_TYPE.DOUBLE, "2342.23");
        this.convertedValues.put(DATA_TYPE.BOOLEAN, "true");
        this.convertedValues.put(DATA_TYPE.DATE, NOW.toInstant().atZone(ZONE_ID).toLocalDate().toString());
        this.convertedValues.put(DATA_TYPE.TIME, NOW.toInstant().atZone(ZONE_ID).toLocalTime().toString());
        this.convertedValues.put(DATA_TYPE.DATE_TIME, NOW.toInstant().atZone(ZONE_ID).toLocalDateTime().toString());
        this.convertedValues.put(DATA_TYPE.DATE_DAYS_SINCE_0, "23452352534634");
        this.convertedValues.put(DATA_TYPE.DATE_DAYS_SINCE_1960, "23452352534634");
        this.convertedValues.put(DATA_TYPE.DATE_DAYS_SINCE_1970, "23452352534634");
        this.convertedValues.put(DATA_TYPE.DATE_DAYS_SINCE_1980, "23452352534634");
        this.convertedValues.put(DATA_TYPE.TIME_SECONDS, "23452352534634");
        this.convertedValues.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_0, "23452352534634");
        this.convertedValues.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1960, "23452352534634");
        this.convertedValues.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1970, "23452352534634");
        this.convertedValues.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1980, "23452352534634");
    }

    @Test
    public void getActualValue() {
        this.unconvertedValues.forEach((dataType, o) -> Assert.assertEquals((Object)o, (Object)dataType.getActualValue(o)));
        this.convertedValues.forEach((dataType, o) -> {
            switch (dataType) {
                case DATE: {
                    Assert.assertEquals((Object)((Date)this.unconvertedValues.get(dataType)).toInstant().atZone(ZONE_ID).toLocalDate(), (Object)dataType.getActualValue(o));
                    break;
                }
                case TIME: {
                    Assert.assertEquals((Object)((Date)this.unconvertedValues.get(dataType)).toInstant().atZone(ZONE_ID).toLocalTime(), (Object)dataType.getActualValue(o));
                    break;
                }
                case DATE_TIME: {
                    Assert.assertEquals((Object)((Date)this.unconvertedValues.get(dataType)).toInstant().atZone(ZONE_ID).toLocalDateTime(), (Object)dataType.getActualValue(o));
                    break;
                }
                default: {
                    Assert.assertEquals((Object)this.unconvertedValues.get(dataType), (Object)dataType.getActualValue(o));
                }
            }
        });
    }
}

