/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.OUTLIER_TREATMENT_METHOD;
import org.kie.pmml.commons.model.expressions.KiePMMLLinearNorm;
import org.kie.pmml.commons.model.expressions.KiePMMLNormContinuous;

public class KiePMMLNormContinuousTest {
    @Test
    public void sortLinearNorms() {
        KiePMMLLinearNorm ln0 = new KiePMMLLinearNorm("0", Collections.emptyList(), 34.0, 45.0);
        KiePMMLLinearNorm ln1 = new KiePMMLLinearNorm("1", Collections.emptyList(), 32.0, 5.0);
        KiePMMLLinearNorm ln2 = new KiePMMLLinearNorm("2", Collections.emptyList(), 33.0, 34.0);
        List<KiePMMLLinearNorm> linearNorms = Arrays.asList(ln0, ln1, ln2);
        Assert.assertEquals((Object)ln0, (Object)linearNorms.get(0));
        Assert.assertEquals((Object)ln1, (Object)linearNorms.get(1));
        Assert.assertEquals((Object)ln2, (Object)linearNorms.get(2));
        KiePMMLNormContinuous.sortLinearNorms(linearNorms);
        Assert.assertEquals((Object)ln1, (Object)linearNorms.get(0));
        Assert.assertEquals((Object)ln2, (Object)linearNorms.get(1));
        Assert.assertEquals((Object)ln0, (Object)linearNorms.get(2));
    }

    @Test
    public void evaluateWithExpectedValue() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, null, null);
        Integer input = 24;
        Number retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Double expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 28;
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 30;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 31;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 36;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 37;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 40;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    @Test
    public void evaluateWithOutlierValueAsIs() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_IS, null);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Double expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    @Test
    public void evaluateWithOutlierValueAsMissingValues() {
        Integer missingValue = 45;
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_MISSING_VALUES, missingValue);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Assert.assertEquals((Object)missingValue, (Object)retrieved);
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Assert.assertEquals((Object)missingValue, (Object)retrieved);
    }

    @Test
    public void evaluateWithOutlierValueAsExtremeValues() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_EXTREME_VALUES, null);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Assert.assertEquals((Object)((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm(), (Object)retrieved);
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Assert.assertEquals((Object)((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm(), (Object)retrieved);
    }

    @Test
    public void evaluateExpectedValue() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, null, null);
        Integer input = 24;
        Number retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        Double expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 28;
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 30;
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 31;
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 36;
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 37;
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 40;
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    @Test
    public void evaluateOutlierValueAsIs() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_IS, null);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        Double expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    @Test
    public void evaluateOutlierValueAsMissingValues() {
        Integer missingValue = 45;
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_MISSING_VALUES, missingValue);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        Assert.assertEquals((Object)missingValue, (Object)retrieved);
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        Assert.assertEquals((Object)missingValue, (Object)retrieved);
    }

    @Test
    public void evaluateOutlierValueAsExtremeValues() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_EXTREME_VALUES, null);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        Assert.assertEquals((Object)((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm(), (Object)retrieved);
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        Assert.assertEquals((Object)((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm(), (Object)retrieved);
    }

    @Test
    public void getLimitExpectedValue() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, null, null);
        Integer input = 24;
        KiePMMLLinearNorm[] retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(0), (Object)retrieved[0]);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(1), (Object)retrieved[1]);
        input = 28;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(0), (Object)retrieved[0]);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(1), (Object)retrieved[1]);
        input = 30;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(1), (Object)retrieved[0]);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(2), (Object)retrieved[1]);
        input = 31;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(1), (Object)retrieved[0]);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(2), (Object)retrieved[1]);
        input = 36;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(2), (Object)retrieved[0]);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(3), (Object)retrieved[1]);
        input = 37;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(2), (Object)retrieved[0]);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(3), (Object)retrieved[1]);
        input = 40;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(2), (Object)retrieved[0]);
        Assert.assertEquals(kiePMMLNormContinuous.linearNorms.get(3), (Object)retrieved[1]);
    }

    @Test
    public void evaluateInputAndLimitLinearNorms() {
        double startOrig = 2.1;
        double startNorm = 2.6;
        double endOrig = 7.4;
        double endNorm = 6.9;
        KiePMMLLinearNorm startLinearNorm = new KiePMMLLinearNorm("start", Collections.emptyList(), startOrig, startNorm);
        KiePMMLLinearNorm endLinearNorm = new KiePMMLLinearNorm("end", Collections.emptyList(), endOrig, endNorm);
        KiePMMLLinearNorm[] limitLinearNorms = new KiePMMLLinearNorm[]{startLinearNorm, endLinearNorm};
        Double input = 3.5;
        Number retrieved = KiePMMLNormContinuous.evaluate((Number)input, (KiePMMLLinearNorm[])limitLinearNorms);
        Assert.assertNotNull((Object)retrieved);
        Double expected = startNorm + (input - startOrig) / (endOrig - startOrig) * (endNorm - startNorm);
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    private KiePMMLNormContinuous getKiePMMLNormContinuous(String name, OUTLIER_TREATMENT_METHOD outlierTreatmentMethod, Number mapMissingTo) {
        KiePMMLLinearNorm ln0 = new KiePMMLLinearNorm("0", Collections.emptyList(), 24.0, 26.0);
        KiePMMLLinearNorm ln1 = new KiePMMLLinearNorm("1", Collections.emptyList(), 30.0, 32.0);
        KiePMMLLinearNorm ln2 = new KiePMMLLinearNorm("2", Collections.emptyList(), 36.0, 34.0);
        KiePMMLLinearNorm ln3 = new KiePMMLLinearNorm("3", Collections.emptyList(), 40.0, 39.0);
        List<KiePMMLLinearNorm> linearNorms = Arrays.asList(ln0, ln1, ln2, ln3);
        return new KiePMMLNormContinuous(null, Collections.emptyList(), linearNorms, outlierTreatmentMethod, mapMissingTo);
    }
}

