/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.commons.CommonTestingUtility;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;

public class KiePMMLFieldRefTest {
    private static final String FIELD_NAME = "FIELD_NAME";

    @Test
    public void evaluateFromKiePMMLNameValues() {
        Double value = 234.45;
        List<KiePMMLNameValue> kiePMMLNameValues = Collections.singletonList(new KiePMMLNameValue(FIELD_NAME, (Object)value));
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(FIELD_NAME, Collections.emptyList(), null);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), kiePMMLNameValues);
        Object retrieved = kiePMMLFieldRef.evaluate(processingDTO);
        Assert.assertEquals((Object)value, (Object)retrieved);
    }

    @Test
    public void evaluateFromDerivedFields() {
        Double value = 234.45;
        KiePMMLConstant kiePMMLConstant = new KiePMMLConstant("NAME", Collections.emptyList(), (Object)value);
        KiePMMLDerivedField kiePMMLDerivedField = (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)FIELD_NAME, Collections.emptyList(), (String)DATA_TYPE.DOUBLE.getName(), (String)OP_TYPE.CONTINUOUS.getName(), (KiePMMLExpression)kiePMMLConstant).build();
        List<KiePMMLDerivedField> derivedFields = Collections.singletonList(kiePMMLDerivedField);
        List<KiePMMLNameValue> kiePMMLNameValues = Collections.singletonList(new KiePMMLNameValue("UNKNOWN", (Object)"WRONG"));
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(FIELD_NAME, Collections.emptyList(), null);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(derivedFields, kiePMMLNameValues);
        Object retrieved = kiePMMLFieldRef.evaluate(processingDTO);
        Assert.assertEquals((Object)value, (Object)retrieved);
    }

    @Test
    public void evaluateFromMapMissingTo() {
        String value = "234.45";
        KiePMMLConstant kiePMMLConstant = new KiePMMLConstant("NAME", Collections.emptyList(), (Object)"WRONG-CONSTANT");
        KiePMMLDerivedField kiePMMLDerivedField = (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)"ANOTHER_FIELD", Collections.emptyList(), (String)DATA_TYPE.DOUBLE.getName(), (String)OP_TYPE.CONTINUOUS.getName(), (KiePMMLExpression)kiePMMLConstant).build();
        List<KiePMMLDerivedField> derivedFields = Collections.singletonList(kiePMMLDerivedField);
        List<KiePMMLNameValue> kiePMMLNameValues = Collections.singletonList(new KiePMMLNameValue("UNKNOWN", (Object)"WRONG"));
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(FIELD_NAME, Collections.emptyList(), "234.45");
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(derivedFields, kiePMMLNameValues);
        Object retrieved = kiePMMLFieldRef.evaluate(processingDTO);
        Assert.assertEquals((Object)"234.45", (Object)retrieved);
    }

    @Test
    public void evaluateNull() {
        KiePMMLConstant kiePMMLConstant = new KiePMMLConstant("NAME", Collections.emptyList(), (Object)"WRONG-CONSTANT");
        KiePMMLDerivedField kiePMMLDerivedField = (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)"ANOTHER_FIELD", Collections.emptyList(), (String)DATA_TYPE.DOUBLE.getName(), (String)OP_TYPE.CONTINUOUS.getName(), (KiePMMLExpression)kiePMMLConstant).build();
        List<KiePMMLDerivedField> derivedFields = Collections.singletonList(kiePMMLDerivedField);
        List<KiePMMLNameValue> kiePMMLNameValues = Collections.singletonList(new KiePMMLNameValue("UNKNOWN", (Object)"WRONG"));
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(FIELD_NAME, Collections.emptyList(), null);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(derivedFields, kiePMMLNameValues);
        Object retrieved = kiePMMLFieldRef.evaluate(processingDTO);
        Assert.assertNull((Object)retrieved);
    }
}

