/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.CLOSURE;
import org.kie.pmml.commons.model.KiePMMLMiningField;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;

public class KiePMMLMiningFieldTest {
    @Test
    public void isAllowedValueNoLimit() {
        KiePMMLMiningField kiePMMLMiningField = (KiePMMLMiningField)KiePMMLMiningField.builder((String)"NAME", Collections.emptyList()).build();
        Assert.assertTrue((boolean)kiePMMLMiningField.isMatching(null));
        Assert.assertTrue((boolean)kiePMMLMiningField.isMatching((Object)"VALUE"));
    }

    @Test
    public void isAllowedValueWithAllowedValues() {
        List<String> allowedValues = this.getCommonAllowedValues();
        KiePMMLMiningField kiePMMLMiningField = (KiePMMLMiningField)KiePMMLMiningField.builder((String)"NAME", Collections.emptyList()).withAllowedValues(allowedValues).build();
        Assert.assertFalse((boolean)kiePMMLMiningField.isMatching(null));
        Assert.assertFalse((boolean)kiePMMLMiningField.isMatching((Object)"VALUE"));
        allowedValues.forEach(allowedValue -> Assert.assertTrue((boolean)kiePMMLMiningField.isMatching(allowedValue)));
    }

    @Test
    public void isAllowedValueWithIntervals() {
        List<KiePMMLInterval> intervals = this.getCommonIntervals();
        KiePMMLMiningField kiePMMLMiningField = (KiePMMLMiningField)KiePMMLMiningField.builder((String)"NAME", Collections.emptyList()).withIntervals(intervals).build();
        Assert.assertFalse((boolean)kiePMMLMiningField.isMatching(null));
        Assert.assertFalse((boolean)kiePMMLMiningField.isMatching((Object)"VALUE"));
        intervals.forEach(interval -> {
            double delta = (interval.getRightMargin().doubleValue() - interval.getLeftMargin().doubleValue()) / 2.0;
            Double toVerify = interval.getLeftMargin().doubleValue() + delta;
            Assert.assertTrue((boolean)kiePMMLMiningField.isMatching((Object)toVerify));
        });
    }

    @Test
    public void isAllowedValueWithAllowedValuesAndIntervals() {
        List<String> allowedValues = this.getCommonAllowedValues();
        List<KiePMMLInterval> intervals = this.getCommonIntervals();
        KiePMMLMiningField kiePMMLMiningField = (KiePMMLMiningField)KiePMMLMiningField.builder((String)"NAME", Collections.emptyList()).withAllowedValues(allowedValues).withIntervals(intervals).build();
        Assert.assertFalse((boolean)kiePMMLMiningField.isMatching(null));
        Assert.assertFalse((boolean)kiePMMLMiningField.isMatching((Object)"VALUE"));
        allowedValues.forEach(allowedValue -> Assert.assertTrue((boolean)kiePMMLMiningField.isMatching(allowedValue)));
        intervals.forEach(interval -> {
            double delta = (interval.getRightMargin().doubleValue() - interval.getLeftMargin().doubleValue()) / 2.0;
            Double toVerify = interval.getLeftMargin().doubleValue() + delta;
            Assert.assertFalse((boolean)kiePMMLMiningField.isMatching((Object)toVerify));
        });
    }

    private List<String> getCommonAllowedValues() {
        return IntStream.range(0, 3).mapToObj(i -> "ALLOWED-" + i).collect(Collectors.toList());
    }

    private List<KiePMMLInterval> getCommonIntervals() {
        Random rnd = new Random();
        return IntStream.range(0, 3).mapToObj(i -> {
            int leftMargin = rnd.nextInt(10);
            int rightMargin = leftMargin + (rnd.nextInt(10) + 10);
            CLOSURE closure = CLOSURE.values()[rnd.nextInt(CLOSURE.values().length)];
            return new KiePMMLInterval((Number)leftMargin, (Number)rightMargin, closure);
        }).collect(Collectors.toList());
    }
}

