/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLInlineTable;
import org.kie.pmml.commons.model.expressions.KiePMMLRow;
import org.kie.pmml.commons.model.expressions.KiePMMLTextIndexNormalization;

public class KiePMMLTextIndexNormalizationTest {
    @Test
    public void replaceSingleRow() {
        HashMap<String, String> columnValues = new HashMap<String, String>();
        columnValues.put("string", "interfaces?");
        columnValues.put("stem", "foo");
        columnValues.put("regex", "true");
        KiePMMLRow row = new KiePMMLRow(columnValues);
        KiePMMLInlineTable inlineTable = new KiePMMLInlineTable("inlineTable", Collections.emptyList(), Collections.singletonList(row));
        KiePMMLTextIndexNormalization indexNormalization = (KiePMMLTextIndexNormalization)KiePMMLTextIndexNormalization.builder((String)"indexNormalization", Collections.emptyList()).withKiePMMLInlineTable(inlineTable).withIsCaseSensitive(Boolean.valueOf(false)).build();
        String text = "interfacea";
        String retrieved = indexNormalization.replace(text, true, 0, false, "\\s+");
        Assertions.assertThat((String)retrieved).isEqualTo("fooa");
        columnValues.put("string", "is|are|seem(ed|s?)|were?");
        columnValues.put("stem", "be");
        row = new KiePMMLRow(columnValues);
        inlineTable = new KiePMMLInlineTable("inlineTable", Collections.emptyList(), Collections.singletonList(row));
        indexNormalization = (KiePMMLTextIndexNormalization)KiePMMLTextIndexNormalization.builder((String)"indexNormalization", Collections.emptyList()).withKiePMMLInlineTable(inlineTable).withIsCaseSensitive(Boolean.valueOf(false)).build();
        text = "Why they seem so ?";
        retrieved = indexNormalization.replace(text, true, 0, false, "\\s+");
        Assertions.assertThat((String)retrieved).isEqualTo("Why they be so ?");
    }

    @Test
    public void replaceMultipleRows() {
        HashMap<String, String> columnValues1 = new HashMap<String, String>();
        columnValues1.put("string", "interfaces?");
        columnValues1.put("stem", "foo");
        columnValues1.put("regex", "true");
        KiePMMLRow row1 = new KiePMMLRow(columnValues1);
        HashMap<String, String> columnValues2 = new HashMap<String, String>();
        columnValues2.put("string", "is|are|seem(ed|s?)|were?");
        columnValues2.put("stem", "be");
        columnValues2.put("regex", "true");
        KiePMMLRow row2 = new KiePMMLRow(columnValues2);
        KiePMMLInlineTable inlineTable = new KiePMMLInlineTable("inlineTable", Collections.emptyList(), Arrays.asList(row1, row2));
        KiePMMLTextIndexNormalization indexNormalization = (KiePMMLTextIndexNormalization)KiePMMLTextIndexNormalization.builder((String)"indexNormalization", Collections.emptyList()).withKiePMMLInlineTable(inlineTable).withIsCaseSensitive(Boolean.valueOf(false)).build();
        String text = "Why the interfacea seem so ?";
        String retrieved = indexNormalization.replace(text, true, 0, false, "\\s+");
        Assertions.assertThat((String)retrieved).isEqualTo("Why the fooa be so ?");
    }

    @Test
    public void replaceMultipleRowsRecursive() {
        HashMap<String, String> columnValues0 = new HashMap<String, String>();
        columnValues0.put("string", "be");
        columnValues0.put("stem", "final");
        columnValues0.put("regex", "false");
        KiePMMLRow row0 = new KiePMMLRow(columnValues0);
        HashMap<String, String> columnValues1 = new HashMap<String, String>();
        columnValues1.put("string", "interfaces?");
        columnValues1.put("stem", "se");
        columnValues1.put("regex", "true");
        KiePMMLRow row1 = new KiePMMLRow(columnValues1);
        HashMap<String, String> columnValues2 = new HashMap<String, String>();
        columnValues2.put("string", "is|are|seem(ed|s?)|were?");
        columnValues2.put("stem", "be");
        columnValues2.put("regex", "true");
        KiePMMLRow row2 = new KiePMMLRow(columnValues2);
        KiePMMLInlineTable inlineTable = new KiePMMLInlineTable("inlineTable", Collections.emptyList(), Arrays.asList(row0, row1, row2));
        KiePMMLTextIndexNormalization indexNormalization = (KiePMMLTextIndexNormalization)KiePMMLTextIndexNormalization.builder((String)"indexNormalization", Collections.emptyList()).withKiePMMLInlineTable(inlineTable).withIsCaseSensitive(Boolean.valueOf(false)).withRecursive(true).build();
        String text = "Why they interfaceems so ?";
        String retrieved = indexNormalization.replace(text, true, 0, false, "\\s+");
        Assertions.assertThat((String)retrieved).isEqualTo("Why they final so ?");
    }
}

