/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.models.TargetField;
import org.kie.pmml.commons.model.KiePMMLTarget;

public class KiePMMLTargetTest {
    private static final String TARGET_NAME = "TARGET_NAME";

    @Test
    public void modifyPrediction() {
        Object object = "STRING";
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assert.assertEquals((Object)object, (Object)kiePMMLTarget.modifyPrediction(object));
        object = 4.33;
        Assert.assertEquals((Object)object, (Object)kiePMMLTarget.modifyPrediction(object));
        targetField = new TargetField(Collections.emptyList(), null, "string", null, (Number)4.34, null, null, null);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        object = "STRING";
        Assert.assertEquals((Object)object, (Object)kiePMMLTarget.modifyPrediction(object));
        object = 4.33;
        Assert.assertEquals((Object)4.34, (Object)kiePMMLTarget.modifyPrediction(object));
    }

    @Test
    public void applyMin() {
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assert.assertEquals((double)4.33, (double)kiePMMLTarget.applyMin(4.33), (double)0.0);
        targetField = new TargetField(Collections.emptyList(), null, "string", null, (Number)4.34, null, null, null);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assert.assertEquals((double)4.34, (double)kiePMMLTarget.applyMin(4.33), (double)0.0);
        Assert.assertEquals((double)4.35, (double)kiePMMLTarget.applyMin(4.35), (double)0.0);
    }

    @Test
    public void applyMax() {
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assert.assertEquals((double)4.33, (double)kiePMMLTarget.applyMax(4.33), (double)0.0);
        targetField = new TargetField(Collections.emptyList(), null, "string", null, null, (Number)4.34, null, null);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assert.assertEquals((double)4.33, (double)kiePMMLTarget.applyMax(4.33), (double)0.0);
        Assert.assertEquals((double)4.34, (double)kiePMMLTarget.applyMax(4.35), (double)0.0);
    }

    @Test
    public void applyRescaleFactor() {
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assert.assertEquals((double)4.0, (double)kiePMMLTarget.applyRescaleFactor(4.0), (double)0.0);
        targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, (Number)2.0);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assert.assertEquals((double)8.0, (double)kiePMMLTarget.applyRescaleFactor(4.0), (double)0.0);
    }

    @Test
    public void applyRescaleConstant() {
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assert.assertEquals((double)6.0, (double)kiePMMLTarget.applyRescaleConstant(6.0), (double)0.0);
        targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, (Number)2.0, null);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assert.assertEquals((double)8.0, (double)kiePMMLTarget.applyRescaleConstant(6.0), (double)0.0);
    }

    @Test
    public void applyCastInteger() {
        TargetField targetField = new TargetField(Collections.emptyList(), null, "string", null, null, null, null, null);
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assert.assertEquals((double)2.718, (double)((Double)kiePMMLTarget.applyCastInteger(2.718)), (double)0.0);
        targetField = new TargetField(Collections.emptyList(), null, "string", CAST_INTEGER.ROUND, null, null, null, null);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder(targetField).build();
        Assert.assertEquals((double)3.0, (double)((Double)kiePMMLTarget.applyCastInteger(2.718)), (double)0.0);
    }

    private KiePMMLTarget.Builder getBuilder(TargetField targetField) {
        return KiePMMLTarget.builder((String)TARGET_NAME, Collections.emptyList(), (TargetField)targetField);
    }
}

