/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.transformations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.commons.CommonTestingUtility;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;

public class KiePMMLDerivedFieldTest {
    private static final String CUSTOM_FIELD = "CUSTOM_FIELD";
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final Double value1 = 100.0;
    private static final Double value2 = 5.0;

    @Test
    void evaluateFromConstant() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant(PARAM_1, Collections.emptyList(), (Object)value1, null);
        KiePMMLDerivedField derivedField = (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)CUSTOM_FIELD, Collections.emptyList(), (DATA_TYPE)DATA_TYPE.DOUBLE, (OP_TYPE)OP_TYPE.CONTINUOUS, (KiePMMLExpression)kiePMMLConstant1).build();
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), new ArrayList<KiePMMLNameValue>());
        Object retrieved = derivedField.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)value1);
    }

    @Test
    void evaluateFromFieldRef() {
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLDerivedField derivedField = (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)CUSTOM_FIELD, Collections.emptyList(), (DATA_TYPE)DATA_TYPE.DOUBLE, (OP_TYPE)OP_TYPE.CONTINUOUS, (KiePMMLExpression)kiePMMLFieldRef).build();
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), Arrays.asList(new KiePMMLNameValue(PARAM_1, (Object)value1)));
        Object retrieved = derivedField.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)value1);
    }

    @Test
    void evaluateFromApplyWithKiePMMLNameValues() {
        KiePMMLFieldRef kiePMMLFieldRef1 = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLFieldRef kiePMMLFieldRef2 = new KiePMMLFieldRef(PARAM_2, Collections.emptyList(), null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLFieldRef1, kiePMMLFieldRef2)).build();
        KiePMMLDerivedField derivedField = (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)CUSTOM_FIELD, Collections.emptyList(), (DATA_TYPE)DATA_TYPE.DOUBLE, (OP_TYPE)OP_TYPE.CONTINUOUS, (KiePMMLExpression)kiePMMLApply).build();
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), this.getKiePMMLNameValues());
        Object retrieved = derivedField.evaluate(processingDTO);
        Double expected = value1 / value2;
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    @Test
    void evaluateFromApplyWithDerivedFields() {
        KiePMMLFieldRef kiePMMLFieldRef1 = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLFieldRef kiePMMLFieldRef2 = new KiePMMLFieldRef(PARAM_2, Collections.emptyList(), null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLFieldRef1, kiePMMLFieldRef2)).build();
        KiePMMLDerivedField derivedField = (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)CUSTOM_FIELD, Collections.emptyList(), (DATA_TYPE)DATA_TYPE.DOUBLE, (OP_TYPE)OP_TYPE.CONTINUOUS, (KiePMMLExpression)kiePMMLApply).build();
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(this.getDerivedFields(), new ArrayList<KiePMMLNameValue>());
        Object retrieved = derivedField.evaluate(processingDTO);
        Double expected = value1 / value2;
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    private List<KiePMMLNameValue> getKiePMMLNameValues() {
        return Arrays.asList(new KiePMMLNameValue(PARAM_1, (Object)value1), new KiePMMLNameValue(PARAM_2, (Object)value2));
    }

    private List<KiePMMLDerivedField> getDerivedFields() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant(PARAM_1, Collections.emptyList(), (Object)value1, null);
        KiePMMLDerivedField derivedField1 = (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)PARAM_1, Collections.emptyList(), (DATA_TYPE)DATA_TYPE.DOUBLE, (OP_TYPE)OP_TYPE.CONTINUOUS, (KiePMMLExpression)kiePMMLConstant1).build();
        KiePMMLConstant kiePMMLConstant2 = new KiePMMLConstant(PARAM_2, Collections.emptyList(), (Object)value2, null);
        KiePMMLDerivedField derivedField2 = (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)PARAM_2, Collections.emptyList(), (DATA_TYPE)DATA_TYPE.DOUBLE, (OP_TYPE)OP_TYPE.CONTINUOUS, (KiePMMLExpression)kiePMMLConstant2).build();
        return Arrays.asList(derivedField1, derivedField2);
    }
}

